/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.FS;

public class LockFile {
    static final String SUFFIX = ".lock";
    static final FilenameFilter FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return !name.endsWith(LockFile.SUFFIX);
        }
    };
    private final File ref;
    private final File lck;
    private FileLock fLck;
    private boolean haveLck;
    private FileOutputStream os;
    private boolean needStatInformation;
    private long commitLastModified;
    private final FS fs;

    public LockFile(File f, FS fs) {
        this.ref = f;
        this.lck = new File(this.ref.getParentFile(), String.valueOf(this.ref.getName()) + SUFFIX);
        this.fs = fs;
    }

    public boolean lock() throws IOException {
        this.lck.getParentFile().mkdirs();
        if (this.lck.createNewFile()) {
            this.haveLck = true;
            try {
                this.os = new FileOutputStream(this.lck);
                try {
                    this.fLck = this.os.getChannel().tryLock();
                    if (this.fLck == null) {
                        throw new OverlappingFileLockException();
                    }
                }
                catch (OverlappingFileLockException overlappingFileLockException) {
                    this.haveLck = false;
                    try {
                        this.os.close();
                    }
                    catch (IOException iOException) {}
                    this.os = null;
                }
            }
            catch (IOException ioe) {
                this.unlock();
                throw ioe;
            }
        }
        return this.haveLck;
    }

    public boolean lockForAppend() throws IOException {
        if (!this.lock()) {
            return false;
        }
        this.copyCurrentContent();
        return true;
    }

    public void copyCurrentContent() throws IOException {
        this.requireLock();
        try {
            FileInputStream fis = new FileInputStream(this.ref);
            try {
                int r;
                byte[] buf = new byte[2048];
                while ((r = fis.read(buf)) >= 0) {
                    this.os.write(buf, 0, r);
                }
            }
            finally {
                fis.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (Error ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public void write(ObjectId id) throws IOException {
        this.requireLock();
        try {
            BufferedOutputStream b = new BufferedOutputStream(this.os, 41);
            id.copyTo(b);
            b.write(10);
            b.flush();
            this.fLck.release();
            b.close();
            this.os = null;
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (Error ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public void write(byte[] content) throws IOException {
        this.requireLock();
        try {
            this.os.write(content);
            this.os.flush();
            this.fLck.release();
            this.os.close();
            this.os = null;
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (RuntimeException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (Error ioe) {
            this.unlock();
            throw ioe;
        }
    }

    public OutputStream getOutputStream() {
        this.requireLock();
        return new OutputStream(){

            public void write(byte[] b, int o, int n) throws IOException {
                LockFile.this.os.write(b, o, n);
            }

            public void write(byte[] b) throws IOException {
                LockFile.this.os.write(b);
            }

            public void write(int b) throws IOException {
                LockFile.this.os.write(b);
            }

            public void flush() throws IOException {
                LockFile.this.os.flush();
            }

            public void close() throws IOException {
                try {
                    LockFile.this.os.flush();
                    LockFile.this.fLck.release();
                    LockFile.this.os.close();
                    LockFile.this.os = null;
                }
                catch (IOException ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
                catch (RuntimeException ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
                catch (Error ioe) {
                    LockFile.this.unlock();
                    throw ioe;
                }
            }
        };
    }

    private void requireLock() {
        if (this.os == null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotHeld, this.ref));
        }
    }

    public void setNeedStatInformation(boolean on) {
        this.needStatInformation = on;
    }

    public void waitForStatChange() throws InterruptedException {
        if (this.ref.length() == this.lck.length()) {
            long otime = this.ref.lastModified();
            long ntime = this.lck.lastModified();
            while (otime == ntime) {
                Thread.sleep(25L);
                this.lck.setLastModified(System.currentTimeMillis());
                ntime = this.lck.lastModified();
            }
        }
    }

    public boolean commit() {
        if (this.os != null) {
            this.unlock();
            throw new IllegalStateException(MessageFormat.format(JGitText.get().lockOnNotClosed, this.ref));
        }
        this.saveStatInformation();
        if (this.lck.renameTo(this.ref)) {
            return true;
        }
        if ((!this.ref.exists() || this.deleteRef()) && this.lck.renameTo(this.ref)) {
            return true;
        }
        this.unlock();
        return false;
    }

    private boolean deleteRef() {
        if (!this.fs.retryFailedLockFileCommit()) {
            return this.ref.delete();
        }
        int attempts = 0;
        while (attempts < 10) {
            if (this.ref.delete()) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            ++attempts;
        }
        return false;
    }

    private void saveStatInformation() {
        if (this.needStatInformation) {
            this.commitLastModified = this.lck.lastModified();
        }
    }

    public long getCommitLastModified() {
        return this.commitLastModified;
    }

    public void unlock() {
        if (this.os != null) {
            if (this.fLck != null) {
                try {
                    this.fLck.release();
                }
                catch (IOException iOException) {}
                this.fLck = null;
            }
            try {
                this.os.close();
            }
            catch (IOException iOException) {}
            this.os = null;
        }
        if (this.haveLck) {
            this.haveLck = false;
            this.lck.delete();
        }
    }

    public String toString() {
        return "LockFile[" + this.lck + ", haveLck=" + this.haveLck + "]";
    }
}

