/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.lang.ref.SoftReference;
import org.eclipse.jgit.storage.file.PackFile;
import org.eclipse.jgit.storage.file.WindowCacheConfig;

class UnpackedObjectCache {
    private static final int CACHE_SZ = 1024;
    private static final SoftReference<Entry> DEAD = new SoftReference<Object>(null);
    private static int maxByteCount = new WindowCacheConfig().getDeltaBaseCacheLimit();
    private static final Slot[] cache = new Slot[1024];
    private static Slot lruHead;
    private static Slot lruTail;
    private static int openByteCount;

    static {
        int i = 0;
        while (i < 1024) {
            UnpackedObjectCache.cache[i] = new Slot();
            ++i;
        }
    }

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    static synchronized void reconfigure(WindowCacheConfig cfg) {
        int dbLimit = cfg.getDeltaBaseCacheLimit();
        if (maxByteCount != dbLimit) {
            maxByteCount = dbLimit;
            UnpackedObjectCache.releaseMemory();
        }
    }

    static synchronized Entry get(PackFile pack, long position) {
        Entry buf;
        Slot e = cache[UnpackedObjectCache.hash(position)];
        if (e.provider == pack && e.position == position && (buf = e.data.get()) != null) {
            UnpackedObjectCache.moveToHead(e);
            return buf;
        }
        return null;
    }

    static synchronized void store(PackFile pack, long position, byte[] data, int objectType) {
        if (data.length > maxByteCount) {
            return;
        }
        Slot e = cache[UnpackedObjectCache.hash(position)];
        UnpackedObjectCache.clearEntry(e);
        openByteCount += data.length;
        UnpackedObjectCache.releaseMemory();
        e.provider = pack;
        e.position = position;
        e.sz = data.length;
        e.data = new SoftReference<Entry>(new Entry(data, objectType));
        UnpackedObjectCache.moveToHead(e);
    }

    private static void releaseMemory() {
        while (openByteCount > maxByteCount && lruTail != null) {
            Slot currOldest = lruTail;
            Slot nextOldest = currOldest.lruPrev;
            UnpackedObjectCache.clearEntry(currOldest);
            currOldest.lruPrev = null;
            currOldest.lruNext = null;
            if (nextOldest == null) {
                lruHead = null;
            } else {
                nextOldest.lruNext = null;
            }
            lruTail = nextOldest;
        }
    }

    static synchronized void purge(PackFile file) {
        Slot[] slotArray = cache;
        int n = cache.length;
        int n2 = 0;
        while (n2 < n) {
            Slot e = slotArray[n2];
            if (e.provider == file) {
                UnpackedObjectCache.clearEntry(e);
                UnpackedObjectCache.unlink(e);
            }
            ++n2;
        }
    }

    private static void moveToHead(Slot e) {
        UnpackedObjectCache.unlink(e);
        e.lruPrev = null;
        e.lruNext = lruHead;
        if (lruHead != null) {
            UnpackedObjectCache.lruHead.lruPrev = e;
        } else {
            lruTail = e;
        }
        lruHead = e;
    }

    private static void unlink(Slot e) {
        Slot prev = e.lruPrev;
        Slot next = e.lruNext;
        if (prev != null) {
            prev.lruNext = next;
        }
        if (next != null) {
            next.lruPrev = prev;
        }
    }

    private static void clearEntry(Slot e) {
        openByteCount -= e.sz;
        e.provider = null;
        e.data = DEAD;
        e.sz = 0;
    }

    private UnpackedObjectCache() {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ SoftReference access$0() {
        return DEAD;
    }

    static class Entry {
        final byte[] data;
        final int type;

        Entry(byte[] aData, int aType) {
            this.data = aData;
            this.type = aType;
        }
    }

    private static class Slot {
        Slot lruPrev;
        Slot lruNext;
        PackFile provider;
        long position;
        int sz;
        SoftReference<Entry> data = UnpackedObjectCache.access$0();

        private Slot() {
        }
    }
}

