/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import org.eclipse.jgit.lib.Config;

class PackConfig {
    static final Config.SectionParser<PackConfig> KEY = new Config.SectionParser<PackConfig>(){

        @Override
        public PackConfig parse(Config cfg) {
            return new PackConfig(cfg, null);
        }
    };
    final int deltaWindow;
    final long deltaWindowMemory;
    final int deltaDepth;
    final long deltaCacheSize;
    final int deltaCacheLimit;
    final int compression;
    final int indexVersion;
    final long bigFileThreshold;
    final int threads;

    private PackConfig(Config rc) {
        this.deltaWindow = rc.getInt("pack", "window", 10);
        this.deltaWindowMemory = rc.getLong("pack", null, "windowmemory", 0L);
        this.deltaCacheSize = rc.getLong("pack", null, "deltacachesize", 0x3200000L);
        this.deltaCacheLimit = rc.getInt("pack", "deltacachelimit", 100);
        this.deltaDepth = rc.getInt("pack", "depth", 50);
        this.compression = PackConfig.compression(rc);
        this.indexVersion = rc.getInt("pack", "indexversion", 2);
        this.bigFileThreshold = rc.getLong("core", null, "bigfilethreshold", 0x3200000L);
        this.threads = rc.getInt("pack", "threads", 0);
    }

    private static int compression(Config rc) {
        if (rc.getString("pack", null, "compression") != null) {
            return rc.getInt("pack", "compression", -1);
        }
        return rc.getInt("core", "compression", -1);
    }

    /* synthetic */ PackConfig(Config config, PackConfig packConfig) {
        this(config);
    }
}

