/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.storage.file.PackIndexWriter;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaIndex;
import org.eclipse.jgit.storage.pack.DeltaWindow;
import org.eclipse.jgit.storage.pack.ObjectReuseAsIs;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.storage.pack.ThreadSafeDeltaCache;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.TemporaryBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackWriter {
    public static final String COUNTING_OBJECTS_PROGRESS = JGitText.get().countingObjects;
    public static final String COMPRESSING_OBJECTS_PROGRESS = JGitText.get().compressingObjects;
    public static final String WRITING_OBJECTS_PROGRESS = JGitText.get().writingObjects;
    public static final boolean DEFAULT_REUSE_DELTAS = true;
    public static final boolean DEFAULT_REUSE_OBJECTS = true;
    public static final boolean DEFAULT_DELTA_BASE_AS_OFFSET = false;
    public static final int DEFAULT_MAX_DELTA_DEPTH = 50;
    public static final int DEFAULT_DELTA_SEARCH_WINDOW_SIZE = 10;
    static final long DEFAULT_BIG_FILE_THRESHOLD = 0x3200000L;
    static final long DEFAULT_DELTA_CACHE_SIZE = 0x3200000L;
    static final int DEFAULT_DELTA_CACHE_LIMIT = 100;
    private static final int PACK_VERSION_GENERATED = 2;
    private final List<ObjectToPack>[] objectsLists = new List[5];
    private final ObjectIdSubclassMap<ObjectToPack> objectsMap;
    private final ObjectIdSubclassMap<ObjectToPack> edgeObjects;
    private int compressionLevel;
    private Deflater myDeflater;
    private final ObjectReader reader;
    private final ObjectReuseAsIs reuseSupport;
    private List<ObjectToPack> sortedByName;
    private byte[] packcsum;
    private boolean reuseDeltas;
    private boolean reuseObjects;
    private boolean deltaBaseAsOffset;
    private boolean deltaCompress;
    private int maxDeltaDepth;
    private int deltaSearchWindowSize;
    private long deltaSearchMemoryLimit;
    private long deltaCacheSize;
    private int deltaCacheLimit;
    private int indexVersion;
    private long bigFileThreshold;
    private int threads;
    private boolean thin;
    private boolean ignoreMissingUninteresting;

    public PackWriter(Repository repo) {
        this(repo, repo.newObjectReader());
    }

    public PackWriter(ObjectReader reader) {
        this(null, reader);
    }

    public PackWriter(Repository repo, ObjectReader reader) {
        this.objectsLists[0] = Collections.emptyList();
        this.objectsLists[1] = new ArrayList<ObjectToPack>();
        this.objectsLists[2] = new ArrayList<ObjectToPack>();
        this.objectsLists[3] = new ArrayList<ObjectToPack>();
        this.objectsLists[4] = new ArrayList<ObjectToPack>();
        this.objectsMap = new ObjectIdSubclassMap();
        this.edgeObjects = new ObjectIdSubclassMap();
        this.reuseDeltas = true;
        this.reuseObjects = true;
        this.deltaBaseAsOffset = false;
        this.deltaCompress = true;
        this.maxDeltaDepth = 50;
        this.deltaSearchWindowSize = 10;
        this.deltaCacheSize = 0x3200000L;
        this.deltaCacheLimit = 100;
        this.bigFileThreshold = 0x3200000L;
        this.threads = 1;
        this.ignoreMissingUninteresting = true;
        this.reader = reader;
        this.reuseSupport = reader instanceof ObjectReuseAsIs ? (ObjectReuseAsIs)((Object)reader) : null;
        PackConfig pc = PackWriter.configOf(repo).get(PackConfig.KEY);
        this.deltaSearchWindowSize = pc.deltaWindow;
        this.deltaSearchMemoryLimit = pc.deltaWindowMemory;
        this.deltaCacheSize = pc.deltaCacheSize;
        this.deltaCacheLimit = pc.deltaCacheLimit;
        this.maxDeltaDepth = pc.deltaDepth;
        this.compressionLevel = pc.compression;
        this.indexVersion = pc.indexVersion;
        this.bigFileThreshold = pc.bigFileThreshold;
        this.threads = pc.threads;
    }

    private static Config configOf(Repository repo) {
        if (repo == null) {
            return new Config();
        }
        return repo.getConfig();
    }

    public boolean isReuseDeltas() {
        return this.reuseDeltas;
    }

    public void setReuseDeltas(boolean reuseDeltas) {
        this.reuseDeltas = reuseDeltas;
    }

    public boolean isReuseObjects() {
        return this.reuseObjects;
    }

    public void setReuseObjects(boolean reuseObjects) {
        this.reuseObjects = reuseObjects;
    }

    public boolean isDeltaBaseAsOffset() {
        return this.deltaBaseAsOffset;
    }

    public void setDeltaBaseAsOffset(boolean deltaBaseAsOffset) {
        this.deltaBaseAsOffset = deltaBaseAsOffset;
    }

    public boolean isDeltaCompress() {
        return this.deltaCompress;
    }

    public void setDeltaCompress(boolean deltaCompress) {
        this.deltaCompress = deltaCompress;
    }

    public int getMaxDeltaDepth() {
        return this.maxDeltaDepth;
    }

    public void setMaxDeltaDepth(int maxDeltaDepth) {
        this.maxDeltaDepth = maxDeltaDepth;
    }

    public int getDeltaSearchWindowSize() {
        return this.deltaSearchWindowSize;
    }

    public void setDeltaSearchWindowSize(int objectCount) {
        if (objectCount <= 2) {
            this.setDeltaCompress(false);
        } else {
            this.deltaSearchWindowSize = objectCount;
        }
    }

    public long getDeltaSearchMemoryLimit() {
        return this.deltaSearchMemoryLimit;
    }

    public void setDeltaSearchMemoryLimit(long memoryLimit) {
        this.deltaSearchMemoryLimit = memoryLimit;
    }

    public long getDeltaCacheSize() {
        return this.deltaCacheSize;
    }

    public void setDeltaCacheSize(long size) {
        this.deltaCacheSize = size;
    }

    public int getDeltaCacheLimit() {
        return this.deltaCacheLimit;
    }

    public void setDeltaCacheLimit(int size) {
        this.deltaCacheLimit = size;
    }

    public long getBigFileThreshold() {
        return this.bigFileThreshold;
    }

    public void setBigFileThreshold(long bigFileThreshold) {
        this.bigFileThreshold = bigFileThreshold;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int level) {
        this.compressionLevel = level;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThread(int threads) {
        this.threads = threads;
    }

    public boolean isThin() {
        return this.thin;
    }

    public void setThin(boolean packthin) {
        this.thin = packthin;
    }

    public boolean isIgnoreMissingUninteresting() {
        return this.ignoreMissingUninteresting;
    }

    public void setIgnoreMissingUninteresting(boolean ignore) {
        this.ignoreMissingUninteresting = ignore;
    }

    public void setIndexVersion(int version) {
        this.indexVersion = version;
    }

    public int getObjectsNumber() {
        return this.objectsMap.size();
    }

    public void preparePack(Iterator<RevObject> objectsSource) throws IOException {
        while (objectsSource.hasNext()) {
            this.addObject(objectsSource.next());
        }
    }

    public void preparePack(ProgressMonitor countingMonitor, Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects) throws IOException {
        if (countingMonitor == null) {
            countingMonitor = NullProgressMonitor.INSTANCE;
        }
        ObjectWalk walker = this.setUpWalker(interestingObjects, uninterestingObjects);
        this.findObjectsToPack(countingMonitor, walker);
    }

    public boolean willInclude(AnyObjectId id) {
        return this.objectsMap.get(id) != null;
    }

    public ObjectId computeName() {
        byte[] buf = new byte[20];
        MessageDigest md = Constants.newMessageDigest();
        for (ObjectToPack otp : this.sortByName()) {
            otp.copyRawTo(buf, 0);
            md.update(buf, 0, 20);
        }
        return ObjectId.fromRaw(md.digest());
    }

    public void writeIndex(OutputStream indexStream) throws IOException {
        List<ObjectToPack> list = this.sortByName();
        PackIndexWriter iw = this.indexVersion <= 0 ? PackIndexWriter.createOldestPossible(indexStream, list) : PackIndexWriter.createVersion(indexStream, this.indexVersion);
        iw.write(list, this.packcsum);
    }

    private List<ObjectToPack> sortByName() {
        if (this.sortedByName == null) {
            this.sortedByName = new ArrayList<ObjectToPack>(this.objectsMap.size());
            List<ObjectToPack>[] listArray = this.objectsLists;
            int n = this.objectsLists.length;
            int n2 = 0;
            while (n2 < n) {
                List<ObjectToPack> list = listArray[n2];
                for (ObjectToPack otp : list) {
                    this.sortedByName.add(otp);
                }
                ++n2;
            }
            Collections.sort(this.sortedByName);
        }
        return this.sortedByName;
    }

    public void writePack(ProgressMonitor compressMonitor, ProgressMonitor writeMonitor, OutputStream packStream) throws IOException {
        if (compressMonitor == null) {
            compressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (writeMonitor == null) {
            writeMonitor = NullProgressMonitor.INSTANCE;
        }
        if ((this.reuseDeltas || this.reuseObjects) && this.reuseSupport != null) {
            this.searchForReuse();
        }
        if (this.deltaCompress) {
            this.searchForDeltas(compressMonitor);
        }
        PackOutputStream out = new PackOutputStream(writeMonitor, packStream, this);
        writeMonitor.beginTask(WRITING_OBJECTS_PROGRESS, this.getObjectsNumber());
        out.writeFileHeader(2, this.getObjectsNumber());
        this.writeObjects(writeMonitor, out);
        this.writeChecksum(out);
        this.reader.release();
        writeMonitor.endTask();
    }

    public void release() {
        this.reader.release();
        if (this.myDeflater != null) {
            this.myDeflater.end();
            this.myDeflater = null;
        }
    }

    private void searchForReuse() throws IOException {
        List<ObjectToPack>[] listArray = this.objectsLists;
        int n = this.objectsLists.length;
        int n2 = 0;
        while (n2 < n) {
            List<ObjectToPack> list = listArray[n2];
            for (ObjectToPack otp : list) {
                this.reuseSupport.selectObjectRepresentation(this, otp);
            }
            ++n2;
        }
    }

    private void searchForDeltas(ProgressMonitor monitor) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectToPack[] list = new ObjectToPack[this.objectsLists[2].size() + this.objectsLists[3].size() + this.edgeObjects.size()];
        int cnt = 0;
        cnt = this.findObjectsNeedingDelta(list, cnt, 2);
        if ((cnt = this.findObjectsNeedingDelta(list, cnt, 3)) == 0) {
            return;
        }
        for (ObjectToPack eo : this.edgeObjects) {
            try {
                if (!this.loadSize(eo)) continue;
                list[cnt++] = eo;
            }
            catch (IOException notAvailable) {
                if (this.ignoreMissingUninteresting) continue;
                throw notAvailable;
            }
        }
        monitor.beginTask(COMPRESSING_OBJECTS_PROGRESS, cnt);
        Arrays.sort(list, 0, cnt, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                int cmp = a.getType() - b.getType();
                if (cmp == 0) {
                    cmp = (a.getPathHash() >>> 1) - (b.getPathHash() >>> 1);
                }
                if (cmp == 0) {
                    cmp = (a.getPathHash() & 1) - (b.getPathHash() & 1);
                }
                if (cmp == 0) {
                    cmp = b.getWeight() - a.getWeight();
                }
                return cmp;
            }
        });
        this.searchForDeltas(monitor, list, cnt);
        monitor.endTask();
    }

    private int findObjectsNeedingDelta(ObjectToPack[] list, int cnt, int type) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        for (ObjectToPack otp : this.objectsLists[type]) {
            if (otp.isDoNotDelta() || otp.isDeltaRepresentation() || !this.loadSize(otp)) continue;
            list[cnt++] = otp;
        }
        return cnt;
    }

    private boolean loadSize(ObjectToPack e) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.reader.getObjectSize(e, e.getType());
        if (this.bigFileThreshold <= sz || Integer.MAX_VALUE <= sz) {
            return false;
        }
        if (sz <= 16L) {
            return false;
        }
        e.setWeight((int)sz);
        return true;
    }

    private void searchForDeltas(ProgressMonitor monitor, final ObjectToPack[] list, int cnt) throws MissingObjectException, IncorrectObjectTypeException, LargeObjectException, IOException {
        if (this.threads == 0) {
            this.threads = Runtime.getRuntime().availableProcessors();
        }
        if (this.threads <= 1 || cnt <= 2 * this.getDeltaSearchWindowSize()) {
            DeltaCache dc = new DeltaCache(this);
            DeltaWindow dw = new DeltaWindow(this, dc, this.reader);
            dw.search(monitor, list, 0, cnt);
            return;
        }
        final List errors = Collections.synchronizedList(new ArrayList());
        final ThreadSafeDeltaCache dc = new ThreadSafeDeltaCache(this);
        final ThreadSafeProgressMonitor pm = new ThreadSafeProgressMonitor(monitor);
        ExecutorService pool = Executors.newFixedThreadPool(this.threads);
        int estSize = cnt / (this.threads * 2);
        if (estSize < 2 * this.getDeltaSearchWindowSize()) {
            estSize = 2 * this.getDeltaSearchWindowSize();
        }
        int i = 0;
        while (i < cnt) {
            int batchSize;
            final int start = i;
            if (cnt - i < estSize) {
                batchSize = cnt - i;
            } else {
                int end = start + estSize;
                while (end < cnt) {
                    ObjectToPack a = list[end - 1];
                    ObjectToPack b = list[end];
                    if (a.getPathHash() != b.getPathHash()) break;
                    ++end;
                }
                batchSize = end - start;
            }
            i += batchSize;
            pool.submit(new Runnable(){

                public void run() {
                    try {
                        ObjectReader or = PackWriter.this.reader.newReader();
                        try {
                            DeltaWindow dw = new DeltaWindow(PackWriter.this, dc, or);
                            dw.search(pm, list, start, batchSize);
                        }
                        finally {
                            or.release();
                        }
                    }
                    catch (Throwable err) {
                        errors.add(err);
                    }
                }
            });
        }
        pool.shutdown();
        try {
            while (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
        }
        if (!errors.isEmpty()) {
            Throwable err = (Throwable)errors.get(0);
            if (err instanceof Error) {
                throw (Error)err;
            }
            if (err instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            if (err instanceof IOException) {
                throw (IOException)err;
            }
            IOException fail = new IOException(err.getMessage());
            fail.initCause(err);
            throw fail;
        }
    }

    private void writeObjects(ProgressMonitor writeMonitor, PackOutputStream out) throws IOException {
        List<ObjectToPack>[] listArray = this.objectsLists;
        int n = this.objectsLists.length;
        int n2 = 0;
        while (n2 < n) {
            List<ObjectToPack> list = listArray[n2];
            for (ObjectToPack otp : list) {
                if (writeMonitor.isCancelled()) {
                    throw new IOException(JGitText.get().packingCancelledDuringObjectsWriting);
                }
                if (otp.isWritten()) continue;
                this.writeObject(out, otp);
            }
            ++n2;
        }
    }

    private void writeObject(PackOutputStream out, ObjectToPack otp) throws IOException {
        if (otp.isWritten()) {
            return;
        }
        otp.markWantWrite();
        if (otp.isDeltaRepresentation()) {
            this.writeBaseFirst(out, otp);
        }
        out.resetCRC32();
        otp.setOffset(out.length());
        while (otp.isReuseAsIs()) {
            try {
                this.reuseSupport.copyObjectAsIs(out, otp);
                out.endObject();
                otp.setCRC(out.getCRC32());
                return;
            }
            catch (StoredObjectRepresentationNotAvailableException gone) {
                if (otp.getOffset() == out.length()) {
                    this.redoSearchForReuse(otp);
                    continue;
                }
                CorruptObjectException coe = new CorruptObjectException(otp, "");
                coe.initCause(gone);
                throw coe;
            }
        }
        if (otp.isDeltaRepresentation()) {
            this.writeDeltaObjectDeflate(out, otp);
        } else {
            this.writeWholeObjectDeflate(out, otp);
        }
        out.endObject();
        otp.setCRC(out.getCRC32());
    }

    private void writeBaseFirst(PackOutputStream out, ObjectToPack otp) throws IOException {
        ObjectToPack baseInPack = otp.getDeltaBase();
        if (baseInPack != null) {
            if (!baseInPack.isWritten()) {
                if (baseInPack.wantWrite()) {
                    this.reuseDeltas = false;
                    this.redoSearchForReuse(otp);
                    this.reuseDeltas = true;
                } else {
                    this.writeObject(out, baseInPack);
                }
            }
        } else if (!this.thin) {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
    }

    private void redoSearchForReuse(ObjectToPack otp) throws IOException, MissingObjectException {
        otp.clearDeltaBase();
        otp.clearReuseAsIs();
        this.reuseSupport.selectObjectRepresentation(this, otp);
    }

    private void writeWholeObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        Deflater deflater = this.deflater();
        ObjectLoader ldr = this.reader.open(otp, otp.getType());
        out.writeHeader(otp, ldr.getSize());
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        ldr.copyTo(dst);
        dst.finish();
    }

    private void writeDeltaObjectDeflate(PackOutputStream out, ObjectToPack otp) throws IOException {
        byte[] zbuf;
        DeltaCache.Ref ref = otp.popCachedDelta();
        if (ref != null && (zbuf = (byte[])ref.get()) != null) {
            out.writeHeader(otp, otp.getCachedSize());
            out.write(zbuf);
            return;
        }
        TemporaryBuffer.Heap delta = this.delta(otp);
        out.writeHeader(otp, delta.length());
        Deflater deflater = this.deflater();
        deflater.reset();
        DeflaterOutputStream dst = new DeflaterOutputStream((OutputStream)out, deflater);
        delta.writeTo(dst, null);
        dst.finish();
    }

    private TemporaryBuffer.Heap delta(ObjectToPack otp) throws IOException {
        DeltaIndex index = new DeltaIndex(this.buffer(this.reader, otp.getDeltaBaseId()));
        byte[] res = this.buffer(this.reader, otp);
        TemporaryBuffer.Heap delta = new TemporaryBuffer.Heap(res.length);
        index.encode(delta, res);
        return delta;
    }

    byte[] buffer(ObjectReader or, AnyObjectId objId) throws IOException {
        byte[] buf;
        ObjectLoader ldr = or.open(objId);
        if (!ldr.isLarge()) {
            return ldr.getCachedBytes();
        }
        long sz = ldr.getSize();
        if (this.getBigFileThreshold() <= sz || Integer.MAX_VALUE < sz) {
            throw new LargeObjectException(objId.copy());
        }
        try {
            buf = new byte[(int)sz];
        }
        catch (OutOfMemoryError noMemory) {
            LargeObjectException e = new LargeObjectException(objId.copy());
            e.initCause(noMemory);
            throw e;
        }
        ObjectStream in = ldr.openStream();
        try {
            IO.readFully(in, buf, 0, buf.length);
        }
        finally {
            in.close();
        }
        return buf;
    }

    private Deflater deflater() {
        if (this.myDeflater == null) {
            this.myDeflater = new Deflater(this.compressionLevel);
        }
        return this.myDeflater;
    }

    private void writeChecksum(PackOutputStream out) throws IOException {
        this.packcsum = out.getDigest();
        out.write(this.packcsum);
    }

    private ObjectWalk setUpWalker(Collection<? extends ObjectId> interestingObjects, Collection<? extends ObjectId> uninterestingObjects) throws MissingObjectException, IOException, IncorrectObjectTypeException {
        RevObject o;
        ObjectWalk walker = new ObjectWalk(this.reader);
        walker.setRetainBody(false);
        walker.sort(RevSort.COMMIT_TIME_DESC);
        if (this.thin) {
            walker.sort(RevSort.BOUNDARY, true);
        }
        for (ObjectId objectId : interestingObjects) {
            o = walker.parseAny(objectId);
            walker.markStart(o);
        }
        if (uninterestingObjects != null) {
            for (ObjectId objectId : uninterestingObjects) {
                try {
                    o = walker.parseAny(objectId);
                }
                catch (MissingObjectException x) {
                    if (this.ignoreMissingUninteresting) continue;
                    throw x;
                }
                walker.markUninteresting(o);
            }
        }
        return walker;
    }

    private void findObjectsToPack(ProgressMonitor countingMonitor, ObjectWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevObject o;
        countingMonitor.beginTask(COUNTING_OBJECTS_PROGRESS, 0);
        while ((o = walker.next()) != null) {
            this.addObject(o, 0);
            countingMonitor.update(1);
        }
        while ((o = walker.nextObject()) != null) {
            this.addObject(o, walker.getPathHashCode());
            countingMonitor.update(1);
        }
        countingMonitor.endTask();
    }

    public void addObject(RevObject object) throws IncorrectObjectTypeException {
        this.addObject(object, 0);
    }

    private void addObject(RevObject object, int pathHashCode) throws IncorrectObjectTypeException {
        if (object.has(RevFlag.UNINTERESTING)) {
            switch (object.getType()) {
                case 2: 
                case 3: {
                    ObjectToPack otp = new ObjectToPack(object);
                    otp.setPathHash(pathHashCode);
                    otp.setDoNotDelta(true);
                    this.edgeObjects.add(otp);
                    this.thin = true;
                }
            }
            return;
        }
        ObjectToPack otp = this.reuseSupport != null ? this.reuseSupport.newObjectToPack(object) : new ObjectToPack(object);
        otp.setPathHash(pathHashCode);
        try {
            this.objectsLists[object.getType()].add(otp);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IncorrectObjectTypeException((ObjectId)object, JGitText.get().incorrectObjectType_COMMITnorTREEnorBLOBnorTAG);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new IncorrectObjectTypeException((ObjectId)object, JGitText.get().incorrectObjectType_COMMITnorTREEnorBLOBnorTAG);
        }
        this.objectsMap.add(otp);
    }

    public void select(ObjectToPack otp, StoredObjectRepresentation next) {
        int nWeight;
        int nFmt = next.getFormat();
        if (otp.isReuseAsIs()) {
            if (1 < nFmt) {
                return;
            }
            if (nFmt > 0 && otp.isDeltaRepresentation()) {
                return;
            }
            nWeight = next.getWeight();
            if (otp.getWeight() <= nWeight) {
                return;
            }
        } else {
            nWeight = next.getWeight();
        }
        if (nFmt == 0 && this.reuseDeltas) {
            ObjectId baseId = next.getDeltaBase();
            ObjectToPack ptr = this.objectsMap.get(baseId);
            if (ptr != null) {
                otp.setDeltaBase(ptr);
                otp.setReuseAsIs();
                otp.setWeight(nWeight);
            } else if (this.thin && this.edgeObjects.contains(baseId)) {
                otp.setDeltaBase(baseId);
                otp.setReuseAsIs();
                otp.setWeight(nWeight);
            } else {
                otp.clearDeltaBase();
                otp.clearReuseAsIs();
            }
        } else if (nFmt == 1 && this.reuseObjects) {
            otp.clearDeltaBase();
            otp.setReuseAsIs();
            otp.setWeight(nWeight);
        } else {
            otp.clearDeltaBase();
            otp.clearReuseAsIs();
        }
        otp.select(next);
    }
}

