/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.DaemonClient;

public abstract class DaemonService {
    private final String command;
    private final Config.SectionParser<ServiceConfig> configKey;
    private boolean enabled;
    private boolean overridable;

    DaemonService(String cmdName, final String cfgName) {
        this.command = cmdName.startsWith("git-") ? cmdName : "git-" + cmdName;
        this.configKey = new Config.SectionParser<ServiceConfig>(){

            @Override
            public ServiceConfig parse(Config cfg) {
                return new ServiceConfig(DaemonService.this, cfg, cfgName);
            }
        };
        this.overridable = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean on) {
        this.enabled = on;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean on) {
        this.overridable = on;
    }

    public String getCommandName() {
        return this.command;
    }

    public boolean handles(String commandLine) {
        return this.command.length() + 1 < commandLine.length() && commandLine.charAt(this.command.length()) == ' ' && commandLine.startsWith(this.command);
    }

    void execute(DaemonClient client, String commandLine) throws IOException {
        String name = commandLine.substring(this.command.length() + 1);
        Repository db = client.getDaemon().openRepository(name);
        if (db == null) {
            return;
        }
        try {
            if (this.isEnabledFor(db)) {
                this.execute(client, db);
            }
        }
        finally {
            db.close();
        }
    }

    private boolean isEnabledFor(Repository db) {
        if (this.isOverridable()) {
            return db.getConfig().get(this.configKey).enabled;
        }
        return this.isEnabled();
    }

    abstract void execute(DaemonClient var1, Repository var2) throws IOException;

    private static class ServiceConfig {
        final boolean enabled;

        ServiceConfig(DaemonService service, Config cfg, String name) {
            this.enabled = cfg.getBoolean("daemon", name, service.isEnabled());
        }
    }
}

