/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.util.RefMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefAdvertiser {
    private RevWalk walk;
    private RevFlag ADVERTISED;
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    private final Set<String> capablities = new LinkedHashSet<String>();
    private boolean derefTags;
    private boolean first = true;

    public void init(RevWalk protoWalk, RevFlag advertisedFlag) {
        this.walk = protoWalk;
        this.ADVERTISED = advertisedFlag;
    }

    public void setDerefTags(boolean deref) {
        this.derefTags = deref;
    }

    public void advertiseCapability(String name) {
        this.capablities.add(name);
    }

    public void send(Map<String, Ref> refs) throws IOException {
        for (Ref r : this.getSortedRefs(refs)) {
            RevObject obj = this.parseAnyOrNull(r.getObjectId());
            if (obj == null) continue;
            this.advertiseAny(obj, r.getName());
            if (!this.derefTags || !(obj instanceof RevTag)) continue;
            this.advertiseTag((RevTag)obj, String.valueOf(r.getName()) + "^{}");
        }
    }

    private Iterable<Ref> getSortedRefs(Map<String, Ref> all) {
        if (all instanceof RefMap || all instanceof SortedMap && ((SortedMap)all).comparator() == null) {
            return all.values();
        }
        return RefComparator.sort(all.values());
    }

    public void advertiseHave(AnyObjectId id) throws IOException {
        RevObject obj = this.parseAnyOrNull(id);
        if (obj != null) {
            this.advertiseAnyOnce(obj, ".have");
            if (obj instanceof RevTag) {
                this.advertiseAnyOnce(((RevTag)obj).getObject(), ".have");
            }
        }
    }

    public void includeAdditionalHaves(Repository src) throws IOException {
        for (ObjectId id : src.getAdditionalHaves()) {
            this.advertiseHave(id);
        }
    }

    public boolean isEmpty() {
        return this.first;
    }

    private RevObject parseAnyOrNull(AnyObjectId id) {
        if (id == null) {
            return null;
        }
        try {
            return this.walk.parseAny(id);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void advertiseAnyOnce(RevObject obj, String refName) throws IOException {
        if (!obj.has(this.ADVERTISED)) {
            this.advertiseAny(obj, refName);
        }
    }

    private void advertiseAny(RevObject obj, String refName) throws IOException {
        obj.add(this.ADVERTISED);
        this.advertiseId(obj, refName);
    }

    private void advertiseTag(RevTag tag, String refName) throws IOException {
        RevObject target;
        RevObject o = tag;
        do {
            target = o.getObject();
            try {
                this.walk.parseHeaders(target);
            }
            catch (IOException iOException) {
                return;
            }
            target.add(this.ADVERTISED);
        } while ((o = target) instanceof RevTag);
        this.advertiseAny(tag.getObject(), refName);
    }

    public void advertiseId(AnyObjectId id, String refName) throws IOException {
        this.tmpLine.setLength(0);
        id.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(refName);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String capName : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(capName);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.writeOne(this.tmpLine);
    }

    protected abstract void writeOne(CharSequence var1) throws IOException;

    protected abstract void end() throws IOException;

    public static class PacketLineOutRefAdvertiser
    extends RefAdvertiser {
        private final PacketLineOut pckOut;

        public PacketLineOutRefAdvertiser(PacketLineOut out) {
            this.pckOut = out;
        }

        protected void writeOne(CharSequence line) throws IOException {
            this.pckOut.writeString(line.toString());
        }

        protected void end() throws IOException {
            this.pckOut.end();
        }
    }
}

