/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackWriter;
import org.eclipse.jgit.transport.BasePackFetchConnection;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public class UploadPack {
    static final String OPTION_INCLUDE_TAG = "include-tag";
    static final String OPTION_MULTI_ACK = "multi_ack";
    static final String OPTION_MULTI_ACK_DETAILED = "multi_ack_detailed";
    static final String OPTION_THIN_PACK = "thin-pack";
    static final String OPTION_SIDE_BAND = "side-band";
    static final String OPTION_SIDE_BAND_64K = "side-band-64k";
    static final String OPTION_OFS_DELTA = "ofs-delta";
    static final String OPTION_NO_PROGRESS = "no-progress";
    private final Repository db;
    private final RevWalk walk;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private InputStream rawIn;
    private OutputStream rawOut;
    private PacketLineIn pckIn;
    private PacketLineOut pckOut;
    private Map<String, Ref> refs;
    private RefFilter refFilter;
    private final Set<String> options = new HashSet<String>();
    private final List<RevObject> wantAll = new ArrayList<RevObject>();
    private final List<RevCommit> wantCommits = new ArrayList<RevCommit>();
    private final List<RevObject> commonBase = new ArrayList<RevObject>();
    private Boolean okToGiveUp;
    private final RevFlag ADVERTISED;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlagSet SAVE;
    private BasePackFetchConnection.MultiAck multiAck = BasePackFetchConnection.MultiAck.OFF;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.ADVERTISED = this.walk.newFlag("ADVERTISED");
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.ADVERTISED);
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.refFilter = RefFilter.DEFAULT;
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setRefFilter(RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public void upload(InputStream input, OutputStream output, OutputStream messages) throws IOException {
        try {
            this.rawIn = input;
            this.rawOut = output;
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(String.valueOf(caller.getName()) + "-Timer");
                TimeoutInputStream i = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(this.rawOut, this.timer);
                i.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = i;
                this.rawOut = o;
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            this.pckOut = new PacketLineOut(this.rawOut);
            this.service();
        }
        finally {
            this.walk.release();
            if (this.timer != null) {
                try {
                    this.timer.terminate();
                }
                finally {
                    this.timer = null;
                }
            }
        }
    }

    private void service() throws IOException {
        if (this.biDirectionalPipe) {
            this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(this.pckOut));
        } else {
            this.refs = this.refFilter.filter(this.db.getAllRefs());
            for (Ref r : this.refs.values()) {
                try {
                    this.walk.parseAny(r.getObjectId()).add(this.ADVERTISED);
                }
                catch (IOException iOException) {}
            }
        }
        this.recvWants();
        if (this.wantAll.isEmpty()) {
            return;
        }
        this.multiAck = this.options.contains(OPTION_MULTI_ACK_DETAILED) ? BasePackFetchConnection.MultiAck.DETAILED : (this.options.contains(OPTION_MULTI_ACK) ? BasePackFetchConnection.MultiAck.CONTINUE : BasePackFetchConnection.MultiAck.OFF);
        if (this.negotiate()) {
            this.sendPack();
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException {
        adv.init(this.walk, this.ADVERTISED);
        adv.advertiseCapability(OPTION_INCLUDE_TAG);
        adv.advertiseCapability(OPTION_MULTI_ACK_DETAILED);
        adv.advertiseCapability(OPTION_MULTI_ACK);
        adv.advertiseCapability(OPTION_OFS_DELTA);
        adv.advertiseCapability(OPTION_SIDE_BAND);
        adv.advertiseCapability(OPTION_SIDE_BAND_64K);
        adv.advertiseCapability(OPTION_THIN_PACK);
        adv.advertiseCapability(OPTION_NO_PROGRESS);
        adv.setDerefTags(true);
        this.refs = this.refFilter.filter(this.db.getAllRefs());
        adv.send(this.refs);
        adv.end();
    }

    private void recvWants() throws IOException {
        boolean isFirst = true;
        while (true) {
            RevObject o;
            String line;
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (isFirst) break;
                throw eof;
            }
            if (line == PacketLineIn.END) break;
            if (!line.startsWith("want ") || line.length() < 45) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "want", line));
            }
            if (isFirst && line.length() > 45) {
                String opt = line.substring(45);
                if (opt.startsWith(" ")) {
                    opt = opt.substring(1);
                }
                String[] stringArray = opt.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String c = stringArray[n2];
                    this.options.add(c);
                    ++n2;
                }
                line = line.substring(0, 45);
            }
            ObjectId id = ObjectId.fromString(line.substring(5));
            try {
                o = this.walk.parseAny(id);
            }
            catch (IOException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().notValid, id.name()), e);
            }
            if (!o.has(this.ADVERTISED)) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().notValid, id.name()));
            }
            try {
                this.want(o);
            }
            catch (IOException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().notValid, id.name()), e);
            }
            isFirst = false;
        }
    }

    private void want(RevObject o) throws MissingObjectException, IOException {
        if (!o.has(this.WANT)) {
            o.add(this.WANT);
            this.wantAll.add(o);
            if (o instanceof RevCommit) {
                this.wantCommits.add((RevCommit)o);
            } else if (o instanceof RevTag && (o = this.walk.peel(o)) instanceof RevCommit) {
                this.want(o);
            }
        }
    }

    private boolean negotiate() throws IOException {
        String line;
        ObjectId last = ObjectId.zeroId();
        while (true) {
            line = this.pckIn.readString();
            if (line == PacketLineIn.END) {
                if (this.commonBase.isEmpty() || this.multiAck != BasePackFetchConnection.MultiAck.OFF) {
                    this.pckOut.writeString("NAK\n");
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                this.pckOut.flush();
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            ObjectId id = ObjectId.fromString(line.substring(5));
            if (this.matchHave(id)) {
                last = id;
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        this.pckOut.writeString("ACK " + id.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        this.pckOut.writeString("ACK " + id.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        this.pckOut.writeString("ACK " + id.name() + " common\n");
                    }
                }
                continue;
            }
            if (!this.okToGiveUp()) continue;
            switch (this.multiAck) {
                case OFF: {
                    break;
                }
                case CONTINUE: {
                    this.pckOut.writeString("ACK " + id.name() + " continue\n");
                    break;
                }
                case DETAILED: {
                    this.pckOut.writeString("ACK " + id.name() + " ready\n");
                }
            }
        }
        if (line.equals("done")) {
            if (this.commonBase.isEmpty()) {
                this.pckOut.writeString("NAK\n");
            } else if (this.multiAck != BasePackFetchConnection.MultiAck.OFF) {
                this.pckOut.writeString("ACK " + last.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", line));
    }

    private boolean matchHave(ObjectId id) {
        RevObject o;
        try {
            o = this.walk.parseAny(id);
        }
        catch (IOException iOException) {
            return false;
        }
        if (!o.has(this.PEER_HAS)) {
            o.add(this.PEER_HAS);
            if (o instanceof RevCommit) {
                ((RevCommit)o).carry(this.PEER_HAS);
            }
            this.addCommonBase(o);
        }
        return true;
    }

    private void addCommonBase(RevObject o) {
        if (!o.has(this.COMMON)) {
            o.add(this.COMMON);
            this.commonBase.add(o);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    private boolean okToGiveUpImp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            Iterator<RevCommit> i = this.wantCommits.iterator();
            while (i.hasNext()) {
                RevCommit want = i.next();
                if (!this.wantSatisfied(want)) continue;
                i.remove();
            }
        }
        catch (IOException e) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, e);
        }
        return this.wantCommits.isEmpty();
    }

    private boolean wantSatisfied(RevCommit want) throws IOException {
        RevCommit c;
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart(want);
        while ((c = this.walk.next()) != null) {
            if (!c.has(this.PEER_HAS)) continue;
            this.addCommonBase(c);
            return true;
        }
        return false;
    }

    private void sendPack() throws IOException {
        boolean thin = this.options.contains(OPTION_THIN_PACK);
        boolean progress = !this.options.contains(OPTION_NO_PROGRESS);
        boolean sideband = this.options.contains(OPTION_SIDE_BAND) || this.options.contains(OPTION_SIDE_BAND_64K);
        ProgressMonitor pm = NullProgressMonitor.INSTANCE;
        OutputStream packOut = this.rawOut;
        if (sideband) {
            int bufsz = 1000;
            if (this.options.contains(OPTION_SIDE_BAND_64K)) {
                bufsz = 65520;
            }
            packOut = new SideBandOutputStream(1, bufsz, this.rawOut);
            if (progress) {
                pm = new SideBandProgressMonitor(new SideBandOutputStream(2, bufsz, this.rawOut));
            }
        }
        PackWriter pw = new PackWriter(this.db, this.walk.getObjectReader());
        try {
            pw.setDeltaBaseAsOffset(this.options.contains(OPTION_OFS_DELTA));
            pw.setThin(thin);
            pw.preparePack(pm, this.wantAll, this.commonBase);
            if (this.options.contains(OPTION_INCLUDE_TAG)) {
                for (Ref r : this.refs.values()) {
                    RevTag t;
                    RevObject o;
                    try {
                        o = this.walk.parseAny(r.getObjectId());
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    if (o.has(this.WANT) || !(o instanceof RevTag) || pw.willInclude(t = (RevTag)o) || !pw.willInclude(t.getObject())) continue;
                    pw.addObject(t);
                }
            }
            pw.writePack(pm, NullProgressMonitor.INSTANCE, packOut);
        }
        finally {
            pw.release();
        }
        packOut.flush();
        if (sideband) {
            this.pckOut.end();
        }
    }
}

