/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.ignore.IgnoreRule;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;

public abstract class WorkingTreeIterator
extends AbstractTreeIterator {
    protected static final Entry[] EOF = new Entry[0];
    private static final int BUFFER_SIZE = 2048;
    private byte[] contentId;
    private int contentIdFromPtr;
    private byte[] contentReadBuffer;
    private MessageDigest contentDigest;
    private final CharsetEncoder nameEncoder;
    private Entry[] entries;
    private int entryCnt;
    private int ptr;
    private IgnoreNode ignoreNode;
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] hblob = Constants.encodedTypeString(3);
    private static final Comparator<Entry> ENTRY_CMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry o1, Entry o2) {
            byte[] a = o1.encodedName;
            byte[] b = o2.encodedName;
            int aLen = o1.encodedNameLen;
            int bLen = o2.encodedNameLen;
            int cPos = 0;
            while (cPos < aLen && cPos < bLen) {
                int cmp = (a[cPos] & 0xFF) - (b[cPos] & 0xFF);
                if (cmp != 0) {
                    return cmp;
                }
                ++cPos;
            }
            if (cPos < aLen) {
                return (a[cPos] & 0xFF) - WorkingTreeIterator.lastPathChar(o2);
            }
            if (cPos < bLen) {
                return WorkingTreeIterator.lastPathChar(o1) - (b[cPos] & 0xFF);
            }
            return WorkingTreeIterator.lastPathChar(o1) - WorkingTreeIterator.lastPathChar(o2);
        }
    };

    protected WorkingTreeIterator() {
        this.nameEncoder = Constants.CHARSET.newEncoder();
    }

    protected WorkingTreeIterator(String prefix) {
        super(prefix);
        this.nameEncoder = Constants.CHARSET.newEncoder();
    }

    protected WorkingTreeIterator(WorkingTreeIterator p) {
        super(p);
        this.nameEncoder = p.nameEncoder;
    }

    protected void initRootIterator(Repository repo) {
        Entry entry = this.ignoreNode instanceof PerDirectoryIgnoreNode ? ((PerDirectoryIgnoreNode)this.ignoreNode).entry : null;
        this.ignoreNode = new RootIgnoreNode(entry, repo);
    }

    public byte[] idBuffer() {
        if (this.contentIdFromPtr == this.ptr) {
            return this.contentId;
        }
        switch (this.mode & 0xF000) {
            case 32768: {
                this.contentIdFromPtr = this.ptr;
                this.contentId = this.idBufferBlob(this.entries[this.ptr]);
                return this.contentId;
            }
            case 40960: {
                return zeroid;
            }
            case 57344: {
                return zeroid;
            }
        }
        return zeroid;
    }

    private void initializeDigest() {
        if (this.contentDigest != null) {
            return;
        }
        if (this.parent == null) {
            this.contentReadBuffer = new byte[2048];
            this.contentDigest = Constants.newMessageDigest();
        } else {
            WorkingTreeIterator p = (WorkingTreeIterator)this.parent;
            p.initializeDigest();
            this.contentReadBuffer = p.contentReadBuffer;
            this.contentDigest = p.contentDigest;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] idBufferBlob(Entry e) {
        try {
            InputStream is;
            block18: {
                byte[] byArray;
                is = e.openInputStream();
                if (is == null) {
                    return zeroid;
                }
                try {
                    long blobLength;
                    this.initializeDigest();
                    this.contentDigest.reset();
                    this.contentDigest.update(hblob);
                    this.contentDigest.update((byte)32);
                    long sz = blobLength = e.getLength();
                    if (sz == 0L) {
                        this.contentDigest.update((byte)48);
                    } else {
                        int bufn;
                        int p = bufn = this.contentReadBuffer.length;
                        do {
                            this.contentReadBuffer[--p] = digits[(int)(sz % 10L)];
                        } while ((sz /= 10L) > 0L);
                        this.contentDigest.update(this.contentReadBuffer, p, bufn - p);
                    }
                    this.contentDigest.update((byte)0);
                    while (true) {
                        int r;
                        if ((r = is.read(this.contentReadBuffer)) <= 0) {
                            if (sz != blobLength) {
                                break;
                            }
                            break block18;
                        }
                        this.contentDigest.update(this.contentReadBuffer, 0, r);
                        sz += (long)r;
                    }
                    byArray = zeroid;
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    is.close();
                    return byArray;
                }
                catch (IOException iOException) {}
                return byArray;
            }
            byte[] byArray = this.contentDigest.digest();
            try {
                is.close();
                return byArray;
            }
            catch (IOException iOException) {}
            return byArray;
        }
        catch (IOException iOException) {
            return zeroid;
        }
    }

    public int idOffset() {
        return 0;
    }

    public boolean first() {
        return this.ptr == 0;
    }

    public boolean eof() {
        return this.ptr == this.entryCnt;
    }

    public void next(int delta) throws CorruptObjectException {
        this.ptr += delta;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    public void back(int delta) throws CorruptObjectException {
        this.ptr -= delta;
        this.parseEntry();
    }

    private void parseEntry() {
        Entry e = this.entries[this.ptr];
        this.mode = e.getMode().getBits();
        int nameLen = e.encodedNameLen;
        this.ensurePathCapacity(this.pathOffset + nameLen, this.pathOffset);
        System.arraycopy(e.encodedName, 0, this.path, this.pathOffset, nameLen);
        this.pathLen = this.pathOffset + nameLen;
    }

    public long getEntryLength() {
        return this.current().getLength();
    }

    public long getEntryLastModified() {
        return this.current().getLastModified();
    }

    public boolean isEntryIgnored() throws IOException {
        return this.isEntryIgnored(this.pathLen);
    }

    protected boolean isEntryIgnored(int pLen) throws IOException {
        IgnoreNode rules = this.getIgnoreNode();
        if (rules != null) {
            int pOff = this.pathOffset;
            if (pOff > 0) {
                --pOff;
            }
            String p = TreeWalk.pathOf(this.path, pOff, pLen);
            switch (rules.isIgnored(p, FileMode.TREE.equals(this.mode))) {
                case IGNORED: {
                    return true;
                }
                case NOT_IGNORED: {
                    return false;
                }
            }
        }
        if (this.parent instanceof WorkingTreeIterator) {
            return ((WorkingTreeIterator)this.parent).isEntryIgnored(pLen);
        }
        return false;
    }

    private IgnoreNode getIgnoreNode() throws IOException {
        if (this.ignoreNode instanceof PerDirectoryIgnoreNode) {
            this.ignoreNode = ((PerDirectoryIgnoreNode)this.ignoreNode).load();
        }
        return this.ignoreNode;
    }

    static int lastPathChar(Entry e) {
        return e.getMode() == FileMode.TREE ? 47 : 0;
    }

    protected void init(Entry[] list) {
        this.entries = list;
        int i = 0;
        int o = 0;
        while (i < this.entries.length) {
            String name;
            Entry e = this.entries[i];
            if (!(e == null || ".".equals(name = e.getName()) || "..".equals(name) || ".git".equals(name))) {
                if (".gitignore".equals(name)) {
                    this.ignoreNode = new PerDirectoryIgnoreNode(e);
                }
                if (i != o) {
                    this.entries[o] = e;
                }
                e.encodeName(this.nameEncoder);
                ++o;
            }
            ++i;
        }
        this.entryCnt = o;
        Arrays.sort(this.entries, 0, this.entryCnt, ENTRY_CMP);
        this.contentIdFromPtr = -1;
        this.ptr = 0;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    protected Entry current() {
        return this.entries[this.ptr];
    }

    public boolean isModified(DirCacheEntry entry, boolean forceContentCheck, boolean checkFilemode, FS fs) {
        if (entry.isAssumeValid()) {
            return false;
        }
        if (entry.isUpdateNeeded()) {
            return true;
        }
        if (!entry.isSmudged() && this.getEntryLength() != (long)entry.getLength()) {
            return true;
        }
        int modeDiff = this.getEntryRawMode() ^ entry.getRawMode();
        if (!checkFilemode) {
            modeDiff &= ~FileMode.EXECUTABLE_FILE.getBits();
        }
        if (modeDiff != 0) {
            return true;
        }
        long cacheLastModified = entry.getLastModified();
        long fileLastModified = this.getEntryLastModified();
        if (cacheLastModified % 1000L == 0L) {
            fileLastModified -= fileLastModified % 1000L;
        }
        if (fileLastModified != cacheLastModified) {
            if (forceContentCheck) {
                return this.contentCheck(entry);
            }
            return true;
        }
        if (entry.isSmudged()) {
            return this.contentCheck(entry);
        }
        return false;
    }

    private boolean contentCheck(DirCacheEntry entry) {
        if (this.getEntryObjectId().equals(entry.getObjectId())) {
            entry.setLength((int)this.getEntryLength());
            return false;
        }
        return true;
    }

    protected static abstract class Entry {
        byte[] encodedName;
        int encodedNameLen;

        protected Entry() {
        }

        void encodeName(CharsetEncoder enc) {
            ByteBuffer b;
            try {
                b = enc.encode(CharBuffer.wrap(this.getName()));
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException(MessageFormat.format(JGitText.get().unencodeableFile, this.getName()));
            }
            this.encodedNameLen = b.limit();
            if (b.hasArray() && b.arrayOffset() == 0) {
                this.encodedName = b.array();
            } else {
                this.encodedName = new byte[this.encodedNameLen];
                b.get(this.encodedName);
            }
        }

        public String toString() {
            return String.valueOf(this.getMode().toString()) + " " + this.getName();
        }

        public abstract FileMode getMode();

        public abstract long getLength();

        public abstract long getLastModified();

        public abstract String getName();

        public abstract InputStream openInputStream() throws IOException;
    }

    private static class PerDirectoryIgnoreNode
    extends IgnoreNode {
        final Entry entry;

        PerDirectoryIgnoreNode(Entry entry) {
            super(Collections.<IgnoreRule>emptyList());
            this.entry = entry;
        }

        IgnoreNode load() throws IOException {
            IgnoreNode r = new IgnoreNode();
            InputStream in = this.entry.openInputStream();
            try {
                r.parse(in);
            }
            finally {
                in.close();
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }

    private static class RootIgnoreNode
    extends PerDirectoryIgnoreNode {
        final Repository repository;

        RootIgnoreNode(Entry entry, Repository repository) {
            super(entry);
            this.repository = repository;
        }

        IgnoreNode load() throws IOException {
            File exclude;
            IgnoreNode r;
            if (this.entry != null) {
                r = super.load();
                if (r == null) {
                    r = new IgnoreNode();
                }
            } else {
                r = new IgnoreNode();
            }
            if ((exclude = new File(this.repository.getDirectory(), "info/exclude")).exists()) {
                FileInputStream in = new FileInputStream(exclude);
                try {
                    r.parse(in);
                }
                finally {
                    in.close();
                }
            }
            return r.getRules().isEmpty() ? null : r;
        }
    }
}

