/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AndTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL) {
            return b;
        }
        if (b == ALL) {
            return a;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list) {
        if (list.length == 2) {
            return AndTreeFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return AndTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends AndTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker) && this.b.include(walker);
        }

        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        public String toString() {
            return "(" + this.a.toString() + " AND " + this.b.toString() + ")";
        }
    }

    private static class List
    extends AndTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list) {
            this.subfilters = list;
        }

        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                if (!f.include(walker)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        public boolean shouldBeRecursive() {
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                if (f.shouldBeRecursive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public TreeFilter clone() {
            TreeFilter[] s = new TreeFilter[this.subfilters.length];
            int i = 0;
            while (i < s.length) {
                s[i] = this.subfilters[i].clone();
                ++i;
            }
            return new List(s);
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            int i = 0;
            while (i < this.subfilters.length) {
                if (i > 0) {
                    r.append(" AND ");
                }
                r.append(this.subfilters[i].toString());
                ++i;
            }
            r.append(")");
            return r.toString();
        }
    }
}

