/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jgit.util.FS_POSIX_Java5;
import org.eclipse.jgit.util.FS_POSIX_Java6;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;

public abstract class FS {
    public static final FS DETECTED = FS_Win32.detect() ? (FS_Win32_Cygwin.detect() ? new FS_Win32_Cygwin() : new FS_Win32()) : (FS_POSIX_Java6.detect() ? new FS_POSIX_Java6() : new FS_POSIX_Java5());
    private final File userHome = this.userHomeImpl();

    protected FS() {
    }

    public abstract boolean supportsExecute();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        return this.userHome;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }
}

