/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.jgit.util.FS_Win32;

class FS_Win32_Cygwin
extends FS_Win32 {
    private static String cygpath;

    FS_Win32_Cygwin() {
    }

    static boolean detect() {
        String path = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.library.path");
            }
        });
        if (path == null) {
            return false;
        }
        String[] stringArray = path.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            File e = new File(p, "cygpath.exe");
            if (e.isFile()) {
                cygpath = e.getAbsolutePath();
                return true;
            }
            ++n2;
        }
        return false;
    }

    public File resolve(File dir, String pn) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{cygpath, "--windows", "--absolute", pn}, null, dir);
            p.getOutputStream().close();
            BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), "UTF-8"));
            String r = null;
            try {
                r = lineRead.readLine();
            }
            finally {
                lineRead.close();
            }
            while (true) {
                try {
                    if (p.waitFor() == 0 && r != null && r.length() > 0) {
                        return new File(r);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return super.resolve(dir, pn);
    }

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv("HOME");
            }
        });
        if (home == null || home.length() == 0) {
            return super.userHomeImpl();
        }
        return this.resolve(new File("."), home);
    }
}

