/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.MutableInteger;

public final class RawParseUtils {
    private static final byte[] digits10 = new byte[58];
    private static final byte[] digits16;
    private static final byte[] footerLineKeyChars;
    private static final byte[] base10byte;

    static {
        Arrays.fill(digits10, (byte)-1);
        int i = 48;
        while (i <= 57) {
            RawParseUtils.digits10[i] = (byte)(i - 48);
            i = (char)(i + 1);
        }
        digits16 = new byte[103];
        Arrays.fill(digits16, (byte)-1);
        i = 48;
        while (i <= 57) {
            RawParseUtils.digits16[i] = (byte)(i - 48);
            i = (char)(i + 1);
        }
        i = 97;
        while (i <= 102) {
            RawParseUtils.digits16[i] = (byte)(i - 97 + 10);
            i = (char)(i + 1);
        }
        i = 65;
        while (i <= 70) {
            RawParseUtils.digits16[i] = (byte)(i - 65 + 10);
            i = (char)(i + 1);
        }
        footerLineKeyChars = new byte[123];
        RawParseUtils.footerLineKeyChars[45] = 1;
        i = 48;
        while (i <= 57) {
            RawParseUtils.footerLineKeyChars[i] = 1;
            i = (char)(i + 1);
        }
        i = 65;
        while (i <= 90) {
            RawParseUtils.footerLineKeyChars[i] = 1;
            i = (char)(i + 1);
        }
        i = 97;
        while (i <= 122) {
            RawParseUtils.footerLineKeyChars[i] = 1;
            i = (char)(i + 1);
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }

    public static final int match(byte[] b, int ptr, byte[] src) {
        if (ptr + src.length > b.length) {
            return -1;
        }
        int i = 0;
        while (i < src.length) {
            if (b[ptr] != src[i]) {
                return -1;
            }
            ++i;
            ++ptr;
        }
        return ptr;
    }

    public static int formatBase10(byte[] b, int o, int value) {
        if (value == 0) {
            b[--o] = 48;
            return o;
        }
        boolean isneg = value < 0;
        while (value != 0) {
            b[--o] = base10byte[value % 10];
            value /= 10;
        }
        if (isneg) {
            b[--o] = 45;
        }
        return o;
    }

    public static final int parseBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        int sz;
        int sign;
        int r;
        block11: {
            r = 0;
            sign = 0;
            sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr < sz) break block11;
            return 0;
        }
        try {
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz) {
                byte v = digits10[b[ptr]];
                if (v >= 0) {
                    r = r * 10 + v;
                    ++ptr;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final long parseLongBase10(byte[] b, int ptr, MutableInteger ptrResult) {
        int sz;
        int sign;
        long r;
        block11: {
            r = 0L;
            sign = 0;
            sz = b.length;
            while (ptr < sz && b[ptr] == 32) {
                ++ptr;
            }
            if (ptr < sz) break block11;
            return 0L;
        }
        try {
            switch (b[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz) {
                byte v = digits10[b[ptr]];
                if (v >= 0) {
                    r = r * 10L + (long)v;
                    ++ptr;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final int parseHexInt16(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        if ((r |= digits16[bs[p + 3]]) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseHexInt32(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        r |= digits16[bs[p + 3]];
        r <<= 4;
        r |= digits16[bs[p + 4]];
        r <<= 4;
        r |= digits16[bs[p + 5]];
        r <<= 4;
        byte last = digits16[bs[p + 7]];
        if ((r |= digits16[bs[p + 6]]) < 0 || last < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | last;
    }

    public static final int parseHexInt4(byte digit) {
        byte r = digits16[digit];
        if (r < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseTimeZoneOffset(byte[] b, int ptr) {
        int v = RawParseUtils.parseBase10(b, ptr, null);
        int tzMins = v % 100;
        int tzHours = v / 100;
        return tzHours * 60 + tzMins;
    }

    public static final int next(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLF(byte[] b, int ptr) {
        return RawParseUtils.next(b, ptr, '\n');
    }

    public static final int nextLF(byte[] b, int ptr, char chrA) {
        int sz = b.length;
        while (ptr < sz) {
            byte c;
            if ((c = b[ptr++]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prev(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            if (b[ptr--] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prevLF(byte[] b, int ptr) {
        return RawParseUtils.prev(b, ptr, '\n');
    }

    public static final int prevLF(byte[] b, int ptr, char chrA) {
        if (ptr == b.length) {
            --ptr;
        }
        while (ptr >= 0) {
            byte c;
            if ((c = b[ptr--]) != chrA && c != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final IntList lineMap(byte[] buf, int ptr, int end) {
        IntList map = new IntList((end - ptr) / 36);
        map.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end) {
            map.add(ptr);
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        map.add(end);
        return map;
    }

    public static final int author(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.author);
    }

    public static final int committer(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        if (ptr < sz && b[ptr] == 97) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.committer);
    }

    public static final int tagger(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            int m = RawParseUtils.match(b, ptr, ObjectChecker.tagger);
            if (m >= 0) {
                return m;
            }
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return -1;
    }

    public static final int encoding(byte[] b, int ptr) {
        int sz = b.length;
        while (ptr < sz) {
            if (b[ptr] == 10) {
                return -1;
            }
            if (b[ptr] == 101) break;
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        return RawParseUtils.match(b, ptr, ObjectChecker.encoding);
    }

    public static Charset parseEncoding(byte[] b) {
        int enc = RawParseUtils.encoding(b, 0);
        if (enc < 0) {
            return Constants.CHARSET;
        }
        int lf = RawParseUtils.nextLF(b, enc);
        return Charset.forName(RawParseUtils.decode(Constants.CHARSET, b, enc, lf - 1));
    }

    public static PersonIdent parsePersonIdent(byte[] raw, int nameB) {
        Charset cs = RawParseUtils.parseEncoding(raw);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB <= nameB + 1 || emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 || raw[emailE] == 10) {
            return null;
        }
        String name = RawParseUtils.decode(cs, raw, nameB, emailB - 2);
        String email = RawParseUtils.decode(cs, raw, emailB, emailE - 1);
        MutableInteger ptrout = new MutableInteger();
        long when = RawParseUtils.parseLongBase10(raw, emailE + 1, ptrout);
        int whenE = ptrout.value;
        if (whenE >= raw.length || raw[whenE] == 10) {
            return null;
        }
        int tz = RawParseUtils.parseTimeZoneOffset(raw, whenE);
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    public static PersonIdent parsePersonIdentOnly(byte[] raw, int nameB) {
        int tz;
        long when;
        int stop = RawParseUtils.nextLF(raw, nameB);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        String email = emailE < stop ? RawParseUtils.decode(raw, emailB, emailE - 1) : "invalid";
        String name = emailB < stop ? RawParseUtils.decode(raw, nameB, emailB - 2) : RawParseUtils.decode(raw, nameB, stop);
        MutableInteger ptrout = new MutableInteger();
        if (emailE < stop) {
            when = RawParseUtils.parseLongBase10(raw, emailE + 1, ptrout);
            tz = RawParseUtils.parseTimeZoneOffset(raw, ptrout.value);
        } else {
            when = 0L;
            tz = 0;
        }
        return new PersonIdent(name, email, when * 1000L, tz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int endOfFooterLineKey(byte[] raw, int ptr) {
        try {
            while (true) {
                byte c;
                if (footerLineKeyChars[c = raw[ptr]] == 0) {
                    if (c == 58) {
                        return ptr;
                    }
                    return -1;
                }
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public static String decode(byte[] buffer) {
        return RawParseUtils.decode(buffer, 0, buffer.length);
    }

    public static String decode(byte[] buffer, int start, int end) {
        return RawParseUtils.decode(Constants.CHARSET, buffer, start, end);
    }

    public static String decode(Charset cs, byte[] buffer) {
        return RawParseUtils.decode(cs, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer, int start, int end) {
        try {
            return RawParseUtils.decodeNoFallback(cs, buffer, start, end);
        }
        catch (CharacterCodingException characterCodingException) {
            return RawParseUtils.extractBinaryString(buffer, start, end);
        }
    }

    public static String decodeNoFallback(Charset cs, byte[] buffer, int start, int end) throws CharacterCodingException {
        ByteBuffer b = ByteBuffer.wrap(buffer, start, end - start);
        b.mark();
        try {
            return RawParseUtils.decode(b, Constants.CHARSET);
        }
        catch (CharacterCodingException characterCodingException) {
            Charset defcs;
            b.reset();
            if (!cs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, cs);
                }
                catch (CharacterCodingException characterCodingException2) {
                    b.reset();
                }
            }
            if (!(defcs = Charset.defaultCharset()).equals(cs) && !defcs.equals(Constants.CHARSET)) {
                try {
                    return RawParseUtils.decode(b, defcs);
                }
                catch (CharacterCodingException characterCodingException3) {
                    b.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] buffer, int start, int end) {
        StringBuilder r = new StringBuilder(end - start);
        int i = start;
        while (i < end) {
            r.append((char)(buffer[i] & 0xFF));
            ++i;
        }
        return r.toString();
    }

    private static String decode(ByteBuffer b, Charset charset) throws CharacterCodingException {
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d.decode(b).toString();
    }

    public static final int commitMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b, ptr);
    }

    public static final int tagMessage(byte[] b, int ptr) {
        int sz = b.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        if (ptr < sz && b[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] b, int start) {
        int ptr = start;
        int sz = b.length;
        while (ptr < sz && b[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b, ptr);
        }
        while (ptr > 0 && start < ptr && b[ptr - 1] == 10) {
            --ptr;
        }
        return ptr;
    }

    private RawParseUtils() {
    }
}

