/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutOutputStream(OutputStream destination, InterruptTimer timer) {
        this.dst = destination;
        this.myTimer = timer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, millis));
        }
        this.timeout = millis;
    }

    public void write(int b) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(b);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw TimeoutOutputStream.writeTimedOut();
            }
        }
        finally {
            this.endWrite();
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(buf, off, len);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw TimeoutOutputStream.writeTimedOut();
            }
        }
        finally {
            this.endWrite();
        }
    }

    public void flush() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.flush();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw TimeoutOutputStream.writeTimedOut();
            }
        }
        finally {
            this.endWrite();
        }
    }

    public void close() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.close();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw TimeoutOutputStream.writeTimedOut();
            }
        }
        finally {
            this.endWrite();
        }
    }

    private void beginWrite() {
        this.myTimer.begin(this.timeout);
    }

    private void endWrite() {
        this.myTimer.end();
    }

    private static InterruptedIOException writeTimedOut() {
        return new InterruptedIOException(JGitText.get().writeTimedOut);
    }
}

