/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.xml.core.internal.contenttype.XMLResourceEncodingDetector;

public final class ContentDescriberForXML
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK, IContentDescriptionExtended.DETECTED_CHARSET, IContentDescriptionExtended.UNSUPPORTED_CHARSET, IContentDescriptionExtended.APPROPRIATE_DEFAULT};
    private static final boolean restrictedMode = true;

    private IResourceCharsetDetector getDetector() {
        return new XMLResourceEncodingDetector();
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        int result = 0;
        result = description == null ? this.determineValidity(result, contents) : this.calculateSupportedOptions(result, contents, description);
        return result;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        int result = 0;
        result = description == null ? this.determineValidity(result, contents) : this.calculateSupportedOptions(result, contents, description);
        return result;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    private int calculateSupportedOptions(int result, InputStream contents, IContentDescription description) throws IOException {
        int returnResult = result;
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            contents.reset();
            detector.set(contents);
            returnResult = this.handleCalculations(result, description, detector);
        }
        return returnResult;
    }

    private int determineValidity(int result, InputStream contents) throws IOException {
        int returnResult = result;
        IResourceCharsetDetector detector = this.getDetector();
        contents.reset();
        detector.set(contents);
        returnResult = this.determineValidity(detector, returnResult);
        return returnResult;
    }

    private int determineValidity(int result, Reader contents) throws IOException {
        int returnResult = result;
        IResourceCharsetDetector detector = this.getDetector();
        contents.reset();
        detector.set(contents);
        returnResult = this.determineValidity(detector, returnResult);
        return returnResult;
    }

    private int calculateSupportedOptions(int result, Reader contents, IContentDescription description) throws IOException {
        int returnResult = result;
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            returnResult = this.handleCalculations(result, description, detector);
        }
        return returnResult;
    }

    private void handleDetectedSpecialCase(IContentDescription description, Object detectedCharset, Object javaCharset) {
        if (detectedCharset != null) {
            description.setProperty(IContentDescriptionExtended.DETECTED_CHARSET, detectedCharset);
        }
    }

    private boolean isRelevent(IContentDescription description) {
        boolean result = false;
        if (description == null) {
            result = false;
        } else if (description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
            result = true;
        } else if (description.isRequested(IContentDescription.CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.APPROPRIATE_DEFAULT)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.DETECTED_CHARSET)) {
            result = true;
        } else if (description.isRequested(IContentDescriptionExtended.UNSUPPORTED_CHARSET)) {
            result = true;
        }
        return result;
    }

    private int handleCalculations(int result, IContentDescription description, IResourceCharsetDetector detector) throws IOException {
        int returnResult = result;
        EncodingMemento encodingMemento = ((XMLResourceEncodingDetector)detector).getEncodingMemento();
        if (description != null) {
            Object existingByteOrderMark;
            byte[] detectedByteOrderMark = encodingMemento.getUnicodeBOM();
            if (detectedByteOrderMark != null && !detectedByteOrderMark.equals(existingByteOrderMark = description.getProperty(IContentDescription.BYTE_ORDER_MARK))) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)detectedByteOrderMark);
            }
            if (!encodingMemento.isValid()) {
                description.setProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET, (Object)encodingMemento.getInvalidEncoding());
                description.setProperty(IContentDescriptionExtended.APPROPRIATE_DEFAULT, (Object)encodingMemento.getAppropriateDefault());
            }
            String detectedCharset = encodingMemento.getDetectedCharsetName();
            String javaCharset = encodingMemento.getJavaCharsetName();
            this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
            if (javaCharset != null) {
                Object existingCharset = description.getProperty(IContentDescription.CHARSET);
                if (javaCharset.equals(existingCharset)) {
                    this.handleDetectedSpecialCase(description, detectedCharset, javaCharset);
                } else {
                    String defaultCharset = detector.getSpecDefaultEncoding();
                    if (defaultCharset != null) {
                        if (!defaultCharset.equals(javaCharset)) {
                            description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                        }
                    } else {
                        description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                    }
                }
            }
        }
        returnResult = this.determineValidity(detector, returnResult);
        return returnResult;
    }

    private int determineValidity(IResourceCharsetDetector detector, int returnResult) {
        XMLResourceEncodingDetector xmlResourceDetector;
        if (detector instanceof XMLResourceEncodingDetector && (xmlResourceDetector = (XMLResourceEncodingDetector)detector).isDeclDetected() && xmlResourceDetector.hasInitialWhiteSpace()) {
            returnResult = 2;
        }
        return returnResult;
    }
}

