/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.document.CharacterDataImpl;
import org.eclipse.wst.xml.core.internal.document.DOMMessages;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionContainer;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionProxy;
import org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextImpl
extends CharacterDataImpl
implements IDOMText {
    private String fSource = null;

    protected TextImpl() {
    }

    protected TextImpl(TextImpl that) {
        super(that);
        if (that != null) {
            this.fSource = that.getSource();
        }
    }

    public void appendData(String arg) throws DOMException {
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        String newSource = this.getSource(arg);
        if (newSource == null) {
            return;
        }
        String source = this.getSource();
        if (source != null) {
            this.setTextSource(String.valueOf(source) + newSource);
        } else {
            this.setTextSource(newSource);
        }
    }

    IStructuredDocumentRegion appendStructuredDocumentRegion(IStructuredDocumentRegion newStructuredDocumentRegion) {
        if (newStructuredDocumentRegion == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            this.setStructuredDocumentRegion(newStructuredDocumentRegion);
            return newStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            container.appendStructuredDocumentRegion(newStructuredDocumentRegion);
        } else {
            StructuredDocumentRegionContainer container = new StructuredDocumentRegionContainer();
            container.appendStructuredDocumentRegion(flatNode);
            container.appendStructuredDocumentRegion(newStructuredDocumentRegion);
            this.setStructuredDocumentRegion(container);
        }
        return newStructuredDocumentRegion;
    }

    public void appendText(Text newText) {
        if (newText == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        TextImpl text = (TextImpl)newText;
        String newSource = text.getSource();
        if (newSource == null || newSource.length() == 0) {
            return;
        }
        String source = this.getSource();
        if (source != null) {
            this.setTextSource(String.valueOf(source) + newSource);
        } else {
            this.setTextSource(newSource);
        }
    }

    public Node cloneNode(boolean deep) {
        TextImpl cloned = new TextImpl(this);
        this.notifyUserDataHandlers((short)1, cloned);
        return cloned;
    }

    public void deleteData(int offset, int count) throws DOMException {
        String second;
        if (count == 0) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (count < 0 || offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String source = this.getSource();
        if (source == null || source.length() == 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        StringPair pair = this.substringSourceExcluded(source, offset, count);
        if (pair == null) {
            return;
        }
        source = null;
        String first = pair.getFirst();
        if (first != null) {
            source = first;
        }
        if ((second = pair.getSecond()) != null) {
            source = source != null ? String.valueOf(source) + second : second;
        }
        if (source == null) {
            source = "";
        }
        this.setTextSource(source);
    }

    public String getData() throws DOMException {
        if (this.fSource != null) {
            return this.getData(this.fSource);
        }
        String data = super.getData();
        if (data != null) {
            return data;
        }
        return this.getData(this.getStructuredDocumentRegion());
    }

    private String getData(IStructuredDocumentRegion flatNode) {
        String value;
        DocumentImpl document;
        String name;
        String regionType;
        if (flatNode == null) {
            return "";
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int length = container.getLength();
            if (length < 16) {
                length = 16;
            }
            StringBuffer buffer = new StringBuffer(length);
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                String data = this.getData(content);
                if (data != null) {
                    buffer.append(data);
                }
                ++i;
            }
            return buffer.toString();
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            return flatNode.getText();
        }
        ITextRegion region = StructuredDocumentRegionUtil.getFirstRegion(flatNode);
        if (region != null && ((regionType = region.getType()) == "XML_ENTITY_REFERENCE" || regionType == "XML_CHAR_REFERENCE") && (name = StructuredDocumentRegionUtil.getEntityRefName(flatNode, region)) != null && (document = (DocumentImpl)this.getOwnerDocument()) != null && (value = document.getCharValue(name)) != null) {
            return value;
        }
        return flatNode.getText();
    }

    private String getData(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer buffer = null;
        int offset = 0;
        int length = source.length();
        int ref = source.indexOf(38);
        while (ref >= 0) {
            String name;
            String value;
            int end = source.indexOf(59, ref + 1);
            if (end > ref + 1 && (value = this.getCharValue(name = source.substring(ref + 1, end))) != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(length);
                }
                if (ref > offset) {
                    buffer.append(source.substring(offset, ref));
                }
                buffer.append(value);
                offset = end + 1;
                ref = end;
            }
            ref = source.indexOf(38, ref + 1);
        }
        if (buffer == null) {
            return source;
        }
        if (length > offset) {
            buffer.append(source.substring(offset));
        }
        return buffer.toString();
    }

    public IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getFirstStructuredDocumentRegion(this.getStructuredDocumentRegion());
    }

    public IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        return StructuredDocumentRegionUtil.getLastStructuredDocumentRegion(this.getStructuredDocumentRegion());
    }

    public String getNodeName() {
        return "#text";
    }

    public short getNodeType() {
        return 3;
    }

    public String getSource() {
        String source;
        if (this.fSource != null) {
            return this.fSource;
        }
        String data = super.getData();
        if (data != null && data.length() > 0 && (source = this.getSource(data)) != null) {
            return source;
        }
        return super.getSource();
    }

    private String getSource(String data) {
        if (data == null) {
            return null;
        }
        IDOMModel model = this.getModel();
        if (model == null) {
            return null;
        }
        ISourceGenerator generator = model.getGenerator();
        if (generator == null) {
            return null;
        }
        return generator.generateTextData(this, data);
    }

    String getTextSource() {
        return this.fSource;
    }

    public String getValueSource() {
        return this.getSource();
    }

    boolean hasStructuredDocumentRegion(IStructuredDocumentRegion askedStructuredDocumentRegion) {
        if (askedStructuredDocumentRegion == null) {
            return false;
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return false;
        }
        if (flatNode == askedStructuredDocumentRegion) {
            return true;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            return proxy.getStructuredDocumentRegion() == askedStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == askedStructuredDocumentRegion) {
                        return true;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == askedStructuredDocumentRegion) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public void insertData(int offset, String arg) throws DOMException {
        String second;
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String source = this.getSource();
        if (source == null || source.length() == 0) {
            if (offset > 0) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            source = this.getSource(arg);
            if (source != null) {
                this.setTextSource(source);
            }
            return;
        }
        StringPair pair = this.substringSourceExcluded(source, offset, 0);
        if (pair == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(source.length() + arg.length());
        String first = pair.getFirst();
        if (first != null) {
            buffer.append(first);
        }
        if ((source = this.getSource(arg)) != null) {
            buffer.append(source);
        }
        if ((second = pair.getSecond()) != null) {
            buffer.append(second);
        }
        this.setTextSource(buffer.toString());
    }

    IStructuredDocumentRegion insertStructuredDocumentRegion(IStructuredDocumentRegion newStructuredDocumentRegion, IStructuredDocumentRegion nextStructuredDocumentRegion) {
        if (newStructuredDocumentRegion == null) {
            return null;
        }
        if (nextStructuredDocumentRegion == null) {
            return this.appendStructuredDocumentRegion(newStructuredDocumentRegion);
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (flatNode == nextStructuredDocumentRegion) {
            StructuredDocumentRegionContainer container = new StructuredDocumentRegionContainer();
            container.appendStructuredDocumentRegion(newStructuredDocumentRegion);
            container.appendStructuredDocumentRegion(flatNode);
            this.setStructuredDocumentRegion(container);
            return newStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content == nextStructuredDocumentRegion) {
                    container.insertStructuredDocumentRegion(newStructuredDocumentRegion, i);
                    return newStructuredDocumentRegion;
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public void insertText(Text newText, int offset) throws DOMException {
        if (newText == null) {
            return;
        }
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        TextImpl text = (TextImpl)newText;
        String newSource = text.getSource();
        if (newSource == null || newSource.length() == 0) {
            return;
        }
        if (offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String source = this.getSource();
        if (source == null || source.length() == 0) {
            if (offset > 0) {
                throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
            }
            this.setTextSource(newSource);
            return;
        }
        StringPair pair = this.substringSourceExcluded(source, offset, 0);
        if (pair == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(source.length() + newSource.length());
        String first = pair.getFirst();
        if (first != null) {
            buffer.append(first);
        }
        buffer.append(newSource);
        String second = pair.getSecond();
        if (second != null) {
            buffer.append(second);
        }
        this.setTextSource(buffer.toString());
    }

    public boolean isCDATAContent() {
        Node parent = this.getParentNode();
        if (parent == null || parent.getNodeType() != 1) {
            return false;
        }
        ElementImpl element = (ElementImpl)parent;
        return element.isCDATAContainer();
    }

    public boolean isInvalid() {
        return this.isInvalid(this.getStructuredDocumentRegion());
    }

    private boolean isInvalid(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return false;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (this.isInvalid(content)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            return this.isInvalid(proxy.getStructuredDocumentRegion());
        }
        String regionType = StructuredDocumentRegionUtil.getFirstRegionType(flatNode);
        return regionType != "XML_CONTENT" && this.isNotNestedContent(regionType) && regionType != "XML_ENTITY_REFERENCE" && regionType != "XML_CHAR_REFERENCE" && regionType != "BLOCK_TEXT" && regionType != "WHITE_SPACE";
    }

    protected boolean isNotNestedContent(String regionType) {
        boolean result = true;
        return result;
    }

    boolean isSharingStructuredDocumentRegion(IStructuredDocumentRegion sharedStructuredDocumentRegion) {
        if (sharedStructuredDocumentRegion == null) {
            return false;
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return false;
        }
        if (flatNode == sharedStructuredDocumentRegion) {
            return false;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            return proxy.getStructuredDocumentRegion() == sharedStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == sharedStructuredDocumentRegion) {
                        return false;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == sharedStructuredDocumentRegion) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean isElementContentWhitespace() {
        return this.isWhitespace();
    }

    public boolean isWhitespace() {
        String data = this.getData();
        if (data == null) {
            return true;
        }
        int length = data.length();
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(data.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    IStructuredDocumentRegion removeStructuredDocumentRegion(IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (flatNode == oldStructuredDocumentRegion) {
            this.setStructuredDocumentRegion(null);
            return oldStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            if (proxy.getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                this.setStructuredDocumentRegion(null);
                return oldStructuredDocumentRegion;
            }
            return null;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                StructuredDocumentRegionProxy proxy;
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content == oldStructuredDocumentRegion) {
                    container.removeStructuredDocumentRegion(i);
                    if (container.getStructuredDocumentRegionCount() == 1) {
                        this.setStructuredDocumentRegion(container.getStructuredDocumentRegion(0));
                    }
                    return oldStructuredDocumentRegion;
                }
                if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                    container.removeStructuredDocumentRegion(i);
                    if (container.getStructuredDocumentRegionCount() == 1) {
                        this.setStructuredDocumentRegion(container.getStructuredDocumentRegion(0));
                    }
                    return oldStructuredDocumentRegion;
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        String second;
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (arg == null || arg.length() == 0) {
            this.deleteData(offset, count);
            return;
        }
        if (count == 0) {
            this.insertData(offset, arg);
            return;
        }
        if (offset < 0 || count < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String source = this.getSource();
        if (source == null || source.length() == 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        StringPair pair = this.substringSourceExcluded(source, offset, count);
        if (pair == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(source.length() + arg.length());
        String first = pair.getFirst();
        if (first != null) {
            buffer.append(first);
        }
        if ((source = this.getSource(arg)) != null) {
            buffer.append(source);
        }
        if ((second = pair.getSecond()) != null) {
            buffer.append(second);
        }
        this.setTextSource(buffer.toString());
    }

    IStructuredDocumentRegion replaceStructuredDocumentRegion(IStructuredDocumentRegion newStructuredDocumentRegion, IStructuredDocumentRegion oldStructuredDocumentRegion) {
        if (oldStructuredDocumentRegion == null) {
            return null;
        }
        if (newStructuredDocumentRegion == null) {
            return this.removeStructuredDocumentRegion(oldStructuredDocumentRegion);
        }
        IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (flatNode == oldStructuredDocumentRegion) {
            this.setStructuredDocumentRegion(newStructuredDocumentRegion);
            return oldStructuredDocumentRegion;
        }
        if (flatNode instanceof StructuredDocumentRegionProxy) {
            StructuredDocumentRegionProxy proxy = (StructuredDocumentRegionProxy)flatNode;
            if (proxy.getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                if (newStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
                    this.setStructuredDocumentRegion(newStructuredDocumentRegion);
                } else {
                    proxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                }
                return oldStructuredDocumentRegion;
            }
            return null;
        }
        if (flatNode instanceof StructuredDocumentRegionContainer) {
            StructuredDocumentRegionContainer container = (StructuredDocumentRegionContainer)flatNode;
            int count = container.getStructuredDocumentRegionCount();
            int i = 0;
            while (i < count) {
                IStructuredDocumentRegion content = container.getStructuredDocumentRegion(i);
                if (content != null) {
                    StructuredDocumentRegionProxy proxy;
                    if (content == oldStructuredDocumentRegion) {
                        container.replaceStructuredDocumentRegion(newStructuredDocumentRegion, i);
                        return oldStructuredDocumentRegion;
                    }
                    if (content instanceof StructuredDocumentRegionProxy && (proxy = (StructuredDocumentRegionProxy)content).getStructuredDocumentRegion() == oldStructuredDocumentRegion) {
                        if (newStructuredDocumentRegion instanceof StructuredDocumentRegionProxy) {
                            container.replaceStructuredDocumentRegion(newStructuredDocumentRegion, i);
                        } else {
                            proxy.setStructuredDocumentRegion(newStructuredDocumentRegion);
                        }
                        return oldStructuredDocumentRegion;
                    }
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    void resetStructuredDocumentRegions() {
        String source = this.getSource();
        if (source != null && source.length() > 0) {
            this.fSource = source;
        }
        super.resetStructuredDocumentRegions();
    }

    public void setData(String data) throws DOMException {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.fSource = null;
        super.setData(data);
    }

    public void setSource(String source) throws InvalidCharacterException {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        SourceValidator validator = new SourceValidator(this);
        if (validator.validateSource(source)) {
            this.setTextSource(source);
        }
    }

    void setStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
        super.setStructuredDocumentRegion(flatNode);
        if (flatNode != null) {
            this.fSource = null;
        }
    }

    public void setTextSource(String source) {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        this.fSource = source;
        this.notifyValueChanged();
    }

    public void setValueSource(String source) {
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        SourceValidator validator = new SourceValidator(this);
        this.setTextSource(validator.convertSource(source));
    }

    public Text splitText(int offset) throws DOMException {
        Node parent;
        if (!this.isDataEditable()) {
            throw new DOMException(7, DOMMessages.NO_MODIFICATION_ALLOWED_ERR);
        }
        if (offset < 0) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = this.getLength();
        if (offset > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        Document document = this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        String source = null;
        if (offset < length) {
            int count = length - offset;
            source = this.substringSource(offset, count);
            this.deleteData(offset, count);
        }
        TextImpl text = (TextImpl)document.createTextNode(null);
        if (source != null) {
            text.setTextSource(source);
        }
        if ((parent = this.getParentNode()) != null) {
            parent.insertBefore(text, this.getNextSibling());
        }
        return text;
    }

    /*
     * Unable to fully structure code
     */
    Text splitText(IStructuredDocumentRegion nextStructuredDocumentRegion) {
        if (nextStructuredDocumentRegion == null) {
            return null;
        }
        flatNode = this.getStructuredDocumentRegion();
        if (flatNode == null || !(flatNode instanceof StructuredDocumentRegionContainer)) {
            return null;
        }
        container = (StructuredDocumentRegionContainer)flatNode;
        count = container.getStructuredDocumentRegionCount();
        index = 0;
        while (index < count) {
            if (container.getStructuredDocumentRegion(index) == nextStructuredDocumentRegion) break;
            ++index;
        }
        if (index >= count) {
            offset = nextStructuredDocumentRegion.getStart();
            index = 0;
            while (index < count) {
                content = container.getStructuredDocumentRegion(index);
                if (content != null && content.getStart() >= offset) break;
                ++index;
            }
            if (index >= count) {
                return null;
            }
        }
        if (index == 0) {
            return this;
        }
        document = this.getOwnerDocument();
        if (document == null) {
            return null;
        }
        parent = this.getParentNode();
        if (parent == null) {
            return null;
        }
        nextText = (TextImpl)document.createTextNode(null);
        if (nextText != null) ** GOTO lbl37
        return null;
lbl-1000:
        // 1 sources

        {
            nextText.appendStructuredDocumentRegion(container.removeStructuredDocumentRegion(index));
            --count;
lbl37:
            // 2 sources

            ** while (index < count)
        }
lbl38:
        // 1 sources

        if (index == 1) {
            this.setStructuredDocumentRegion(container.getStructuredDocumentRegion(0));
        }
        parent.insertBefore(nextText, this.getNextSibling());
        return nextText;
    }

    private String substringData(String data, int offset, int count) throws DOMException {
        if (count == 0) {
            return "";
        }
        if (data == null) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = data.length();
        if (offset > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int end = offset + count;
        if (end > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        return data.substring(offset, end);
    }

    private String substringSource(int offset, int count) throws DOMException {
        if (this.fSource != null) {
            return this.substringSource(this.fSource, offset, count);
        }
        String data = super.getData();
        if (data != null && data.length() > 0) {
            if ((data = this.substringData(data, offset, count)) == null) {
                return "";
            }
            String source = this.getSource(data);
            if (source != null) {
                return source;
            }
        }
        return this.substringSource(this.getSource(), offset, count);
    }

    private String substringSource(String source, int offset, int count) throws DOMException {
        if (count == 0) {
            return "";
        }
        if (source == null) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = source.length();
        int end = offset + count;
        int ref = source.indexOf(38);
        while (ref >= 0) {
            String name;
            if (ref >= end) break;
            int refEnd = source.indexOf(59, ref + 1);
            if (refEnd > ref + 1 && this.getCharValue(name = source.substring(ref + 1, refEnd)) != null) {
                int refCount = refEnd - ref;
                if (ref < offset) {
                    offset += refCount;
                }
                if (ref < end) {
                    end += refCount;
                }
                ref = refEnd;
            }
            ref = source.indexOf(38, ref + 1);
        }
        if (offset > length || end > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        return source.substring(offset, end);
    }

    private StringPair substringSourceExcluded(String source, int offset, int count) throws DOMException {
        if (source == null) {
            if (offset == 0 && count == 0) {
                return new StringPair(null, null);
            }
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        int length = source.length();
        int end = offset + count;
        int ref = source.indexOf(38);
        while (ref >= 0) {
            String name;
            if (ref >= end) break;
            int refEnd = source.indexOf(59, ref + 1);
            if (refEnd > ref + 1 && this.getCharValue(name = source.substring(ref + 1, refEnd)) != null) {
                int refCount = refEnd - ref;
                if (ref < offset) {
                    offset += refCount;
                }
                if (ref < end) {
                    end += refCount;
                }
                ref = refEnd;
            }
            ref = source.indexOf(38, ref + 1);
        }
        if (offset > length || end > length) {
            throw new DOMException(1, DOMMessages.INDEX_SIZE_ERR);
        }
        String first = offset > 0 ? source.substring(0, offset) : null;
        String second = end < length ? source.substring(end, length) : null;
        return new StringPair(first, second);
    }

    public String getWholeText() {
        throw new DOMException(9, "Not Implemented in this version.");
    }

    public Text replaceWholeText(String content) throws DOMException {
        throw new DOMException(9, "Not implemented");
    }

    private class StringPair {
        private String fFirst = null;
        private String fSecond = null;

        StringPair(String first, String second) {
            this.fFirst = first;
            this.fSecond = second;
        }

        String getFirst() {
            return this.fFirst;
        }

        String getSecond() {
            return this.fSecond;
        }
    }
}

