/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.binary;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.binary.AbstractCodeCreationOperation;
import org.eclipse.jdt.internal.corext.refactoring.binary.StubCreator;

public class StubCreationOperation
extends AbstractCodeCreationOperation {
    protected final boolean fStubInvisible;

    public StubCreationOperation(URI uri, List packages) {
        this(uri, packages, false);
    }

    public StubCreationOperation(URI uri, List packages, boolean stub) {
        super(uri, packages);
        this.fStubInvisible = stub;
    }

    protected String getOperationLabel() {
        return RefactoringCoreMessages.StubCreationOperation_creating_type_stubs;
    }

    protected void run(IClassFile file, IFileStore parent, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.StubCreationOperation_creating_type_stubs, 2);
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 1);
            IType type = file.getType();
            if (type.isAnonymous() || type.isLocal() || type.isMember()) {
                return;
            }
            String source = new StubCreator(this.fStubInvisible).createStub(type, (IProgressMonitor)subProgressMonitor);
            this.createCompilationUnit(parent, String.valueOf(type.getElementName()) + ".java", source, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

