/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonTextSupport;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.SelectionProviderAdapter;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.editor.EditorBusyIndicator;
import org.eclipse.mylyn.internal.provisional.commons.ui.editor.IBusyEditor;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskEditorScheduleAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleTaskActivationAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.util.PlatformUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TaskDragSourceListener;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPageFactory;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.forms.widgets.BusyIndicator;
import org.eclipse.ui.internal.forms.widgets.FormHeading;
import org.eclipse.ui.internal.forms.widgets.TitleRegion;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class TaskEditor
extends SharedHeaderFormEditor {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editors.task";
    public static final String ID_TOOLBAR_HEADER = "org.eclipse.mylyn.tasks.ui.editors.task.toolbar.header";
    private static final String ID_LEFT_TOOLBAR_HEADER = "org.eclipse.mylyn.tasks.ui.editors.task.toolbar.header.left";
    private static final int LEFT_TOOLBAR_HEADER_TOOLBAR_PADDING = 3;
    private ToggleTaskActivationAction activateAction;
    @Deprecated
    private final IEditorPart contentOutlineProvider = null;
    private EditorBusyIndicator editorBusyIndicator;
    private MenuManager menuManager;
    private IHyperlinkListener messageHyperLinkListener;
    private ITask task;
    private TaskEditorInput taskEditorInput;
    private TaskDragSourceListener titleDragSourceListener;
    private Composite editorParent;
    private IMenuService menuService;
    private IToolBarManager toolBarManager;
    private ToolBarManager leftToolBarManager;
    private ToolBar leftToolBar;
    private Image headerImage;
    private boolean noExtraPadding;
    private BusyIndicator busyLabel;
    private StyledText titleLabel;
    private CommonTextSupport textSupport;
    private TaskEditorScheduleAction scheduleAction;
    Action openWithBrowserAction;
    private static boolean toolBarFailureLogged;

    protected Composite createPageContainer(Composite parent) {
        Composite composite;
        block6: {
            this.editorParent = parent;
            composite = super.createPageContainer(parent);
            EditorUtil.initializeScrollbars(this.getHeaderForm().getForm());
            try {
                FormHeading heading = (FormHeading)this.getHeaderForm().getForm().getForm().getHead();
                Field field = FormHeading.class.getDeclaredField("titleRegion");
                field.setAccessible(true);
                TitleRegion titleRegion = (TitleRegion)field.get(heading);
                this.leftToolBarManager = new ToolBarManager(0x800000);
                this.leftToolBar = this.leftToolBarManager.createControl((Composite)titleRegion);
                this.leftToolBar.addControlListener((ControlListener)new ControlAdapter(){
                    private boolean ignoreResizeEvents;

                    public void controlResized(ControlEvent e) {
                        if (this.ignoreResizeEvents) {
                            return;
                        }
                        this.ignoreResizeEvents = true;
                        try {
                            TaskEditor.this.updateHeaderImage();
                            TaskEditor.this.updateHeaderLabel();
                        }
                        finally {
                            this.ignoreResizeEvents = false;
                        }
                    }
                });
                TextViewer titleViewer = new TextViewer((Composite)titleRegion, 8);
                titleViewer.setDocument((IDocument)new Document());
                this.titleLabel = titleViewer.getTextWidget();
                this.titleLabel.setForeground(heading.getForeground());
                this.titleLabel.setFont(heading.getFont());
                this.titleLabel.addFocusListener((FocusListener)new FocusAdapter(){

                    public void focusLost(FocusEvent e) {
                        TaskEditor.this.titleLabel.setSelection(0);
                    }
                });
                titleRegion.addControlListener((ControlListener)new ControlAdapter(){

                    public void controlResized(ControlEvent e) {
                        TaskEditor.this.updateSizeAndLocations();
                    }
                });
                IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
                if (handlerService != null) {
                    this.textSupport = new CommonTextSupport(handlerService);
                    this.textSupport.install(titleViewer, false);
                }
            }
            catch (Exception e) {
                if (!toolBarFailureLogged) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to obtain busy label toolbar", (Throwable)e));
                }
                if (this.titleLabel != null) {
                    this.titleLabel.dispose();
                    this.titleLabel = null;
                }
                if (this.leftToolBar != null) {
                    this.leftToolBar.dispose();
                    this.leftToolBar = null;
                }
                if (this.leftToolBarManager == null) break block6;
                this.leftToolBarManager.dispose();
                this.leftToolBarManager = null;
            }
        }
        this.updateHeader();
        return composite;
    }

    private BusyIndicator getBusyLabel() {
        block9: {
            if (this.busyLabel != null) {
                return this.busyLabel;
            }
            try {
                FormHeading heading = (FormHeading)this.getHeaderForm().getForm().getForm().getHead();
                heading.setBusy(true);
                heading.setBusy(false);
                Field field = FormHeading.class.getDeclaredField("titleRegion");
                field.setAccessible(true);
                TitleRegion titleRegion = (TitleRegion)field.get(heading);
                Control[] controlArray = titleRegion.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    if (child instanceof BusyIndicator) {
                        this.busyLabel = (BusyIndicator)child;
                    }
                    ++n2;
                }
                if (this.busyLabel != null) break block9;
                return null;
            }
            catch (Exception e) {
                if (!toolBarFailureLogged) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Failed to obtain busy label toolbar", (Throwable)e));
                }
                this.busyLabel = null;
                return this.busyLabel;
            }
        }
        this.busyLabel.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent e) {
                TaskEditor.this.updateSizeAndLocations();
            }
        });
        this.busyLabel.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskEditor.this.busyLabel.setMenu(null);
                TaskEditor.this.busyLabel = null;
            }
        });
        if (this.leftToolBar != null) {
            this.leftToolBar.moveAbove((Control)this.busyLabel);
        }
        if (this.titleLabel != null) {
            this.titleLabel.moveAbove((Control)this.busyLabel);
        }
        this.updateSizeAndLocations();
        return this.busyLabel;
    }

    private void updateSizeAndLocations() {
        if (this.busyLabel == null || this.busyLabel.isDisposed()) {
            return;
        }
        Point leftToolBarSize = new Point(0, 0);
        if (this.leftToolBar != null && !this.leftToolBar.isDisposed()) {
            leftToolBarSize = this.leftToolBar.getSize();
            int y = this.leftToolBar.getParent().getSize().y - leftToolBarSize.y - 2;
            if (!this.hasLeftToolBar()) {
                leftToolBarSize.x = 0;
            }
            this.leftToolBar.setBounds(this.busyLabel.getLocation().x, y, leftToolBarSize.x, leftToolBarSize.y);
        }
        if (this.titleLabel != null && !this.titleLabel.isDisposed()) {
            Point size = this.titleLabel.computeSize(-1, -1, true);
            int y = (this.titleLabel.getParent().getSize().y - size.y) / 2;
            this.titleLabel.setBounds(this.busyLabel.getLocation().x + 3 + leftToolBarSize.x, y, size.x, size.y);
        }
    }

    Composite getEditorParent() {
        return this.editorParent;
    }

    protected void addPages() {
        this.initialize();
        HashSet<String> conflictingIds = new HashSet<String>();
        ArrayList<AbstractTaskEditorPageFactory> pageFactories = new ArrayList<AbstractTaskEditorPageFactory>();
        AbstractTaskEditorPageFactory[] abstractTaskEditorPageFactoryArray = TasksUiPlugin.getDefault().getTaskEditorPageFactories();
        int n = abstractTaskEditorPageFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTaskEditorPageFactory pageFactory = abstractTaskEditorPageFactoryArray[n2];
            if (pageFactory.canCreatePageFor(this.getTaskEditorInput()) && WorkbenchUtil.allowUseOf((Object)pageFactory)) {
                pageFactories.add(pageFactory);
                String[] ids = pageFactory.getConflictingIds(this.getTaskEditorInput());
                if (ids != null) {
                    conflictingIds.addAll(Arrays.asList(ids));
                }
            }
            ++n2;
        }
        Iterator it = pageFactories.iterator();
        while (it.hasNext()) {
            if (!conflictingIds.contains(((AbstractTaskEditorPageFactory)it.next()).getId())) continue;
            it.remove();
        }
        Collections.sort(pageFactories, new Comparator<AbstractTaskEditorPageFactory>(){

            @Override
            public int compare(AbstractTaskEditorPageFactory o1, AbstractTaskEditorPageFactory o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (AbstractTaskEditorPageFactory factory : pageFactories) {
            try {
                IFormPage page = factory.createPage(this);
                int index = this.addPage(page);
                this.setPageImage(index, factory.getPageImage());
                this.setPageText(index, factory.getPageText());
                if (factory.getPriority() == 30) {
                    this.setActivePage(index);
                }
                if (!(page instanceof ISelectionProvider)) continue;
                ((ISelectionProvider)page).addSelectionChangedListener((ISelectionChangedListener)this.getActionBarContributor());
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.ui", "Could not create editor via factory: " + factory, (Throwable)e));
            }
        }
        this.updateTitleImage();
        this.updateHeaderToolBar();
        this.installTitleDrag(this.getHeaderForm().getForm().getForm());
        this.getEditorSite().registerContextMenu(this.menuManager, this.getEditorSite().getSelectionProvider(), true);
    }

    private void initialize() {
        this.editorBusyIndicator = new EditorBusyIndicator(new IBusyEditor(){

            public Image getTitleImage() {
                return TaskEditor.this.getTitleImage();
            }

            public void setTitleImage(Image image) {
                TaskEditor.this.setTitleImage(image);
            }
        });
        this.menuManager = new MenuManager();
        this.configureContextMenuManager(this.menuManager);
        Menu menu = this.menuManager.createContextMenu((Control)this.getContainer());
        this.getContainer().setMenu(menu);
        this.getHeaderForm().getForm().setMenu(menu);
        Composite head = this.getHeaderForm().getForm().getForm().getHead();
        if (head != null) {
            CommonUiUtil.setMenu((Composite)head, (Menu)menu);
        }
    }

    @Deprecated
    public void configureContextMenuManager(MenuManager manager) {
        if (manager == null) {
            return;
        }
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskEditor.this.contextMenuAboutToShow(manager);
            }
        };
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(listener);
    }

    @Deprecated
    protected void contextMenuAboutToShow(IMenuManager manager) {
        TaskEditorActionContributor contributor = this.getActionBarContributor();
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(TasksUiPlugin.getDefault().getFormColors(display));
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
    }

    public void dispose() {
        this.disposeScheduleAction();
        if (this.headerImage != null) {
            this.headerImage.dispose();
        }
        if (this.editorBusyIndicator != null) {
            this.editorBusyIndicator.stop();
        }
        if (this.activateAction != null) {
            this.activateAction.dispose();
        }
        if (this.menuService != null) {
            if (this.leftToolBarManager != null) {
                this.menuService.releaseContributions((ContributionManager)this.leftToolBarManager);
            }
            if (this.toolBarManager instanceof ContributionManager) {
                this.menuService.releaseContributions((ContributionManager)this.toolBarManager);
            }
        }
        if (this.textSupport != null) {
            this.textSupport.dispose();
        }
        if (this.messageHyperLinkListener instanceof IDisposable) {
            ((IDisposable)this.messageHyperLinkListener).dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                page.doSave(monitor);
            }
            ++n2;
        }
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    private TaskEditorActionContributor getActionBarContributor() {
        return (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class adapter) {
        if (this.contentOutlineProvider != null) {
            return this.contentOutlineProvider.getAdapter(adapter);
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            IFormPage[] pages;
            IFormPage[] iFormPageArray = pages = this.getPages();
            int n = pages.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                Object outlinePage = page.getAdapter(adapter);
                if (outlinePage != null) {
                    return outlinePage;
                }
                ++n2;
            }
        }
        return super.getAdapter(adapter);
    }

    public Menu getMenu() {
        return this.getContainer().getMenu();
    }

    IFormPage[] getPages() {
        ArrayList<IFormPage> formPages = new ArrayList<IFormPage>();
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    formPages.add((IFormPage)page);
                }
                ++i;
            }
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    @Deprecated
    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    @Deprecated
    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TaskEditorInput getTaskEditorInput() {
        return this.taskEditorInput;
    }

    @Deprecated
    public Form getTopForm() {
        return this.getHeaderForm().getForm().getForm();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof TaskEditorInput)) {
            throw new PartInitException("Invalid editor input \"" + input.getClass() + "\"");
        }
        super.init(site, input);
        this.taskEditorInput = (TaskEditorInput)input;
        this.task = this.taskEditorInput.getTask();
        site.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.task));
        this.setPartName(input.getName());
        IContextService contextSupport = (IContextService)site.getService(IContextService.class);
        if (contextSupport != null) {
            contextSupport.activateContext(ID_EDITOR);
        }
    }

    private void installTitleDrag(Form form) {
        if (this.titleDragSourceListener == null) {
            Transfer[] transferTypes = this.task == null ? new Transfer[]{TextTransfer.getInstance()} : new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance(), FileTransfer.getInstance()};
            this.titleDragSourceListener = new TaskDragSourceListener((ISelectionProvider)new SelectionProviderAdapter(){

                public ISelection getSelection() {
                    return new StructuredSelection((Object)TaskEditor.this.task);
                }
            });
            if (this.titleLabel != null) {
                DragSource source = new DragSource((Control)this.titleLabel, 6);
                source.setTransfer(transferTypes);
                source.addDragListener((DragSourceListener)this.titleDragSourceListener);
            } else {
                form.addTitleDragSupport(6, transferTypes, (DragSourceListener)this.titleDragSourceListener);
            }
        }
    }

    public boolean isDirty() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    @Deprecated
    public void markDirty() {
        this.firePropertyChange(257);
    }

    public void refreshPages() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof TaskFormPage && page.getManagedForm() != null && !page.getManagedForm().getForm().isDisposed()) {
                ((TaskFormPage)page).refresh();
            }
            ++n2;
        }
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        } else {
            super.setFocus();
        }
    }

    @Deprecated
    public void setFocusOfActivePage() {
        IFormPage page;
        if (this.getActivePage() > -1 && (page = this.getPages()[this.getActivePage()]) != null) {
            page.setFocus();
        }
    }

    public void setMessage(String message, int type) {
        this.setMessage(message, type, null);
    }

    private boolean isHeaderFormDisposed() {
        return this.getHeaderForm() == null || this.getHeaderForm().getForm() == null || this.getHeaderForm().getForm().isDisposed();
    }

    public void setMessage(String message, int type, IHyperlinkListener listener) {
        if (this.isHeaderFormDisposed()) {
            return;
        }
        try {
            this.getHeaderForm().getForm().setRedraw(false);
            Form form = this.getHeaderForm().getForm().getForm();
            form.setMessage(message, type);
            if (this.messageHyperLinkListener != null) {
                form.removeMessageHyperlinkListener(this.messageHyperLinkListener);
                if (this.messageHyperLinkListener instanceof IDisposable) {
                    ((IDisposable)this.messageHyperLinkListener).dispose();
                }
            }
            if (listener != null) {
                form.addMessageHyperlinkListener(listener);
            }
            this.messageHyperLinkListener = listener;
            if (this.hasLeftToolBar()) {
                BusyIndicator busyLabel = this.getBusyLabel();
                if (message != null && busyLabel != null) {
                    this.setHeaderImage(busyLabel.getImage());
                } else {
                    this.setHeaderImage(null);
                }
            }
        }
        finally {
            this.getHeaderForm().getForm().setRedraw(true);
        }
    }

    private void setHeaderImage(final Image image) {
        BusyIndicator busyLabel = this.getBusyLabel();
        if (busyLabel == null) {
            return;
        }
        final Point size = this.leftToolBar.computeSize(-1, -1, true);
        Point titleSize = this.titleLabel.computeSize(-1, -1, true);
        size.x += titleSize.x + 3;
        size.y = Math.max(titleSize.y, size.y);
        final int padding = size.x > 0 && !this.noExtraPadding ? 10 : 1;
        final Rectangle imageBounds = image != null ? image.getBounds() : new Rectangle(0, 0, 0, 0);
        int tempHeight = image != null ? Math.max(size.y + 1, imageBounds.height) : size.y + 1;
        final int height = tempHeight > imageBounds.height + 5 ? tempHeight - 5 : tempHeight;
        CompositeImageDescriptor descriptor = new CompositeImageDescriptor(){

            protected void drawCompositeImage(int width, int height2) {
                if (image != null) {
                    this.drawImage(image.getImageData(), size.x + padding, (height2 - image.getBounds().height) / 2);
                }
            }

            protected Point getSize() {
                return new Point(size.x + padding + imageBounds.width, height);
            }
        };
        Image newHeaderImage = descriptor.createImage();
        busyLabel.setImage(newHeaderImage);
        if (this.headerImage != null) {
            this.headerImage.dispose();
        }
        this.headerImage = newHeaderImage;
        this.getHeaderForm().getForm().reflow(true);
    }

    public String getMessage() {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            Form form = this.getHeaderForm().getForm().getForm();
            return form.getMessage();
        }
        return null;
    }

    public void setStatus(String message, final String title, final IStatus status) {
        this.setMessage(message, 3, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                TasksUiInternal.displayStatus(title, status);
            }
        });
    }

    public void showBusy(boolean busy) {
        Form form;
        if (this.editorBusyIndicator != null) {
            if (busy) {
                if (TasksUiInternal.isAnimationsEnabled()) {
                    this.editorBusyIndicator.start();
                }
            } else {
                this.editorBusyIndicator.stop();
            }
        }
        if (!this.isHeaderFormDisposed() && (form = this.getHeaderForm().getForm().getForm()) != null && !form.isDisposed()) {
            ToolBar control;
            IToolBarManager toolBarManager = form.getToolBarManager();
            if (toolBarManager instanceof ToolBarManager && (control = ((ToolBarManager)toolBarManager).getControl()) != null) {
                control.setEnabled(!busy);
            }
            if (this.leftToolBar != null) {
                this.leftToolBar.setEnabled(!busy);
            }
            if (this.titleLabel != null) {
                this.titleLabel.setEnabled(!busy);
            }
            CommonUiUtil.setEnabled((Composite)form.getBody(), (!busy ? 1 : 0) != 0);
            IFormPage[] iFormPageArray = this.getPages();
            int n = iFormPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPage page = iFormPageArray[n2];
                if (page instanceof WorkbenchPart) {
                    WorkbenchPart part = (WorkbenchPart)page;
                    part.showBusy(busy);
                }
                ++n2;
            }
        }
    }

    private void updateHeader() {
        IEditorInput input = this.getEditorInput();
        this.updateHeaderImage();
        this.updateHeaderLabel();
        this.setTitleToolTip(input.getToolTipText());
        this.setPartName(input.getName());
    }

    public void updateHeaderToolBar() {
        if (this.isHeaderFormDisposed()) {
            return;
        }
        Form form = this.getHeaderForm().getForm().getForm();
        this.toolBarManager = form.getToolBarManager();
        this.toolBarManager.removeAll();
        TaskRepository outgoingNewRepository = TasksUiUtil.getOutgoingNewTaskRepository(this.task);
        final TaskRepository taskRepository = outgoingNewRepository != null ? outgoingNewRepository : this.taskEditorInput.getTaskRepository();
        ControlContribution repositoryLabelControl = new ControlContribution(Messages.AbstractTaskEditorPage_Title){

            protected Control createControl(Composite parent) {
                FormToolkit toolkit = TaskEditor.this.getHeaderForm().getToolkit();
                Composite composite = toolkit.createComposite(parent);
                RowLayout layout = new RowLayout();
                if (PlatformUtil.hasNarrowToolBar()) {
                    layout.marginTop = 0;
                    layout.marginBottom = 0;
                    layout.center = true;
                }
                composite.setLayout((Layout)layout);
                composite.setBackground(null);
                String label = taskRepository.getRepositoryLabel();
                if (label.indexOf("//") != -1) {
                    label = label.substring(taskRepository.getRepositoryUrl().indexOf("//") + 2);
                }
                ImageHyperlink link = new ImageHyperlink(composite, 0);
                link.setText(label);
                link.setFont(JFaceResources.getBannerFont());
                link.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                link.setToolTipText(Messages.TaskEditor_Edit_Task_Repository_ToolTip);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TasksUiUtil.openEditRepositoryWizard(taskRepository);
                    }
                });
                return composite;
            }
        };
        this.toolBarManager.add((IContributionItem)repositoryLabelControl);
        this.toolBarManager.add((IContributionItem)new GroupMarker("repository"));
        this.toolBarManager.add((IContributionItem)new GroupMarker("new"));
        this.toolBarManager.add((IContributionItem)new GroupMarker("open"));
        this.toolBarManager.add((IContributionItem)new GroupMarker("additions"));
        String taskUrl = TasksUiInternal.getAuthenticatedUrl(taskRepository, (IRepositoryElement)this.task);
        if (taskUrl != null && taskUrl.length() > 0) {
            this.openWithBrowserAction = new Action(){

                public void run() {
                    TasksUiUtil.openWithBrowser(taskRepository, (IRepositoryElement)TaskEditor.this.task);
                }
            };
            this.openWithBrowserAction.setImageDescriptor(CommonImages.WEB);
            this.openWithBrowserAction.setToolTipText(Messages.AbstractTaskEditorPage_Open_with_Web_Browser);
            this.toolBarManager.appendToGroup("open", (IAction)this.openWithBrowserAction);
        }
        if (this.activateAction == null) {
            this.activateAction = new ToggleTaskActivationAction(this.task){

                public void run() {
                    TaskList taskList = TasksUiPlugin.getTaskList();
                    if (taskList.getTask(TaskEditor.this.task.getRepositoryUrl(), TaskEditor.this.task.getTaskId()) == null) {
                        TaskEditor.this.setMessage(Messages.TaskEditor_Task_added_to_the_Uncategorized_container, 1);
                    }
                    super.run();
                }
            };
        }
        this.toolBarManager.add((IContributionItem)new Separator("planning"));
        this.disposeScheduleAction();
        this.scheduleAction = new TaskEditorScheduleAction(this.task);
        this.toolBarManager.add((IAction)this.scheduleAction);
        this.toolBarManager.add((IContributionItem)new GroupMarker("page"));
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof TaskFormPage) {
                TaskFormPage taskEditorPage = (TaskFormPage)page;
                taskEditorPage.fillToolBar(this.toolBarManager);
            }
            ++n2;
        }
        this.toolBarManager.add((IContributionItem)new Separator("activation"));
        this.menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (this.menuService != null && this.toolBarManager instanceof ContributionManager) {
            this.menuService.populateContributionManager((ContributionManager)this.toolBarManager, "toolbar:org.eclipse.mylyn.tasks.ui.editors.task.toolbar.header." + taskRepository.getConnectorKind());
            this.menuService.populateContributionManager((ContributionManager)this.toolBarManager, "toolbar:org.eclipse.mylyn.tasks.ui.editors.task.toolbar.header");
        }
        this.toolBarManager.update(true);
        this.updateLeftHeaderToolBar();
        this.updateHeader();
    }

    private void disposeScheduleAction() {
        if (this.scheduleAction != null) {
            this.scheduleAction.dispose();
            this.scheduleAction = null;
        }
    }

    private void updateLeftHeaderToolBar() {
        this.leftToolBarManager.removeAll();
        this.leftToolBarManager.add((IContributionItem)new Separator("activation"));
        this.leftToolBarManager.add((IContributionItem)new Separator("additions"));
        this.leftToolBarManager.add((IAction)this.activateAction);
        this.menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        if (this.menuService != null && this.leftToolBarManager instanceof ContributionManager) {
            TaskRepository outgoingNewRepository = TasksUiUtil.getOutgoingNewTaskRepository(this.task);
            TaskRepository taskRepository = outgoingNewRepository != null ? outgoingNewRepository : this.taskEditorInput.getTaskRepository();
            this.menuService.populateContributionManager((ContributionManager)this.leftToolBarManager, "toolbar:org.eclipse.mylyn.tasks.ui.editors.task.toolbar.header.left." + taskRepository.getConnectorKind());
        }
        this.leftToolBarManager.update(true);
        if (this.hasLeftToolBar()) {
            Point size = this.leftToolBar.getSize();
            if (size.x == 0 && size.y == 0) {
                size = this.leftToolBar.computeSize(-1, -1, true);
                this.leftToolBar.setSize(size);
            }
        }
    }

    private void updateHeaderImage() {
        if (this.hasLeftToolBar()) {
            this.setHeaderImage(null);
        } else {
            this.getHeaderForm().getForm().setImage(this.getBrandingImage());
        }
    }

    private Image getBrandingImage() {
        TaskRepository outgoingNewRepository = TasksUiUtil.getOutgoingNewTaskRepository(this.task);
        String connectorKind = outgoingNewRepository != null ? outgoingNewRepository.getConnectorKind() : this.task.getConnectorKind();
        if ("local".equals(connectorKind)) {
            return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK);
        }
        ImageDescriptor overlay = TasksUiPlugin.getDefault().getOverlayIcon(connectorKind);
        Image image = CommonImages.getImageWithOverlay((ImageDescriptor)TasksUiImages.REPOSITORY, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
        return image;
    }

    private boolean hasLeftToolBar() {
        return this.leftToolBar != null && this.leftToolBarManager != null;
    }

    private void updateHeaderLabel() {
        String idLabel;
        TaskRepository outgoingNewRepository = TasksUiUtil.getOutgoingNewTaskRepository(this.task);
        TaskRepository taskRepository = outgoingNewRepository != null ? outgoingNewRepository : this.taskEditorInput.getTaskRepository();
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
        String kindLabel = Messages.TaskEditor_Task;
        if (connectorUi != null) {
            kindLabel = connectorUi.getTaskKindLabel(this.task);
        }
        if ((idLabel = this.task.getTaskKey()) != null) {
            kindLabel = String.valueOf(kindLabel) + " " + idLabel;
        }
        if (this.hasLeftToolBar() && this.titleLabel != null) {
            this.titleLabel.setText(kindLabel);
            this.getHeaderForm().getForm().setText(null);
            this.setHeaderImage(null);
        } else {
            this.getHeaderForm().getForm().setText(kindLabel);
        }
    }

    @Deprecated
    public void updateTitle(String name) {
        this.updateHeader();
    }

    private void updateTitleImage() {
        if (this.task != null) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.task.getConnectorKind());
            if (connectorUi != null) {
                ImageDescriptor overlayDescriptor = connectorUi.getTaskKindOverlay(this.task);
                this.setTitleImage(CommonImages.getCompositeTaskImage((ImageDescriptor)TasksUiImages.TASK, (ImageDescriptor)overlayDescriptor, (boolean)false));
            } else {
                this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
            }
        } else {
            this.setTitleImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK));
        }
    }
}

