/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSSlider;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTSlider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    int increment = 1;
    int pageIncrement = 10;

    public Scale(Composite parent, int style) {
        super(parent, Scale.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Scale.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        NSSlider widget = (NSSlider)this.view;
        float thickness = widget.knobThickness();
        int width = 64;
        int height = 64;
        if ((this.style & 0x100) != 0) {
            height = (int)Math.ceil(thickness);
            width = height * 10;
        } else {
            width = (int)Math.ceil(thickness);
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        NSSlider widget = (NSSlider)new SWTSlider().alloc();
        widget.init();
        widget.setMaxValue(100.0);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
    }

    NSFont defaultNSFont() {
        return this.display.sliderFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)((NSSlider)this.view).maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)((NSSlider)this.view).minValue();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)((NSSlider)this.view).doubleValue();
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void sendSelection() {
        NSEvent currEvent = NSApplication.sharedApplication().currentEvent();
        if (currEvent.type() != 2) {
            this.sendSelectionEvent(13);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)((NSSlider)this.view).minValue();
        if (value <= minimum) {
            return;
        }
        ((NSSlider)this.view).setMaxValue(value);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)((NSSlider)this.view).maxValue();
        if (value < 0 || value >= maximum) {
            return;
        }
        ((NSSlider)this.view).setMinValue(value);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        ((NSSlider)this.view).setDoubleValue(value);
    }
}

