/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.Comment;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.NodeList;
import org.eclipse.wst.dtd.core.internal.Notation;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.core.internal.Unrecognized;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.core.internal.event.IDTDFileListener;
import org.eclipse.wst.dtd.core.internal.event.NodesEvent;
import org.eclipse.wst.dtd.core.internal.util.DTDExternalReferenceRemover;
import org.eclipse.wst.dtd.core.internal.util.DTDModelUpdater;
import org.eclipse.wst.dtd.core.internal.util.DTDNotationReferenceRemover;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class DTDFile
implements IndexedRegion {
    private NodeList attlistList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG");
    private NodeList commentList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT");
    boolean creatingNewModel = false;
    private DTDModelImpl fDTDModel;
    private NodeList elementList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG");
    private NodeList entityList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG");
    private List folderList = null;
    private boolean isMovingNode = false;
    private List modelListeners = new ArrayList();
    private List nodeList = new ArrayList();
    private NodeList notationList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG");
    private NodeList unrecognizedList = new NodeList(this, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.UNKNOWN_CONTENT");

    public DTDFile(DTDModelImpl dtdModel) {
        this.fDTDModel = dtdModel;
    }

    public void addDTDFileListener(IDTDFileListener listener) {
        this.modelListeners.add(listener);
    }

    protected void addNode(DTDNode node) {
        this.addNode(this.nodeList.size(), node);
    }

    protected void addNode(int index, DTDNode node) {
        this.nodeList.add(index, node);
    }

    public DTDNode buildNode(IStructuredDocumentRegion flatNode) {
        TopLevelNode node = null;
        if (this.isElement(flatNode)) {
            node = new Element(this, flatNode);
        } else if (this.isEntity(flatNode)) {
            node = new Entity(this, flatNode);
        } else if (this.isNotation(flatNode)) {
            node = new Notation(this, flatNode);
        } else if (this.isAttributeList(flatNode)) {
            node = new AttributeList(this, flatNode);
        } else if (this.isComment(flatNode)) {
            node = new Comment(this, flatNode);
        } else if (this.isParameterEntityReference(flatNode)) {
            node = new ParameterEntityReference(this, flatNode);
        } else if (!flatNode.getText().trim().equals("")) {
            node = new Unrecognized(this, flatNode);
        }
        if (node != null) {
            this.insertNode(node);
            ((DTDNode)node).resolveRegions();
        }
        return node;
    }

    public void buildNodes(IStructuredDocumentRegionList list) {
        NodesEvent addedDTDNodes = new NodesEvent();
        TopLevelNode previousNode = null;
        int i = 0;
        while (i < list.getLength()) {
            IStructuredDocumentRegion flatNode = list.item(i);
            TopLevelNode node = (TopLevelNode)this.buildNode(flatNode);
            if (node != null) {
                previousNode = node;
                addedDTDNodes.add(node);
            } else if (previousNode != null) {
                previousNode.addWhitespaceStructuredDocumentRegion(flatNode);
            }
            ++i;
        }
        if (addedDTDNodes.getNodes().size() > 0) {
            this.notifyNodesAdded(addedDTDNodes);
        }
    }

    public boolean contains(int testPosition) {
        return this.getStartOffset() <= testPosition && testPosition <= this.getEndOffset();
    }

    public void createAttributeList(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_ATTR_LIST);
        String newStream = "<!ATTLIST " + name + ">\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void createComment(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_COMMENT);
        String newStream = "<!-- " + name + " -->\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void createElement(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_ELEMENT);
        String newStream = "<!ELEMENT " + name + " EMPTY>\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void createEntity(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_ENTITY);
        String newStream = "<!ENTITY " + name + " \"\">\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void createNotation(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_NOTATION);
        String newStream = "<!NOTATION " + name + " SYSTEM \"\">\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void createParameterEntityReference(DTDNode node, String name, boolean isAfter) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_ADD_PARM_ENTITY_REF);
        String newStream = String.valueOf(name) + "\n";
        int offset = this.getInsertOffset(node, isAfter);
        this.getStructuredDocument().replaceText((Object)this, offset, 0, newStream);
        this.getDTDModel().endRecording(this);
    }

    public void deleteNode(DTDNode node) {
        this.getDTDModel().beginRecording(this, DTDCoreMessages._UI_LABEL_DTD_FILE_DELETE);
        this.deleteNode(this, node);
        this.getDTDModel().endRecording(this);
    }

    public void deleteNode(Object requestor, DTDNode node) {
        DTDNode parent = (DTDNode)((Object)node.getParentNode());
        if (parent != null) {
            parent.delete(requestor, node);
        } else {
            if (!this.isMovingNode) {
                DTDModelUpdater updater = new DTDModelUpdater();
                updater.objectAboutToBeDeleted(requestor, node);
                if (node instanceof ParameterEntityReference) {
                    Entity referencedEntity = ((ParameterEntityReference)node).getEntityObject();
                    if (referencedEntity != null) {
                        DTDExternalReferenceRemover remover = new DTDExternalReferenceRemover();
                        remover.externalReferenceAboutToChange(requestor, referencedEntity);
                    }
                } else if (node instanceof Notation) {
                    Notation notation = (Notation)node;
                    DTDNotationReferenceRemover remover = new DTDNotationReferenceRemover();
                    remover.notationAboutToBeDeleted(requestor, notation);
                }
            }
            int startOffset = node.getStartOffset();
            int endOffset = node.getWhitespaceEndOffset();
            if (node instanceof TopLevelNode) {
                endOffset = this.getInsertOffset(node, true);
            }
            this.getStructuredDocument().replaceText(requestor, startOffset, endOffset - startOffset, "");
        }
    }

    public NodeList getComments() {
        return this.commentList;
    }

    public DTDModelImpl getDTDModel() {
        return this.fDTDModel;
    }

    public NodeList getElementsAndParameterEntityReferences() {
        return this.elementList;
    }

    public int getEndOffset() {
        int result = -1;
        IStructuredDocumentRegion region = this.getStructuredDocument().getLastStructuredDocumentRegion();
        if (region != null) {
            result = region.getEndOffset();
        }
        return result;
    }

    public int getLength() {
        int end;
        int result = -1;
        int start = this.getStartOffset();
        if (start >= 0 && (end = this.getEndOffset()) >= 0 && (result = end - start) < -1) {
            result = -1;
        }
        return result;
    }

    public NodeList getEntities() {
        return this.entityList;
    }

    public Image getImage() {
        return DTDCorePlugin.getInstance().getImage("icons/full/obj16/DTDFile.gif");
    }

    public int getInsertOffset(DTDNode node, boolean isAfter) {
        int offset = 0;
        if (node != null) {
            if (isAfter) {
                int index = this.getNodes().indexOf((Object)this.getNode(node.getStructuredDTDDocumentRegion()));
                DTDNode afterNode = null;
                if (index + 1 < this.getNodes().size()) {
                    afterNode = (DTDNode)((Object)this.getNodes().get(index + 1));
                }
                if (afterNode != null) {
                    offset = afterNode.getStructuredDTDDocumentRegion().getStartOffset();
                } else if (this.getStructuredDocument().getLastStructuredDocumentRegion() != null) {
                    offset = this.getStructuredDocument().getLastStructuredDocumentRegion().getEndOffset();
                }
            } else {
                offset = node.getStructuredDTDDocumentRegion().getStartOffset();
            }
        } else if (this.getStructuredDocument().getLastStructuredDocumentRegion() != null) {
            offset = this.getStructuredDocument().getLastStructuredDocumentRegion().getEndOffset();
        }
        return offset;
    }

    public String getName() {
        Path path = new Path(this.getDTDModel().getId().toString());
        return path.lastSegment();
    }

    public DTDNode getNode(IStructuredDocumentRegion flatNode) {
        int i = 0;
        while (i < this.nodeList.size()) {
            DTDNode node = (DTDNode)((Object)this.nodeList.get(i));
            if (node.getStructuredDTDDocumentRegion() == flatNode) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public IndexedRegion getNodeAt(int offset) {
        DTDNode node = this.getTopLevelNodeAt(offset);
        if (node != null) {
            return node.getDeepestNode(offset);
        }
        return null;
    }

    public IndexedRegion getNodeAt(int startOffset, int endOffset) {
        DTDNode node = this.getTopLevelNodeAt(startOffset);
        if (node != null) {
            return node.getDeepestNode(startOffset, endOffset);
        }
        return null;
    }

    public List getNodeLists() {
        if (this.folderList == null) {
            this.folderList = new ArrayList();
            this.folderList.add(this.notationList);
            this.folderList.add(this.entityList);
            this.folderList.add(this.elementList);
            this.folderList.add(this.attlistList);
            this.folderList.add(this.commentList);
            this.folderList.add(this.unrecognizedList);
        }
        return this.folderList;
    }

    public List getNodes() {
        return this.nodeList;
    }

    public NodeList getNotations() {
        return this.notationList;
    }

    public int getStartOffset() {
        int result = -1;
        IStructuredDocumentRegion region = this.getStructuredDocument().getFirstStructuredDocumentRegion();
        if (region != null) {
            result = region.getStartOffset();
        }
        return result;
    }

    public IStructuredDocument getStructuredDocument() {
        return this.fDTDModel.getStructuredDocument();
    }

    public DTDNode getTopLevelNodeAt(int offset) {
        DTDNode bestNode = null;
        int i = 0;
        while (i < this.nodeList.size()) {
            DTDNode node = (DTDNode)((Object)this.nodeList.get(i));
            if (node.contains(offset)) {
                if (bestNode == null) {
                    bestNode = node;
                } else if (node.getStartOffset() > bestNode.getStartOffset()) {
                    bestNode = node;
                }
            }
            ++i;
        }
        return bestNode;
    }

    public NodeList getUnrecognized() {
        return this.unrecognizedList;
    }

    public void insertIntoModel(Object requestor, DTDNode reference, DTDNode node, boolean isAfter) {
        String nodeText = "";
        nodeText = node instanceof TopLevelNode ? ((TopLevelNode)node).getFullText() : node.getNodeText();
        int offset = this.getInsertOffset(reference, isAfter);
        this.getStructuredDocument().replaceText(requestor, offset, 0, nodeText);
    }

    public void insertNode(DTDNode node) {
        int startOffset = node.getStartOffset();
        int insertIndex = -1;
        int i = 0;
        while (i < this.getNodes().size()) {
            DTDNode currentNode = (DTDNode)((Object)this.getNodes().get(i));
            if (currentNode.getEndOffset() > startOffset) {
                insertIndex = i;
                break;
            }
            ++i;
        }
        if (insertIndex == -1) {
            insertIndex = this.getNodes().size();
        }
        this.addNode(insertIndex, node);
    }

    public boolean isAttributeList(IStructuredDocumentRegion flatNode) {
        if (flatNode.getRegions().size() >= 3) {
            ITextRegion second = flatNode.getRegions().get(1);
            ITextRegion third = flatNode.getRegions().get(2);
            if (second.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.EXCLAMATION") && third.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG")) {
                return true;
            }
        }
        return false;
    }

    public boolean isComment(IStructuredDocumentRegion flatNode) {
        ITextRegion region;
        return flatNode.getRegions().size() >= 2 && (region = flatNode.getRegions().get(1)).getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT");
    }

    public boolean isElement(IStructuredDocumentRegion flatNode) {
        if (flatNode.getRegions().size() >= 3) {
            ITextRegion second = flatNode.getRegions().get(1);
            ITextRegion third = flatNode.getRegions().get(2);
            if (second.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.EXCLAMATION") && third.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ELEMENT_TAG")) {
                return true;
            }
        }
        return false;
    }

    public boolean isEntity(IStructuredDocumentRegion flatNode) {
        if (flatNode.getRegions().size() >= 3) {
            ITextRegion second = flatNode.getRegions().get(1);
            ITextRegion third = flatNode.getRegions().get(2);
            if (second.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.EXCLAMATION") && third.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_TAG")) {
                return true;
            }
        }
        return false;
    }

    public boolean isNotation(IStructuredDocumentRegion flatNode) {
        if (flatNode.getRegions().size() >= 3) {
            ITextRegion second = flatNode.getRegions().get(1);
            ITextRegion third = flatNode.getRegions().get(2);
            if (second.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.EXCLAMATION") && third.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NOTATION_TAG")) {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterEntityReference(IStructuredDocumentRegion flatNode) {
        ITextRegion region;
        return flatNode.getRegions().size() == 1 && (region = flatNode.getRegions().get(0)).getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ENTITY_PARM");
    }

    boolean isSameTopLevelType(DTDNode affectedNode) {
        IStructuredDocumentRegion flatNode = affectedNode.getStructuredDTDDocumentRegion();
        if (affectedNode instanceof Element && this.isElement(flatNode)) {
            return true;
        }
        if (affectedNode instanceof Entity && this.isEntity(flatNode)) {
            return true;
        }
        if (affectedNode instanceof Comment && this.isComment(flatNode)) {
            return true;
        }
        if (affectedNode instanceof AttributeList && this.isAttributeList(flatNode)) {
            return true;
        }
        if (affectedNode instanceof Notation && this.isNotation(flatNode)) {
            return true;
        }
        return affectedNode instanceof Unrecognized && this.isUnrecognized(flatNode);
    }

    public boolean isUnrecognized(IStructuredDocumentRegion flatNode) {
        return !this.isElement(flatNode) && !this.isEntity(flatNode) && !this.isNotation(flatNode) && !this.isParameterEntityReference(flatNode) && !this.isAttributeList(flatNode) && !this.isComment(flatNode);
    }

    public void moveNode(Object requestor, DTDNode referenceNode, DTDNode nodeToMove, boolean isAfter) {
        this.isMovingNode = true;
        this.deleteNode(requestor, nodeToMove);
        this.insertIntoModel(requestor, referenceNode, nodeToMove, isAfter);
        this.isMovingNode = false;
    }

    public void newModel(NewDocumentEvent event) {
        this.creatingNewModel = true;
        this.nodeList.clear();
        NodesEvent removeEvent = new NodesEvent();
        removeEvent.getNodes().addAll(this.nodeList);
        this.notifyNodesRemoved(removeEvent);
        if (event.getStructuredDocument() != null && event.getStructuredDocument().getRegionList() != null) {
            this.buildNodes(event.getStructuredDocument().getRegionList());
        }
        this.creatingNewModel = false;
    }

    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        IStructuredDocumentRegionList oldNodes = event.getOldStructuredDocumentRegions();
        NodesEvent removedDTDNodes = new NodesEvent();
        int i = 0;
        while (i < oldNodes.getLength()) {
            IStructuredDocumentRegion flatNode = oldNodes.item(i);
            Iterator iter = this.getNodes().iterator();
            while (iter.hasNext()) {
                DTDNode node = (DTDNode)((Object)iter.next());
                if (node.getStructuredDTDDocumentRegion() != flatNode) continue;
                removedDTDNodes.add(node);
            }
            ++i;
        }
        this.buildNodes(event.getNewStructuredDocumentRegions());
        if (removedDTDNodes.getNodes().size() > 0) {
            this.notifyNodesRemoved(removedDTDNodes);
            this.removeNodes(removedDTDNodes.getNodes());
        }
    }

    public void notifyNodeChanged(DTDNode node) {
        Iterator iter = this.modelListeners.iterator();
        while (iter.hasNext()) {
            IDTDFileListener listener = (IDTDFileListener)iter.next();
            listener.nodeChanged(node);
        }
    }

    public void notifyNodesAdded(NodesEvent addedNodes) {
        Iterator iter = this.modelListeners.iterator();
        while (iter.hasNext()) {
            IDTDFileListener listener = (IDTDFileListener)iter.next();
            listener.nodesAdded(addedNodes);
        }
    }

    protected void notifyNodesRemoved(NodesEvent event) {
        Iterator iter = this.modelListeners.iterator();
        while (iter.hasNext()) {
            IDTDFileListener listener = (IDTDFileListener)iter.next();
            listener.nodesRemoved(event);
        }
    }

    public void rebuildNodes(List nodes) {
        this.removeNodes(nodes);
        NodesEvent addedDTDNodes = new NodesEvent();
        Iterator dtdNodes = nodes.iterator();
        while (dtdNodes.hasNext()) {
            DTDNode dtdNode = (DTDNode)((Object)dtdNodes.next());
            DTDNode node = this.buildNode(dtdNode.getStructuredDTDDocumentRegion());
            if (node == null) continue;
            addedDTDNodes.add(node);
        }
        if (addedDTDNodes.getNodes().size() > 0) {
            this.notifyNodesAdded(addedDTDNodes);
        }
    }

    public void regionChanged(RegionChangedEvent event) {
        ITextRegion changedRegion = event.getRegion();
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        DTDNode affectedNode = (DTDNode)this.getNodeAt(flatNode.getStartOffset(changedRegion), flatNode.getEndOffset(changedRegion));
        if (affectedNode != null) {
            this.notifyNodeChanged(affectedNode);
        }
    }

    public void regionsReplaced(RegionsReplacedEvent event) {
        ArrayList<DTDNode> nodesToRebuild = new ArrayList<DTDNode>();
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        DTDNode affectedNode = this.getNode(flatNode);
        if (!this.isSameTopLevelType(affectedNode)) {
            NodesEvent removedDTDNodes = new NodesEvent();
            removedDTDNodes.add(affectedNode);
            this.notifyNodesRemoved(removedDTDNodes);
            nodesToRebuild.add(affectedNode);
            this.rebuildNodes(nodesToRebuild);
        } else {
            affectedNode.resolveRegions();
            this.notifyNodeChanged(affectedNode);
            NodesEvent addedDTDNodes = new NodesEvent();
            ITextRegionList newRegions = event.getNewRegions();
            int size = newRegions.size();
            int i = 0;
            while (i < size) {
                ITextRegion region = newRegions.get(i);
                DTDNode deepestNode = affectedNode.getDeepestNode(flatNode.getStartOffset(region), flatNode.getEndOffset(region));
                if (deepestNode != affectedNode && !addedDTDNodes.getNodes().contains((Object)deepestNode)) {
                    addedDTDNodes.add(deepestNode);
                }
                ++i;
            }
            if (addedDTDNodes.getNodes().size() > 0) {
                this.notifyNodesAdded(addedDTDNodes);
            }
        }
    }

    public void removeDTDFileListener(IDTDFileListener listener) {
        this.modelListeners.remove(listener);
    }

    protected void removeNodes(List nodes) {
        this.getNodes().removeAll(nodes);
    }
}

