/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.ui.editors.PriorityEditor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PriorityAttributeEditor
extends AbstractAttributeEditor {
    private PriorityEditor editor;
    private ITaskMapping mapping;
    private final TaskDataModelListener modelListener = new TaskDataModelListener(){

        public void attributeChanged(TaskDataModelEvent event) {
            if (PriorityAttributeEditor.this.getTaskAttribute().equals((Object)event.getTaskAttribute())) {
                PriorityAttributeEditor.this.refresh();
            }
        }
    };

    public PriorityAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
        boolean noOptions = this.getAttributeMapper().getOptions(this.getTaskAttribute()).size() == 0;
        this.setReadOnly(this.isReadOnly() || noOptions);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(this.getModel().getTaskRepository().getConnectorKind());
        this.mapping = connector.getTaskMapping(this.getModel().getTaskData());
        this.editor = new PriorityEditor(){

            protected void valueChanged(String value) {
                PriorityAttributeEditor.this.setValue(value);
            }
        };
        this.editor.setReadOnly(this.isReadOnly());
        this.editor.createControl(parent, toolkit);
        this.setControl(this.editor.getControl());
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PriorityAttributeEditor.this.getModel().removeModelListener(PriorityAttributeEditor.this.modelListener);
            }
        });
        this.getModel().addModelListener(this.modelListener);
        this.refresh();
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getTaskAttribute());
    }

    public void refresh() {
        this.editor.setLabelByValue(this.getAttributeMapper().getOptions(this.getTaskAttribute()));
        this.updateEditor();
    }

    public void setValue(String value) {
        String oldValue = this.getAttributeMapper().getValue(this.getTaskAttribute());
        if (!oldValue.equals(value)) {
            this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
            this.attributeChanged();
            this.updateEditor();
        }
    }

    private void updateEditor() {
        this.editor.select(this.getValue(), this.mapping.getPriorityLevel());
        this.editor.setToolTipText(this.getValueLabel());
    }
}

