/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.XMLCoreMessages;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.InvalidCharacterException;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SourceValidator {
    private NodeImpl node = null;

    public SourceValidator(Node node) {
        if (node != null) {
            this.node = (NodeImpl)node;
        }
    }

    /*
     * Unable to fully structure code
     */
    public String convertSource(String source) {
        if (source == null) {
            return null;
        }
        if (this.node == null) {
            return null;
        }
        acceptTag = false;
        acceptClose = false;
        acceptQuote = false;
        acceptAmpersand = false;
        acceptEntityRef = true;
        acceptJSPEnd = true;
        endTagName = null;
        if (this.node.getNodeType() == 2) {
            document = (IDOMDocument)this.node.getOwnerDocument();
            if (document != null && document.isJSPType()) {
                acceptTag = true;
            }
            if (acceptTag && (element = (ElementImpl)(attr = (Attr)this.node).getOwnerElement()) != null && element.isJSPTag()) {
                acceptTag = false;
            }
            acceptQuote = source.indexOf(39) < 0;
        } else if (this.node.getNodeType() == 3) {
            text = (TextImpl)this.node;
            if (text.isJSPContent()) {
                index = source.indexOf("%>");
                if (index < 0) {
                    return source;
                }
                acceptTag = true;
                acceptClose = true;
                acceptQuote = true;
                acceptAmpersand = true;
                acceptJSPEnd = false;
            } else if (text.isCDATAContent()) {
                endTagName = text.getParentNode().getNodeName();
                if (endTagName == null) {
                    return null;
                }
                acceptTag = true;
                acceptClose = true;
                acceptQuote = true;
                acceptAmpersand = true;
            }
        } else {
            document = null;
            document = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
            if (document != null && document.isJSPType()) {
                acceptTag = true;
            }
        }
        buffer = null;
        copiedLength = 0;
        length = source.length();
        i = 0;
        while (i < length) {
            block30: {
                ref = null;
                c = source.charAt(i);
                switch (c) {
                    case '<': {
                        if (!acceptTag) ** GOTO lbl62
                        if (endTagName == null) ** GOTO lbl58
                        if (this.matchEndTag(source, i + 1, endTagName)) ** GOTO lbl62
                        break block30;
lbl58:
                        // 1 sources

                        skip = this.skipTag(source, i + 1);
                        if (skip < 0) ** GOTO lbl62
                        i += skip;
                        break block30;
lbl62:
                        // 3 sources

                        ref = "&lt;";
                        break;
                    }
                    case '>': {
                        if (!acceptClose) {
                            ref = "&gt;";
                            break;
                        }
                        break block30;
                    }
                    case '&': {
                        if (acceptAmpersand) break block30;
                        if (!acceptEntityRef || (skip = this.skipEntityRef(source, i + 1)) < 0) ** GOTO lbl74
                        i += skip;
                        break block30;
lbl74:
                        // 1 sources

                        ref = "&amp;";
                        break;
                    }
                    case '\"': {
                        if (!acceptQuote) {
                            ref = "&quot;";
                            break;
                        }
                        break block30;
                    }
                    case '%': {
                        if (!acceptJSPEnd && source.charAt(i + 1) == '>') {
                            ++i;
                            ref = "&gt;";
                            break;
                        }
                        break block30;
                    }
                    default: {
                        break block30;
                    }
                }
                if (ref != null) {
                    if (buffer == null) {
                        buffer = new StringBuffer(length + 8);
                    }
                    if (i > copiedLength) {
                        buffer.append(source.substring(copiedLength, i));
                    }
                    buffer.append(ref);
                    copiedLength = i + 1;
                }
            }
            ++i;
        }
        if (buffer != null) {
            if (copiedLength < length) {
                buffer.append(source.substring(copiedLength, length));
            }
            return buffer.toString();
        }
        return source;
    }

    private final boolean matchEndTag(String source, int offset, String endTagName) {
        int end;
        if (source == null || endTagName == null) {
            return false;
        }
        int length = source.length();
        if (offset < 0 || offset >= length) {
            return false;
        }
        if (source.charAt(offset) != '/') {
            return false;
        }
        if ((end = ++offset + endTagName.length()) > length) {
            return false;
        }
        return endTagName.equalsIgnoreCase(source.substring(offset, end));
    }

    private final int skipEntityRef(String source, int offset) {
        if (source == null) {
            return -1;
        }
        if (offset < 0 || offset >= source.length()) {
            return -1;
        }
        DocumentImpl document = (DocumentImpl)this.node.getOwnerDocument();
        if (document == null) {
            return -1;
        }
        int end = source.indexOf(59, offset);
        if (end < 0 || end == offset) {
            return -1;
        }
        String name = source.substring(offset, end);
        if (name == null || document.getCharValue(name) == null) {
            return -1;
        }
        return end + 1 - offset;
    }

    private final int skipTag(String source, int offset) {
        if (source == null) {
            return -1;
        }
        if (offset < 0 || offset >= source.length()) {
            return -1;
        }
        int end = offset;
        if (source.charAt(offset) == '%') {
            int found = source.indexOf("%>", offset + 1);
            if (found < 0) {
                return -1;
            }
            end = found + 2;
        } else {
            int found = source.lastIndexOf(62);
            if (found < offset) {
                return -1;
            }
            end = found + 1;
        }
        return end - offset;
    }

    /*
     * Unable to fully structure code
     */
    public boolean validateSource(String source) throws InvalidCharacterException {
        if (source == null) {
            return true;
        }
        if (this.node == null) {
            return false;
        }
        message = null;
        acceptTag = false;
        acceptClose = false;
        acceptQuote = true;
        acceptEntityRef = true;
        endTagName = null;
        if (this.node.getNodeType() == 2) {
            document = (IDOMDocument)this.node.getOwnerDocument();
            if (document != null && document.isJSPType()) {
                acceptTag = true;
            }
            if (acceptTag && (element = (ElementImpl)(attr = (Attr)this.node).getOwnerElement()) != null && element.isJSPTag()) {
                acceptTag = false;
            }
            acceptQuote = source.indexOf(39) < 0;
        } else if (this.node.getNodeType() == 3) {
            text = (TextImpl)this.node;
            if (text.isJSPContent()) {
                index = source.indexOf("%>");
                if (index < 0) {
                    return true;
                }
                message = XMLCoreMessages.Invalid_character_gt_fo_ERROR_;
                throw new InvalidCharacterException(message, '>', index + 1);
            }
            if (text.isCDATAContent()) {
                endTagName = text.getParentNode().getNodeName();
                if (endTagName == null) {
                    return false;
                }
                acceptTag = true;
                acceptClose = true;
            } else if (this.hasNestedRegion(text)) {
                return true;
            }
        } else {
            document = null;
            document = this.node.getNodeType() == 9 ? (IDOMDocument)this.node : (IDOMDocument)this.node.getOwnerDocument();
            if (document != null && document.isJSPType()) {
                acceptTag = true;
            }
        }
        c = '\u0000';
        length = source.length();
        i = 0;
        while (i < length) {
            block25: {
                c = source.charAt(i);
                switch (c) {
                    case '<': {
                        if (!acceptTag) ** GOTO lbl56
                        if (endTagName == null) ** GOTO lbl52
                        if (this.matchEndTag(source, i + 1, endTagName)) ** GOTO lbl56
                        break block25;
lbl52:
                        // 1 sources

                        skip = this.skipTag(source, i + 1);
                        if (skip < 0) ** GOTO lbl56
                        i += skip;
                        break block25;
lbl56:
                        // 3 sources

                        message = XMLCoreMessages.Invalid_character_lt_fo_ERROR_;
                        break;
                    }
                    case '>': {
                        if (!acceptClose) {
                            message = XMLCoreMessages.Invalid_character_gt_fo_ERROR_;
                            break;
                        }
                        break block25;
                    }
                    case '&': {
                        if (!acceptEntityRef) ** GOTO lbl70
                        if (endTagName != null) break block25;
                        skip = this.skipEntityRef(source, i + 1);
                        if (skip < 0) ** GOTO lbl70
                        i += skip;
                        break block25;
lbl70:
                        // 2 sources

                        message = XMLCoreMessages.Invalid_character_amp_fo_ERROR_;
                        break;
                    }
                    case '\"': {
                        if (!acceptQuote) {
                            message = XMLCoreMessages.Invalid_character__f_EXC_;
                            break;
                        }
                        break block25;
                    }
                    default: {
                        break block25;
                    }
                }
                if (message != null) {
                    throw new InvalidCharacterException(message, c, i);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean hasNestedRegion(TextImpl text) {
        boolean done = false;
        IStructuredDocumentRegion currRegion = text.getFirstStructuredDocumentRegion();
        IStructuredDocumentRegion lastRegion = text.getLastStructuredDocumentRegion();
        while (currRegion != null && !done) {
            ITextRegionList regions = currRegion.getRegions();
            int i = 0;
            while (i < regions.size()) {
                ITextRegionList regions2;
                ITextRegion container = regions.get(i);
                if (container instanceof ITextRegionContainer && (regions2 = ((ITextRegionContainer)container).getRegions()) != null) {
                    return true;
                }
                ++i;
            }
            done = currRegion == lastRegion;
            currRegion = currRegion.getNext();
        }
        return false;
    }
}

