/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class ConditionalTasks
extends Task
implements TaskContainer {
    private ArrayList tasks = new ArrayList();
    private String dirs;
    private String files;
    private String name;
    private String family;

    public void setFamily(String family) {
        this.family = family;
    }

    public void setDirs(String dirs) {
        this.dirs = dirs;
    }

    public void setFiles(String files) {
        this.files = files;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addTask(Task task) {
        this.tasks.add(this.tasks.size(), task);
    }

    public void execute() {
        File f;
        String condition;
        if (this.dirs == null && this.files == null) {
            throw new BuildException("ConditionalTasks: You must supply at least one of either the files or dirs properties");
        }
        if (this.name == null) {
            throw new BuildException("ConditionalTasks: You must supply a name for these conditional tasks!");
        }
        this.log("Verifying conditions for " + this.name);
        if (this.family != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.dirs, ",");
            boolean familyMatch = false;
            while (tokenizer.hasMoreElements() && !familyMatch) {
                String condition2 = (String)tokenizer.nextElement();
                if (!condition2.equals(this.family)) continue;
                familyMatch = true;
            }
            if (!familyMatch) {
                this.log("ConditionalTasks: OS Family '" + this.family + "' does not match; " + this.name + " will not be performed");
                return;
            }
        }
        File basedir = this.getProject().getBaseDir();
        if (this.dirs != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.dirs, ",");
            while (tokenizer.hasMoreElements()) {
                condition = (String)tokenizer.nextElement();
                f = new File(basedir, condition);
                if (f.exists() || (f = new File(condition)).exists()) continue;
                this.log("ConditionalTasks: Directory '" + condition + "' does not exist; " + this.name + " will not be performed");
                return;
            }
        }
        if (this.files != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.files, ",");
            while (tokenizer.hasMoreElements()) {
                condition = (String)tokenizer.nextElement();
                f = new File(basedir, condition);
                if (f.exists()) continue;
                this.log("ConditionalTasks: File '" + condition + "' does not exist; " + this.name + " will not be performed");
                return;
            }
        }
        System.out.println("Executing Conditional Tasks");
        for (Task task : this.tasks) {
            task.setProject(this.getProject());
            task.setOwningTarget(this.getOwningTarget());
            task.setLocation(this.getLocation());
            task.perform();
        }
    }
}

