/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.ui.XTextField;
import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.authentication.KBIRequestHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class KBIRequestHandlerDialog
extends JDialog
implements KBIRequestHandler {
    public static final String KBI_ICON = "largekbi.png";
    boolean cancelled;
    JLabel instructionLabel = new JLabel();
    JPanel buttonsPanel = new JPanel();
    JTextComponent[] promptReply;

    public KBIRequestHandlerDialog() {
        super((Frame)null, "", true);
        this.init();
    }

    public KBIRequestHandlerDialog(Frame frame) {
        super(frame, "", true);
        this.init();
    }

    public KBIRequestHandlerDialog(Dialog dialog) {
        super(dialog, "", true);
        this.init();
    }

    void init() {
        this.setDefaultCloseOperation(2);
        this.instructionLabel.setHorizontalAlignment(0);
        this.instructionLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 8, 4));
        JButton ok = new JButton("Ok");
        ok.setMnemonic('o');
        ok.setDefaultCapable(true);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KBIRequestHandlerDialog.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(ok);
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KBIRequestHandlerDialog.this.cancelled = true;
                KBIRequestHandlerDialog.this.setVisible(false);
            }
        });
        this.buttonsPanel.setLayout(new FlowLayout(2, 0, 0));
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.buttonsPanel.add(cancel);
        this.buttonsPanel.add(ok);
    }

    public void showPrompts(String name, String instruction, KBIPrompt[] prompts) {
        this.setTitle(name);
        this.getContentPane().invalidate();
        this.getContentPane().removeAll();
        this.instructionLabel.setText(instruction);
        JPanel promptPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.fill = 10;
        gbc.anchor = 17;
        this.promptReply = new JTextComponent[prompts.length];
        int i = 0;
        while (i < prompts.length) {
            this.promptReply[i] = prompts[i].echo() ? new XTextField(prompts[i].getResponse(), 15) : new JPasswordField(prompts[i].getResponse(), 15);
            System.out.println("Creating prompt " + prompts[i].getPrompt() + " and setting to " + prompts[i].getResponse());
            gbc.weightx = 0.0;
            UIUtil.jGridBagAdd(promptPanel, new JLabel(String.valueOf(prompts[i].getPrompt()) + " "), gbc, -1);
            gbc.weightx = 1.0;
            UIUtil.jGridBagAdd(promptPanel, this.promptReply[i], gbc, 0);
            ++i;
        }
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        centerPanel.add((Component)this.instructionLabel, "North");
        centerPanel.add((Component)promptPanel, "Center");
        IconWrapperPanel iconPanel = new IconWrapperPanel(new ResourceIcon(KBIRequestHandlerDialog.class, KBI_ICON), centerPanel);
        iconPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)iconPanel, "Center");
        mainPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(mainPanel);
        this.getContentPane().validate();
        this.pack();
        UIUtil.positionComponent(0, this);
        this.setVisible(true);
        if (!this.cancelled) {
            int i2 = 0;
            while (i2 < this.promptReply.length) {
                System.out.println("Setting reply " + i2 + " to " + this.promptReply[i2].getText());
                prompts[i2].setResponse(this.promptReply[i2].getText());
                ++i2;
            }
        }
    }
}

