/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.FilePermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import javax.swing.ImageIcon;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceIcon
extends ImageIcon {
    private static Log log = LogFactory.getLog((String)ResourceIcon.class.getName());
    Class cls;

    public ResourceIcon(Class cls, String image) {
        this.cls = cls;
        if (image.startsWith("/")) {
            this.loadImage(image);
        } else {
            String path = "/" + cls.getPackage().getName();
            path = path.replace('.', '/');
            path = String.valueOf(path) + "/" + image;
            this.loadImage(path);
        }
    }

    public ResourceIcon(URL url) {
        super(url);
    }

    public ResourceIcon(String imageName) {
        this.cls = this.getClass();
        this.loadImage(imageName);
    }

    protected void loadImage(String imageName) {
        Image image = null;
        URL url = this.cls.getResource(imageName);
        if (url != null) {
            log.debug((Object)url.toString());
            image = Toolkit.getDefaultToolkit().getImage(url);
        } else {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(imageName, "read"));
                }
                image = Toolkit.getDefaultToolkit().getImage(imageName);
            }
            catch (AccessControlException accessControlException) {
                log.error((Object)("Icon " + imageName + " could not be located as a " + "resource, and the current security manager will not " + "allow checking for a local file."));
            }
        }
        if (image != null) {
            this.setImage(image);
        }
    }
}

