/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.authentication.AuthorizationFileVerification;
import com.sshtools.daemon.authentication.PublicKeyVerification;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PublicKeyAuthenticationServer
extends SshAuthenticationServer {
    private static Class pkv = AuthorizationFileVerification.class;
    private Log log = LogFactory.getLog(PublicKeyAuthenticationServer.class);

    public String getMethodName() {
        return "publickey";
    }

    public static void setVerificationImpl(Class pkv) {
        PublicKeyAuthenticationServer.pkv = pkv;
    }

    /*
     * Loose catch block
     */
    public int authenticate(AuthenticationProtocolServer authentication, SshMsgUserAuthRequest msg) throws IOException {
        PublicKeyVerification verify;
        byte[] signature;
        byte[] encoded;
        String algorithm;
        block11: {
            NativeAuthenticationProvider authProv;
            block10: {
                ByteArrayReader bar;
                block9: {
                    bar = new ByteArrayReader(msg.getRequestData());
                    int check = bar.read();
                    algorithm = bar.readString();
                    encoded = bar.readBinaryString();
                    signature = null;
                    verify = (PublicKeyVerification)pkv.newInstance();
                    if (check != 0) break block9;
                    if (verify.acceptKey(msg.getUsername(), algorithm, encoded)) {
                        SshMsgUserAuthPKOK reply = new SshMsgUserAuthPKOK(algorithm, encoded);
                        authentication.sendMessage(reply);
                        return 1;
                    }
                    return 2;
                    {
                        catch (Exception exception) {}
                    }
                }
                signature = bar.readBinaryString();
                authProv = NativeAuthenticationProvider.getInstance();
                if (authProv != null) break block10;
                this.log.error((Object)"Authentication failed because no native authentication provider is available");
                return 2;
            }
            if (authProv.logonUser(msg.getUsername())) break block11;
            this.log.info((Object)("Authentication failed because " + msg.getUsername() + " is not a valid username"));
            return 2;
        }
        try {
            if (verify.verifyKeySignature(msg.getUsername(), algorithm, encoded, msg.getServiceName(), authentication.getSessionIdentifier(), signature)) {
                return 4;
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to create an instance of the verification implementation", (Throwable)ex);
        }
        return 2;
    }
}

