/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.platform;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NativeProcessProvider {
    private static Log log = LogFactory.getLog(NativeProcessProvider.class);
    private static Class provider;

    static {
        try {
            if (ConfigurationLoader.isConfigurationAvailable(PlatformConfiguration.class)) {
                provider = ConfigurationLoader.getExtensionClass(((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getNativeProcessProvider());
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to load native process provider", (Throwable)e);
            provider = null;
        }
    }

    public static NativeProcessProvider newInstance() throws IOException {
        try {
            return (NativeProcessProvider)provider.newInstance();
        }
        catch (Exception e) {
            throw new IOException("The process provider failed to create a new instance: " + e.getMessage());
        }
    }

    public static void setProvider(Class provider) {
        NativeProcessProvider.provider = provider;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract InputStream getStderrInputStream() throws IOException;

    public abstract void kill();

    public abstract boolean stillActive();

    public abstract int waitForExitCode();

    public abstract String getDefaultTerminalProvider();

    public abstract boolean createProcess(String var1, Map var2) throws IOException;

    public abstract void start() throws IOException;

    public abstract boolean supportsPseudoTerminal(String var1);

    public abstract boolean allocatePseudoTerminal(String var1, int var2, int var3, int var4, int var5, String var6);
}

