/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.vfs;

import com.sshtools.daemon.configuration.PlatformConfiguration;
import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.platform.UnsupportedFileOperationException;
import com.sshtools.daemon.vfs.VFSMount;
import com.sshtools.daemon.vfs.VFSPermission;
import com.sshtools.daemon.vfs.VFSPermissionHandler;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VirtualFileSystem
extends NativeFileSystemProvider {
    private static String USER_HOME = "/home/";
    private static Map vfsmounts;
    private static VFSMount vfsroot;
    private static Log log;
    private static VFSPermissionHandler permissionHandler;
    private Map openFiles = new HashMap();

    static {
        log = LogFactory.getLog(VirtualFileSystem.class);
        permissionHandler = null;
        try {
            vfsmounts = ((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getVFSMounts();
            vfsroot = ((PlatformConfiguration)ConfigurationLoader.getConfiguration(PlatformConfiguration.class)).getVFSRoot();
        }
        catch (ConfigurationException ex) {
            log.error((Object)"Failed to initialize the Virtual File System", (Throwable)ex);
        }
    }

    public VirtualFileSystem() throws IOException {
        if (!ConfigurationLoader.isConfigurationAvailable(PlatformConfiguration.class)) {
            throw new IOException("No valid platform configuration available");
        }
    }

    public static void setPermissionHandler(VFSPermissionHandler permissionHandler) {
        VirtualFileSystem.permissionHandler = permissionHandler;
    }

    private static String getVFSHomeDirectory(String username) throws FileNotFoundException {
        if (permissionHandler != null) {
            return permissionHandler.getVFSHomeDirectory(username);
        }
        return String.valueOf(USER_HOME) + username;
    }

    private static String getNFSHomeDirectory() throws FileNotFoundException {
        try {
            if (Thread.currentThread() instanceof SshThread && SshThread.hasUserContext()) {
                NativeAuthenticationProvider nap = NativeAuthenticationProvider.getInstance();
                return nap.getHomeDirectory(SshThread.getCurrentThreadUser());
            }
            throw new FileNotFoundException("There is no user logged in");
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public static boolean startsWithIgnoreCase(String str, String with) {
        return str.substring(0, with.length() > str.length() ? str.length() : with.length()).equalsIgnoreCase(with);
    }

    /*
     * Unable to fully structure code
     */
    public static String translateNFSPath(String nfspath) throws FileNotFoundException {
        if ((nfspath = nfspath.replace('\\', '/')).startsWith("./")) {
            nfspath = nfspath.substring(2);
        }
        try {
            nfshome = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
            nfshome = VirtualFileSystem.translateCanonicalPath(nfshome, nfshome);
            vfshome = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
            VirtualFileSystem.log.debug((Object)("NFSPath=" + nfspath));
            VirtualFileSystem.log.debug((Object)("NFSHome=" + nfshome));
            nfspath = VirtualFileSystem.translateCanonicalPath(nfspath, nfshome);
            nfspath.indexOf(nfshome);
            return String.valueOf(vfshome) + nfspath.substring(nfshome.length());
        }
        catch (FileNotFoundException v0) {
            ** for (entry : VirtualFileSystem.vfsmounts.entrySet())
        }
lbl-1000:
        // 1 sources

        {
            mount = (String)entry.getKey();
            m = (VFSMount)entry.getValue();
            path = m.getPath();
            VirtualFileSystem.log.debug((Object)(String.valueOf(m.getMount()) + "=" + m.getPath()));
            try {
                nfspath = VirtualFileSystem.translateCanonicalPath(nfspath, path);
                idx = nfspath.indexOf(path);
                buf = new StringBuffer(nfspath);
                buf = buf.replace(idx, idx + path.length(), mount);
                return buf.toString();
            }
            catch (FileNotFoundException v1) {}
            continue;
        }
lbl27:
        // 1 sources

        VirtualFileSystem.log.debug((Object)("VFSRoot=" + VirtualFileSystem.vfsroot.getPath()));
        nfspath = VirtualFileSystem.translateCanonicalPath(nfspath, VirtualFileSystem.vfsroot.getPath());
        path = nfspath.substring(VirtualFileSystem.vfsroot.getPath().length());
        return path.startsWith("/") != false ? path : "/" + path;
    }

    private static VFSMount getMount(String vfspath) throws FileNotFoundException, IOException {
        String vfshome = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
        if (vfspath.startsWith("/")) {
            if (vfspath.startsWith(vfshome)) {
                VFSMount m = new VFSMount(vfshome, VirtualFileSystem.getNFSHomeDirectory());
                m.setPermissions(new VFSPermission(SshThread.getCurrentThreadUser(), "rwx"));
                return m;
            }
            for (Map.Entry entry : vfsmounts.entrySet()) {
                String mount = (String)entry.getKey();
                if (!vfspath.startsWith(mount)) continue;
                return (VFSMount)entry.getValue();
            }
            if (vfsroot != null) {
                return vfsroot;
            }
            throw new FileNotFoundException("The path was not found");
        }
        VFSMount m = new VFSMount(vfshome, VirtualFileSystem.getNFSHomeDirectory());
        m.setPermissions(new VFSPermission(vfshome.substring(vfshome.lastIndexOf("/")), "rwx"));
        return m;
    }

    public static String translateVFSPath(String vfspath) throws FileNotFoundException {
        return VirtualFileSystem.translateVFSPath(vfspath, null);
    }

    public static String translateVFSPath(String vfspath, String vfscwd) throws FileNotFoundException {
        String path;
        vfspath = vfspath.replace('\\', '/').trim();
        try {
            if (!vfspath.startsWith("/")) {
                String path2 = vfscwd == null || vfscwd.trim().equals("") ? VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser()) : vfscwd;
                vfspath = String.valueOf(path2) + (path2.endsWith("/") ? "" : "/") + vfspath;
            }
            String nfshome = VirtualFileSystem.getNFSHomeDirectory().replace('\\', '/');
            String vfshome = VirtualFileSystem.getVFSHomeDirectory(SshThread.getCurrentThreadUser());
            if (vfspath.startsWith(vfshome)) {
                if (vfspath.length() > vfshome.length()) {
                    return VirtualFileSystem.translateCanonicalPath(String.valueOf(nfshome) + (nfshome.endsWith("/") ? "" : "/") + vfspath.substring(vfshome.length() + 1), nfshome);
                }
                return VirtualFileSystem.translateCanonicalPath(nfshome, nfshome);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        for (Map.Entry entry : vfsmounts.entrySet()) {
            String mount = (String)entry.getKey();
            VFSMount m = (VFSMount)entry.getValue();
            path = m.getPath();
            if (!vfspath.startsWith(mount)) continue;
            String str = String.valueOf(path) + vfspath.substring(mount.length());
            return VirtualFileSystem.translateCanonicalPath(str, path);
        }
        if (vfsroot != null) {
            path = String.valueOf(vfsroot.getPath()) + (vfsroot.getPath().endsWith("/") ? vfspath.substring(1) : vfspath);
            return VirtualFileSystem.translateCanonicalPath(path, vfsroot.getPath());
        }
        throw new FileNotFoundException("The file could not be found");
    }

    public static String translateCanonicalPath(String path, String securemount) throws FileNotFoundException {
        try {
            log.debug((Object)("Translating for canonical path " + path + " against secure mount " + securemount));
            File f = new File(path);
            String canonical = f.getCanonicalPath().replace('\\', '/');
            File f2 = new File(securemount);
            String canonical2 = f2.getCanonicalPath().replace('\\', '/');
            if (canonical.startsWith(canonical2)) {
                return canonical;
            }
            throw new FileNotFoundException(String.valueOf(path) + " could not be found");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(String.valueOf(path) + " could not be found");
        }
    }

    public boolean makeDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        path = VirtualFileSystem.translateVFSPath(path);
        File f = new File(path);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), path, "rw");
        log.debug((Object)("Creating directory " + f.getAbsolutePath()));
        return f.mkdir();
    }

    public VFSPermission getVFSPermission(String path) throws FileNotFoundException, IOException {
        VFSMount mount = VirtualFileSystem.getMount(VirtualFileSystem.translateNFSPath(path));
        if (mount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
            return (VFSPermission)mount.getPermissions().get(SshThread.getCurrentThreadUser());
        }
        return (VFSPermission)mount.getPermissions().get("default");
    }

    public FileAttributes getFileAttributes(byte[] handle) throws IOException, InvalidHandleException {
        String shandle = new String(handle);
        if (this.openFiles.containsKey(shandle)) {
            File f;
            Object obj = this.openFiles.get(shandle);
            if (obj instanceof OpenFile) {
                f = ((OpenFile)obj).getFile();
            } else if (obj instanceof OpenDirectory) {
                f = ((OpenDirectory)obj).getFile();
            } else {
                throw new IOException("Unexpected open file handle");
            }
            VFSPermission permissions = this.getVFSPermission(f.getAbsolutePath());
            if (permissions == null) {
                throw new IOException("No default permissions set");
            }
            FileAttributes attrs = new FileAttributes();
            attrs.setSize(new UnsignedInteger64(String.valueOf(f.length())));
            attrs.setTimes(new UnsignedInteger32(f.lastModified() / 1000L), new UnsignedInteger32(f.lastModified() / 1000L));
            boolean canExec = true;
            try {
                if (System.getSecurityManager() != null) {
                    System.getSecurityManager().checkExec(f.getCanonicalPath());
                }
            }
            catch (SecurityException securityException) {
                canExec = false;
            }
            attrs.setPermissions(String.valueOf(f.canRead() && permissions.canRead() ? "r" : "-") + (f.canWrite() && permissions.canWrite() ? "w" : "-") + (canExec && permissions.canExecute() ? "x" : "-"));
            attrs.setPermissions(new UnsignedInteger32(attrs.getPermissions().longValue() | (long)(f.isDirectory() ? 16384 : 32768)));
            return attrs;
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    public FileAttributes getFileAttributes(String path) throws IOException, FileNotFoundException {
        log.debug((Object)("Getting file attributes for " + path));
        path = VirtualFileSystem.translateVFSPath(path);
        File f = new File(path);
        path = f.getCanonicalPath();
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(path) + " doesn't exist");
        }
        VFSPermission permissions = this.getVFSPermission(path);
        if (permissions == null) {
            throw new IOException("No default permissions set");
        }
        FileAttributes attrs = new FileAttributes();
        attrs.setSize(new UnsignedInteger64(String.valueOf(f.length())));
        attrs.setTimes(new UnsignedInteger32(f.lastModified() / 1000L), new UnsignedInteger32(f.lastModified() / 1000L));
        boolean canExec = true;
        try {
            if (System.getSecurityManager() != null) {
                System.getSecurityManager().checkExec(f.getCanonicalPath());
            }
        }
        catch (SecurityException securityException) {
            canExec = false;
        }
        attrs.setPermissions(String.valueOf(f.canRead() && permissions.canRead() ? "r" : "-") + (f.canWrite() && permissions.canWrite() ? "w" : "-") + (canExec && permissions.canExecute() ? "x" : "-"));
        attrs.setPermissions(new UnsignedInteger32(attrs.getPermissions().longValue() | (long)(f.isDirectory() ? 16384 : 32768)));
        return attrs;
    }

    public byte[] openDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        String realPath = path;
        path = VirtualFileSystem.translateVFSPath(path);
        File f = new File(path);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), path, "r");
        if (f.exists()) {
            if (f.isDirectory()) {
                this.openFiles.put(f.toString(), new OpenDirectory(realPath, path, f));
                return f.toString().getBytes("US-ASCII");
            }
            throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " is not a directory");
        }
        throw new FileNotFoundException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " does not exist");
    }

    public SftpFile[] readDirectory(byte[] handle) throws InvalidHandleException, EOFException, IOException {
        String shandle = new String(handle);
        if (this.openFiles.containsKey(shandle)) {
            Object obj = this.openFiles.get(shandle);
            if (obj instanceof OpenDirectory) {
                int count;
                OpenDirectory dir = (OpenDirectory)obj;
                int pos = dir.getPosition();
                File[] children = dir.getChildren();
                if (children == null) {
                    throw new IOException("Permission denined.");
                }
                int n = count = children.length - pos < 100 ? children.length - pos : 100;
                if (count > 0) {
                    SftpFile[] files = new SftpFile[count];
                    int i = 0;
                    while (i < files.length) {
                        SftpFile sftpfile;
                        File f = children[pos + i];
                        String absolutePath = String.valueOf(dir.realPath) + "/" + f.getName();
                        files[i] = sftpfile = new SftpFile(f.getName(), this.getFileAttributes(absolutePath));
                        ++i;
                    }
                    dir.readpos = pos + files.length;
                    return files;
                }
                throw new EOFException("There are no more files");
            }
            throw new InvalidHandleException("Handle is not an open directory");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] openFile(String path, UnsignedInteger32 flags, FileAttributes attrs) throws PermissionDeniedException, FileNotFoundException, IOException {
        path = VirtualFileSystem.translateVFSPath(path);
        File f = new File(path);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), path, "r");
        if (!f.exists()) {
            if ((flags.intValue() & 8) != 8) throw new FileNotFoundException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " does not exist");
            if (!f.createNewFile()) {
                throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " could not be created");
            }
        } else if ((flags.intValue() & 8) == 8 && (flags.intValue() & 0x20) == 32) {
            throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " already exists");
        }
        String mode = "r" + ((flags.intValue() & 2) == 2 ? "ws" : "");
        RandomAccessFile raf = new RandomAccessFile(f, mode);
        if ((flags.intValue() & 8) == 8 && (flags.intValue() & 0x10) == 16) {
            raf.setLength(0L);
        }
        this.openFiles.put(raf.toString(), new OpenFile(f, raf, flags));
        return raf.toString().getBytes("US-ASCII");
    }

    public byte[] readFile(byte[] handle, UnsignedInteger64 offset, UnsignedInteger32 len) throws InvalidHandleException, EOFException, IOException {
        String shandle = new String(handle);
        if (this.openFiles.containsKey(shandle)) {
            Object obj = this.openFiles.get(shandle);
            if (obj instanceof OpenFile) {
                OpenFile file = (OpenFile)obj;
                if ((file.getFlags().intValue() & 1) == 1) {
                    int read;
                    byte[] buf = new byte[len.intValue()];
                    if (file.getRandomAccessFile().getFilePointer() != offset.longValue()) {
                        file.getRandomAccessFile().seek(offset.longValue());
                    }
                    if ((read = file.getRandomAccessFile().read(buf)) >= 0) {
                        if (read == buf.length) {
                            return buf;
                        }
                        byte[] tmp = new byte[read];
                        System.arraycopy(buf, 0, tmp, 0, read);
                        return tmp;
                    }
                    throw new EOFException("The file is EOF");
                }
                throw new InvalidHandleException("The file handle was not opened for reading");
            }
            throw new InvalidHandleException("Handle is not an open file");
        }
        throw new InvalidHandleException("The handle is invalid");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws InvalidHandleException, IOException {
        String shandle = new String(handle);
        if (!this.openFiles.containsKey(shandle)) throw new InvalidHandleException("The handle is invalid");
        Object obj = this.openFiles.get(shandle);
        if (!(obj instanceof OpenFile)) throw new InvalidHandleException("Handle is not an open file");
        OpenFile file = (OpenFile)obj;
        if ((file.getFlags().intValue() & 2) != 2) throw new InvalidHandleException("The file was not opened for writing");
        if ((file.getFlags().intValue() & 4) == 4) {
            file.getRandomAccessFile().seek(file.getRandomAccessFile().length());
        } else if (file.getRandomAccessFile().getFilePointer() != offset.longValue()) {
            file.getRandomAccessFile().seek(offset.longValue());
        }
        file.getRandomAccessFile().write(data, off, len);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeFile(byte[] handle) throws InvalidHandleException, IOException {
        String shandle = new String(handle);
        if (!this.openFiles.containsKey(shandle)) throw new InvalidHandleException("The handle is invalid");
        Object obj = this.openFiles.get(shandle);
        if (obj instanceof OpenDirectory) {
            this.openFiles.remove(shandle);
            return;
        } else {
            if (!(obj instanceof OpenFile)) throw new InvalidHandleException("Internal server error");
            ((OpenFile)obj).getRandomAccessFile().close();
            this.openFiles.remove(shandle);
        }
    }

    public void removeFile(String path) throws PermissionDeniedException, IOException, FileNotFoundException {
        block5: {
            File f = new File(path = VirtualFileSystem.translateVFSPath(path));
            if (f.exists()) {
                try {
                    if (f.isFile()) {
                        if (!f.delete()) {
                            throw new IOException("Failed to delete " + VirtualFileSystem.translateNFSPath(path));
                        }
                        break block5;
                    }
                    throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " is a directory, use remove directory command to remove");
                }
                catch (SecurityException securityException) {
                    throw new PermissionDeniedException("Permission denied");
                }
            }
            throw new FileNotFoundException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " does not exist");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameFile(String oldpath, String newpath) throws PermissionDeniedException, FileNotFoundException, IOException {
        oldpath = VirtualFileSystem.translateVFSPath(oldpath);
        newpath = VirtualFileSystem.translateVFSPath(newpath);
        File f = new File(oldpath);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), oldpath, "rw");
        this.verifyPermissions(SshThread.getCurrentThreadUser(), newpath, "rw");
        if (!f.exists()) throw new FileNotFoundException(String.valueOf(VirtualFileSystem.translateNFSPath(oldpath)) + " does not exist");
        File f2 = new File(newpath);
        if (f2.exists()) throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(newpath)) + " already exists");
        if (f.renameTo(f2)) return;
        throw new IOException("Failed to rename file " + VirtualFileSystem.translateNFSPath(oldpath));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeDirectory(String path) throws PermissionDeniedException, FileNotFoundException, IOException {
        path = VirtualFileSystem.translateVFSPath(path);
        File f = new File(path);
        this.verifyPermissions(SshThread.getCurrentThreadUser(), path, "rw");
        if (!f.isDirectory()) throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " is not a directory");
        if (!f.exists()) throw new FileNotFoundException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " does not exist");
        if (f.listFiles().length != 0) throw new IOException(String.valueOf(VirtualFileSystem.translateNFSPath(path)) + " is not an empty directory");
        if (f.delete()) return;
        throw new IOException("Failed to remove directory " + VirtualFileSystem.translateNFSPath(path));
    }

    public void setFileAttributes(String path, FileAttributes attrs) throws PermissionDeniedException, IOException, FileNotFoundException {
    }

    public void setFileAttributes(byte[] handle, FileAttributes attrs) throws PermissionDeniedException, IOException, InvalidHandleException {
    }

    public SftpFile readSymbolicLink(String path) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public void createSymbolicLink(String link, String target) throws UnsupportedFileOperationException, FileNotFoundException, IOException, PermissionDeniedException {
        throw new UnsupportedFileOperationException("Symbolic links are not supported by the Virtual File System");
    }

    public boolean fileExists(String path) throws IOException {
        File f = new File(VirtualFileSystem.translateVFSPath(path));
        return f.exists();
    }

    public String getDefaultPath(String username) throws FileNotFoundException {
        return VirtualFileSystem.getVFSHomeDirectory(username);
    }

    public String getCanonicalPath(String path) throws IOException, FileNotFoundException {
        File f = new File(VirtualFileSystem.translateVFSPath(path));
        return f.getCanonicalPath();
    }

    public String getRealPath(String path) throws FileNotFoundException {
        log.debug((Object)("Get real path for '" + path + "'"));
        path = VirtualFileSystem.translateVFSPath(path);
        log.debug((Object)("Translated VFS is '" + path + "'"));
        path = VirtualFileSystem.translateNFSPath(path);
        log.debug((Object)("Translated NFS is '" + path + "'"));
        return path;
    }

    public void verifyPermissions(String username, String path, String permissions) throws PermissionDeniedException, FileNotFoundException, IOException {
        String vfspath = VirtualFileSystem.translateNFSPath(path);
        if (permissionHandler == null) {
            VFSPermission perm;
            VFSMount mount = VirtualFileSystem.getMount(vfspath);
            if (mount.getPermissions().containsKey(SshThread.getCurrentThreadUser())) {
                perm = (VFSPermission)mount.getPermissions().get(SshThread.getCurrentThreadUser());
            } else if (mount.getPermissions().containsKey("default")) {
                perm = (VFSPermission)mount.getPermissions().get("default");
            } else {
                throw new PermissionDeniedException("No permissions set for mount");
            }
            if (!perm.verifyPermissions(permissions)) {
                throw new PermissionDeniedException("Permission denied for " + VirtualFileSystem.translateNFSPath(path));
            }
        } else {
            permissionHandler.verifyPermissions(username, path, permissions);
        }
    }

    class OpenDirectory {
        File f;
        File[] children;
        int readpos = 0;
        String path;
        String realPath;

        public OpenDirectory(String realPath, String path, File f) {
            this.path = path;
            this.realPath = realPath;
            this.f = f;
            this.children = f.listFiles();
        }

        public File getFile() {
            return this.f;
        }

        public File[] getChildren() {
            return this.children;
        }

        public int getPosition() {
            return this.readpos;
        }

        public void setPosition(int readpos) {
            this.readpos = readpos;
        }
    }

    class OpenFile {
        File f;
        RandomAccessFile raf;
        UnsignedInteger32 flags;

        public OpenFile(File f, RandomAccessFile raf, UnsignedInteger32 flags) {
            this.f = f;
            this.raf = raf;
            this.flags = flags;
        }

        public File getFile() {
            return this.f;
        }

        public RandomAccessFile getRandomAccessFile() {
            return this.raf;
        }

        public UnsignedInteger32 getFlags() {
            return this.flags;
        }
    }
}

