/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.KeyStore;
import com.sshtools.j2ssh.agent.SshAgentConnection;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentSocketListener {
    private static Log log = LogFactory.getLog(SshAgentSocketListener.class);
    StartStopState state = new StartStopState(2);
    KeyStore keystore;
    ServerSocket server;
    int port;
    Thread thread;
    String location;

    public SshAgentSocketListener(String location, KeyStore keystore) throws AgentNotAvailableException {
        log.info((Object)"New SshAgent instance created");
        this.location = location;
        if (location == null) {
            throw new AgentNotAvailableException();
        }
        this.location = location;
        int idx = location.indexOf(":");
        if (idx == -1) {
            throw new AgentNotAvailableException();
        }
        String host = location.substring(0, idx);
        this.port = Integer.parseInt(location.substring(idx + 1));
        this.keystore = keystore;
        try {
            this.server = new ServerSocket(this.port, 5, InetAddress.getByName(host));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StartStopState getState() {
        return this.state;
    }

    public void start() {
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    try {
                        Socket socket;
                        System.setProperty("sshtools.agent", SshAgentSocketListener.this.location);
                        SshAgentSocketListener.this.state.setValue(1);
                        while ((socket = SshAgentSocketListener.this.server.accept()) != null) {
                            new SshAgentConnection(SshAgentSocketListener.this.keystore, socket.getInputStream(), socket.getOutputStream());
                        }
                        SshAgentSocketListener.this.thread = null;
                    }
                    catch (IOException ex) {
                        log.info((Object)("The agent listener closed: " + ex.getMessage()));
                        SshAgentSocketListener.this.state.setValue(2);
                    }
                }
                finally {
                    SshAgentSocketListener.this.state.setValue(2);
                }
            }
        });
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {}
    }

    protected KeyStore getKeystore() {
        return this.keystore;
    }

    public static int configureNewLocation() {
        return 49152 + (int)Math.round(16383.0 * Math.random());
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].equals("-start")) {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        try {
                            SshAgentSocketListener agent = new SshAgentSocketListener(System.getProperty("sshtools.agent"), new KeyStore());
                            agent.start();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                thread.start();
            }
            if (args[0].equals("-configure")) {
                System.out.println("SET SSHTOOLS_AGENT=localhost:" + String.valueOf(SshAgentSocketListener.configureNewLocation()));
            }
        }
    }
}

