/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.util.ExtensionClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationLoader {
    private static Vector contexts = new Vector();
    private static SecureRandom rnd;
    private static ExtensionClassLoader ext;
    private static ClassLoader clsLoader;
    private static Log log;
    private static String homedir;
    private static boolean initialized;
    private static Object initializationLock;

    static {
        ext = null;
        clsLoader = null;
        log = LogFactory.getLog(ConfigurationLoader.class);
        initialized = false;
        initializationLock = new Object();
        homedir = ConfigurationLoader.checkAndGetProperty("sshtools.home", System.getProperty("java.home"));
        if (homedir != null && !homedir.endsWith(File.separator)) {
            homedir = String.valueOf(homedir) + File.separator;
        }
        rnd = new SecureRandom();
        rnd.nextInt();
    }

    public static SecureRandom getRND() {
        return rnd;
    }

    public static String getVersionString(String projectname, String versionFile) {
        Properties properties = new Properties();
        String version = projectname;
        try {
            properties.load(ConfigurationLoader.loadFile(versionFile));
            String project = projectname.toLowerCase();
            String major = properties.getProperty(String.valueOf(project) + ".version.major");
            String minor = properties.getProperty(String.valueOf(project) + ".version.minor");
            String build = properties.getProperty(String.valueOf(project) + ".version.build");
            String type = properties.getProperty(String.valueOf(project) + ".project.type");
            if (major != null && minor != null && build != null) {
                version = String.valueOf(version) + " " + major + "." + minor + "." + build;
            }
            if (type != null) {
                version = String.valueOf(version) + " " + type;
            }
        }
        catch (Exception exception) {}
        return version;
    }

    public static String checkAndGetProperty(String property, String defaultValue) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(property, "read"));
            }
            return System.getProperty(property, defaultValue);
        }
        catch (AccessControlException accessControlException) {
            return defaultValue;
        }
    }

    public static void initialize(boolean force) throws ConfigurationException {
        ConfigurationLoader.initialize(force, new DefaultConfigurationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(boolean force, ConfigurationContext context) throws ConfigurationException {
        try {
            String javaversion = System.getProperty("java.version");
            log.info((Object)("JAVA version is " + javaversion));
            if (javaversion.startsWith("1.3")) {
                boolean provider = false;
                int i = 0;
                while (i < Security.getProviders().length) {
                    log.info((Object)(String.valueOf(Security.getProviders()[i].getName()) + " security provider found"));
                    if (Security.getProviders()[i].getClass().getName().equals("org.bouncycastle.jce.provider.BouncyCastleProvider")) {
                        provider = true;
                    }
                    ++i;
                }
                if (!provider) {
                    log.info((Object)"Attempting to load the bouncycastle jce provider");
                    Class<?> cls = Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
                    Security.addProvider((Provider)cls.newInstance());
                }
            }
        }
        catch (Exception ex) {
            log.info((Object)"Failed to load the bouncycastle jce provider", (Throwable)ex);
            if (Security.getProviders().length <= 0) {
                throw new ConfigurationException("There are no security providers available; install jce-jdk13-119.jar available from http://www.bouncycastle.org");
            }
            log.info((Object)"An existing provider has been detected");
        }
        Object object = initializationLock;
        synchronized (object) {
            if (initialized && !force) {
                return;
            }
            context.initialize();
            contexts.add(context);
            if (ext == null) {
                ext = new ExtensionClassLoader(ConfigurationLoader.class.getClassLoader());
                try {
                    File dir = new File(String.valueOf(homedir) + "lib" + File.separator + "ext");
                    FilenameFilter filter = new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    };
                    File[] children = dir.listFiles(filter);
                    new Vector();
                    if (children != null) {
                        int i = 0;
                        while (i < children.length) {
                            log.info((Object)("Extension " + children[i].getAbsolutePath() + " being added to classpath"));
                            ext.add(children[i]);
                            ++i;
                        }
                    }
                }
                catch (AccessControlException accessControlException) {
                    log.info((Object)"Cannot access lib/ext directory, extension classes will not be loaded");
                }
            }
            initialized = true;
        }
    }

    public static boolean isConfigurationAvailable(Class cls) throws ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (contexts.size() > 0) {
            for (ConfigurationContext context : contexts) {
                if (!context.isConfigurationAvailable(cls)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static Object getConfiguration(Class cls) throws ConfigurationException {
        if (contexts.size() > 0) {
            for (ConfigurationContext context : contexts) {
                if (!context.isConfigurationAvailable(cls)) continue;
                return context.getConfiguration(cls);
            }
        }
        throw new ConfigurationException("No " + cls.getName() + " configuration is available in this context");
    }

    public static String getConfigurationDirectory() {
        return String.valueOf(homedir) + "conf/";
    }

    public static Class getExtensionClass(String name) throws ClassNotFoundException, ConfigurationException {
        if (!initialized) {
            ConfigurationLoader.initialize(false);
        }
        if (ext == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return ext.loadClass(name);
    }

    public static String getHomeDirectory() {
        return homedir;
    }

    public static void setContextClassLoader(ClassLoader clsLoader) {
        ConfigurationLoader.clsLoader = clsLoader;
    }

    public static ExtensionClassLoader getExtensionClassLoader() {
        return ext;
    }

    public static String getExtensionPath() {
        return String.valueOf(homedir) + "/lib/ext";
    }

    public static ClassLoader getContextClassLoader() {
        return clsLoader;
    }

    public static boolean isContextClassLoader() {
        return clsLoader != null;
    }

    public static void setHomeDirectory(String homedir) {
        ConfigurationLoader.homedir = homedir.replace('\\', '/');
        if (!ConfigurationLoader.homedir.endsWith("/")) {
            ConfigurationLoader.homedir = String.valueOf(ConfigurationLoader.homedir) + "/";
        }
    }

    public static InputStream loadFile(String filename) throws FileNotFoundException {
        try {
            FileInputStream in = new FileInputStream(String.valueOf(ConfigurationLoader.getConfigurationDirectory()) + filename);
            return in;
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                FileInputStream in = new FileInputStream(String.valueOf(homedir) + filename);
                return in;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                FileInputStream in = new FileInputStream(filename);
                return in;
            }
        }
    }

    public static OutputStream saveFile(String filename) throws FileNotFoundException {
        File f = new File(String.valueOf(ConfigurationLoader.getConfigurationDirectory()) + filename);
        if (f.exists()) {
            return new FileOutputStream(f);
        }
        f = new File(filename);
        if (f.exists()) {
            return new FileOutputStream(filename);
        }
        return new FileOutputStream(filename.indexOf(File.pathSeparator) >= 0 ? filename : String.valueOf(ConfigurationLoader.getConfigurationDirectory()) + filename);
    }

    static class DefaultConfigurationContext
    implements ConfigurationContext {
        DefaultConfigurationContext() {
        }

        public void initialize() throws ConfigurationException {
        }

        public boolean isConfigurationAvailable(Class cls) {
            return false;
        }

        public Object getConfiguration(Class cls) throws ConfigurationException {
            throw new ConfigurationException("Default configuration does not contain " + cls.getName());
        }
    }
}

