/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelData
extends SshMessage {
    public static final int SSH_MSG_CHANNEL_DATA = 94;
    private byte[] channelData;
    private long recipientChannel;

    public SshMsgChannelData(long recipientChannel, byte[] channelData) {
        super(94);
        this.recipientChannel = recipientChannel;
        this.channelData = channelData;
    }

    public SshMsgChannelData() {
        super(94);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public long getChannelDataLength() {
        return this.channelData.length;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_DATA";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(this.recipientChannel);
            if (this.channelData != null) {
                baw.writeBinaryString(this.channelData);
            } else {
                baw.writeInt(0);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.recipientChannel = bar.readInt();
            if (bar.available() > 0) {
                this.channelData = bar.readBinaryString();
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

