/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelExtendedData
extends SshMessage {
    public static final int SSH_MSG_CHANNEL_EXTENDED_DATA = 95;
    public static final int SSH_EXTENDED_DATA_STDERR = 1;
    private byte[] channelData;
    private int dataTypeCode;
    private long recipientChannel;

    public SshMsgChannelExtendedData(long recipientChannel, int dataTypeCode, byte[] channelData) {
        super(95);
        this.recipientChannel = recipientChannel;
        this.dataTypeCode = dataTypeCode;
        this.channelData = channelData;
    }

    public SshMsgChannelExtendedData() {
        super(95);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public int getDataTypeCode() {
        return this.dataTypeCode;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_EXTENDED_DATA";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(this.recipientChannel);
            baw.writeInt(this.dataTypeCode);
            if (this.channelData != null) {
                baw.writeBinaryString(this.channelData);
            } else {
                baw.writeString("");
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.recipientChannel = bar.readInt();
            this.dataTypeCode = (int)bar.readInt();
            if (bar.available() > 0) {
                this.channelData = bar.readBinaryString();
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

