/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOUtil {
    public static boolean closeStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean delTree(File file) {
        if (file.isFile()) {
            return file.delete();
        }
        File[] list = file.listFiles();
        int i = 0;
        while (i < list.length) {
            if (!IOUtil.delTree(list[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void recurseDeleteDirectory(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            IOUtil.recurseDeleteDirectory(files[i]);
            files[i].delete();
            ++i;
        }
        files = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        i = 0;
        while (i < files.length) {
            files[i].delete();
            ++i;
        }
        dir.delete();
    }

    public static void copyFile(File from, File to) throws IOException {
        if (from.isDirectory()) {
            if (!to.exists()) {
                to.mkdir();
            }
            File[] children = from.listFiles();
            int i = 0;
            while (i < children.length) {
                if (!children[i].getName().equals(".") && !children[i].getName().equals("..")) {
                    if (children[i].isDirectory()) {
                        File f = new File(to, children[i].getName());
                        IOUtil.copyFile(children[i], f);
                    } else {
                        IOUtil.copyFile(children[i], to);
                    }
                }
                ++i;
            }
        } else if (from.isFile() && (to.isDirectory() || to.isFile())) {
            int read;
            if (to.isDirectory()) {
                to = new File(to, from.getName());
            }
            FileInputStream in = new FileInputStream(from);
            FileOutputStream out = new FileOutputStream(to);
            byte[] buf = new byte[32678];
            while ((read = in.read(buf)) > -1) {
                out.write(buf, 0, read);
            }
            IOUtil.closeStream(in);
            IOUtil.closeStream(out);
        }
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        try {
            int read;
            byte[] buffer = new byte[65535];
            while ((read = in.read(buffer)) > -1) {
                if (read <= 0) continue;
                out.write(buffer, 0, read);
            }
        }
        finally {
            IOUtil.closeStream(in);
            IOUtil.closeStream(out);
        }
    }
}

