/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.agent.AgentSocketChannel;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SignalListener;
import com.sshtools.j2ssh.subsystem.SubsystemClient;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionChannelClient
extends IOChannel {
    private static Log log = LogFactory.getLog(SessionChannelClient.class);
    private Integer exitCode = null;
    private String sessionType = "Uninitialized";
    private SubsystemClient subsystem;
    private boolean localFlowControl = false;
    private SignalListener signalListener;
    private SshMessageStore errorMessages = new SshMessageStore();
    private ChannelInputStream stderr = new ChannelInputStream(this.errorMessages, new Integer(1));

    public SessionChannelClient() {
        this.setName("session");
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return "session";
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public boolean setEnvironmentVariable(String name, String value) throws IOException {
        log.debug((Object)("Requesting environment variable to be set [" + name + "=" + value + "]"));
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(name);
        baw.writeString(value);
        return this.connection.sendChannelRequest(this, "env", true, baw.toByteArray());
    }

    public boolean requestAgentForwarding() throws IOException {
        log.info((Object)"Requesting agent forwarding for the session");
        if (System.getProperty("sshtools.agent") == null) {
            throw new SshException("Agent not found! 'sshtools.agent' system property should identify the agent location");
        }
        boolean success = this.connection.sendChannelRequest(this, "auth-agent-req", true, null);
        if (success) {
            this.connection.addChannelFactory("auth-agent", new ChannelFactory(){

                public Channel createChannel(String channelType, byte[] requestData) throws InvalidChannelException {
                    try {
                        AgentSocketChannel channel = new AgentSocketChannel(false);
                        Socket socket = SshAgentClient.connectAgentSocket(System.getProperty("sshtools.agent"));
                        channel.bindSocket(socket);
                        return channel;
                    }
                    catch (Exception ex) {
                        throw new InvalidChannelException(ex.getMessage());
                    }
                }
            });
        }
        return success;
    }

    public boolean requestX11Forwarding(int display, String cookie) throws IOException {
        log.debug((Object)("Requesting X11 forwarding for display " + display + " using cookie " + cookie));
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeBoolean(false);
        baw.writeString("MIT-MAGIC-COOKIE-1");
        baw.writeString(cookie);
        baw.writeUINT32(new UnsignedInteger32(String.valueOf(display)));
        return this.connection.sendChannelRequest(this, "x11-req", true, baw.toByteArray());
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void changeTerminalDimensions(PseudoTerminal term) throws IOException {
        log.debug((Object)"Changing terminal dimensions");
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeInt(term.getColumns());
        baw.writeInt(term.getRows());
        baw.writeInt(term.getWidth());
        baw.writeInt(term.getHeight());
        this.connection.sendChannelRequest(this, "window-change", false, baw.toByteArray());
    }

    public boolean executeCommand(String command) throws IOException {
        log.info((Object)"Requesting command execution");
        log.info((Object)("Command is " + command));
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(command);
        if (this.connection.sendChannelRequest(this, "exec", true, baw.toByteArray())) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = command;
            }
            return true;
        }
        return false;
    }

    public boolean requestPseudoTerminal(String term, int cols, int rows, int width, int height, String terminalModes) throws IOException {
        log.info((Object)"Requesting pseudo terminal");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Terminal Type is " + term));
            log.debug((Object)("Columns=" + String.valueOf(cols)));
            log.debug((Object)("Rows=" + String.valueOf(rows)));
            log.debug((Object)("Width=" + String.valueOf(width)));
            log.debug((Object)("Height=" + String.valueOf(height)));
        }
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(term);
        baw.writeInt(cols);
        baw.writeInt(rows);
        baw.writeInt(width);
        baw.writeInt(height);
        baw.writeString(terminalModes);
        return this.connection.sendChannelRequest(this, "pty-req", true, baw.toByteArray());
    }

    public boolean requestPseudoTerminal(PseudoTerminal term) throws IOException {
        return this.requestPseudoTerminal(term.getTerm(), term.getColumns(), term.getRows(), term.getWidth(), term.getHeight(), term.getEncodedTerminalModes());
    }

    public boolean startShell() throws IOException {
        log.debug((Object)"Requesting users shell");
        if (this.connection.sendChannelRequest(this, "shell", true, null)) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = "shell";
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(String subsystem) throws IOException {
        log.info((Object)("Starting " + subsystem + " subsystem"));
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(subsystem);
        if (this.connection.sendChannelRequest(this, "subsystem", true, baw.toByteArray())) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = subsystem;
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(SubsystemClient subsystem) throws IOException {
        boolean result = this.startSubsystem(subsystem.getName());
        if (result) {
            this.subsystem = subsystem;
            subsystem.setSessionChannel(this);
            subsystem.start();
        }
        return result;
    }

    public boolean isLocalFlowControlEnabled() {
        return this.localFlowControl;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public SubsystemClient getSubsystem() {
        return this.subsystem;
    }

    protected void onChannelClose() throws IOException {
        super.onChannelClose();
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {}
        Integer exitCode = this.getExitCode();
        if (exitCode != null) {
            log.debug((Object)("Exit code " + exitCode.toString()));
        }
    }

    protected void onChannelOpen() throws IOException {
    }

    public InputStream getStderrInputStream() throws IOException {
        return this.stderr;
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
        this.errorMessages.addMessage(msg);
    }

    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        log.info((Object)("Channel Request received: " + requestType));
        if (requestType.equals("exit-status")) {
            this.exitCode = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            log.info((Object)("Exit code of " + this.exitCode.toString() + " received"));
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader bar = new ByteArrayReader(requestData);
            String signal = bar.readString();
            boolean coredump = bar.read() != 0;
            String message = bar.readString();
            bar.readString();
            log.debug((Object)("Exit signal " + signal + " received"));
            log.debug((Object)("Signal message: " + message));
            log.debug((Object)("Core dumped: " + String.valueOf(coredump)));
            if (this.signalListener != null) {
                this.signalListener.onExitSignal(signal, coredump, message);
            }
        } else if (requestType.equals("xon-xoff")) {
            if (requestData.length >= 1) {
                this.localFlowControl = requestData[0] != 0;
            }
        } else if (requestType.equals("signal")) {
            String signal = ByteArrayReader.readString(requestData, 0);
            log.debug((Object)("Signal " + signal + " received"));
            if (this.signalListener != null) {
                this.signalListener.onSignal(signal);
            }
        } else if (wantReply) {
            this.connection.sendChannelRequestFailure(this);
        }
    }
}

