/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFile {
    private static Log log = LogFactory.getLog(SshPrivateKeyFile.class);
    private SshPrivateKeyFormat format;
    private byte[] keyblob;

    protected SshPrivateKeyFile(byte[] keyblob, SshPrivateKeyFormat format) {
        this.keyblob = keyblob;
        this.format = format;
    }

    public byte[] getBytes() {
        return this.keyblob;
    }

    public byte[] getKeyBlob(String passphrase) throws InvalidSshKeyException {
        return this.format.decryptKeyblob(this.keyblob, passphrase);
    }

    public void changePassphrase(String oldPassphrase, String newPassphrase) throws InvalidSshKeyException {
        byte[] raw = this.format.decryptKeyblob(this.keyblob, oldPassphrase);
        this.keyblob = this.format.encryptKeyblob(raw, newPassphrase);
    }

    public static SshPrivateKeyFile parse(byte[] formattedKey) throws InvalidSshKeyException {
        if (formattedKey == null) {
            throw new InvalidSshKeyException("Key data is null");
        }
        log.info((Object)"Parsing private key file");
        SshPrivateKeyFormat format = SshPrivateKeyFormatFactory.newInstance(SshPrivateKeyFormatFactory.getDefaultFormatType());
        boolean valid = format.isFormatted(formattedKey);
        if (!valid) {
            log.info((Object)"Private key is not in the default format, attempting parse with other supported formats");
            Iterator it = SshPrivateKeyFormatFactory.getSupportedFormats().iterator();
            while (it.hasNext() && !valid) {
                String ft = (String)it.next();
                log.debug((Object)("Attempting " + ft));
                format = SshPrivateKeyFormatFactory.newInstance(ft);
                valid = format.isFormatted(formattedKey);
            }
        }
        if (valid) {
            return new SshPrivateKeyFile(formattedKey, format);
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public static SshPrivateKeyFile parse(File keyfile) throws InvalidSshKeyException, IOException {
        FileInputStream in = new FileInputStream(keyfile);
        byte[] data = null;
        try {
            data = new byte[in.available()];
            in.read(data);
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {}
        return SshPrivateKeyFile.parse(data);
    }

    public boolean isPassphraseProtected() {
        return this.format.isPassphraseProtected(this.keyblob);
    }

    public static SshPrivateKeyFile create(SshPrivateKey key, String passphrase, SshPrivateKeyFormat format) throws InvalidSshKeyException {
        byte[] keyblob = format.encryptKeyblob(key.getEncoded(), passphrase);
        return new SshPrivateKeyFile(keyblob, format);
    }

    public void setFormat(SshPrivateKeyFormat newFormat, String passphrase) throws InvalidSshKeyException {
        byte[] raw = this.format.decryptKeyblob(this.keyblob, passphrase);
        this.format = newFormat;
        this.keyblob = this.format.encryptKeyblob(raw, passphrase);
    }

    public SshPrivateKeyFormat getFormat() {
        return this.format;
    }

    public SshPrivateKey toPrivateKey(String passphrase) throws InvalidSshKeyException {
        try {
            byte[] raw = this.format.decryptKeyblob(this.keyblob, passphrase);
            SshKeyPair pair = SshKeyPairFactory.newInstance(this.getAlgorithm(raw));
            return pair.decodePrivateKey(raw);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InvalidSshKeyException("The public key algorithm for this private key is not supported");
        }
    }

    public String toString() {
        return new String(this.keyblob);
    }

    private String getAlgorithm(byte[] raw) {
        return ByteArrayReader.readString(raw, 0);
    }
}

