/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import edu.stanford.cs106.CS106Plugin;
import edu.stanford.cs106.submitter.AuthenticationCallback;
import edu.stanford.cs106.submitter.DepricatedException;
import edu.stanford.cs106.submitter.SubmissionInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AuthenticateAction
implements IRunnableWithProgress {
    private String host;
    private String username;
    private String password;
    private String errorMessage;
    private SshClient ssh;
    private boolean authenticated;
    private AuthenticationCallback cb;

    public AuthenticateAction(String host, String username, String password, AuthenticationCallback cb) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.cb = cb;
    }

    public String getErrorMessage() {
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        return this.cb.getErrorMessage();
    }

    public SshClient getSsh() {
        return this.ssh;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.ssh = new SshClient();
        monitor.beginTask("Authenticating", 4);
        try {
            this.checkIfPluginIsDepricated();
            this.ssh.connect(this.host, (HostKeyVerification)new IgnoreHostKeyVerification());
            monitor.worked(1);
            PasswordAuthenticationClient client = new PasswordAuthenticationClient();
            client.setUsername(this.username);
            client.setPassword(this.password);
            int result = this.ssh.authenticate(client);
            if (result != 4) {
                this.errorMessage = "Invalid SUNetID/password. Please verify that they're correct and try again.";
                return;
            }
            monitor.worked(1);
        }
        catch (IOException e1) {
            this.errorMessage = "Couldn't connect to the submission server (" + this.host + "). Please try again later. " + e1.getLocalizedMessage();
            return;
        }
        catch (DepricatedException depricatedException) {
            this.errorMessage = "This version of the Stanford Submitter is depricated. Please download an updated version of Stanford Eclipse.";
            return;
        }
        this.cb.initialize(this.username, this.ssh);
        this.cb.run(monitor);
        this.authenticated = this.cb.wasSuccessful();
    }

    private void checkIfPluginIsDepricated() throws DepricatedException {
        try {
            String codeName = CS106Plugin.getCodeName();
            for (String plugin : SubmissionInfo.getInstance().getDepricatedPlugins()) {
                if (!plugin.equals(codeName)) continue;
                throw new DepricatedException();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

