/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import com.sshtools.j2ssh.SshClient;
import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.AuthenticateAction;
import edu.stanford.cs106.submitter.StudentAuthenticationCallback;
import edu.stanford.cs106.submitter.SubmissionInfo;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationPage
extends WizardPage {
    Text sunetID;
    Text password;
    boolean authenticated = false;
    AuthenticateAction authAct;
    StudentAuthenticationCallback authCallback;
    private Button authenticate;

    public AuthenticationPage() {
        super("Authentication");
        this.setDescription("Enter your SUNetID/password in order to obtain your section leader/class.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 4;
        composite.setLayout((Layout)gl);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        new Label(composite, 0).setText("SUNetID:");
        this.sunetID = new Text(composite, 2048);
        this.sunetID.setLayoutData((Object)data);
        new Label(composite, 0).setText("Password:");
        this.password = new Text(composite, 0x400800);
        this.password.setLayoutData((Object)data);
        new Label(composite, 0);
        this.authenticate = new Button(composite, 8);
        this.authenticate.setText("Authenticate");
        this.authenticate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (AuthenticationPage.this.sunetID.getText().length() == 0 || AuthenticationPage.this.password.getText().length() == 0) {
                    AuthenticationPage.this.setErrorMessage("Can't authenticate without SUNetID/password");
                    return;
                }
                AuthenticationPage.this.authenticated = false;
                AuthenticationPage.this.getWizard().getContainer().updateButtons();
                try {
                    AuthenticationPage.this.authCallback = new StudentAuthenticationCallback();
                    String host = SubmissionInfo.getInstance().getSubmitHost();
                    AuthenticationPage.this.authAct = new AuthenticateAction(host, AuthenticationPage.this.sunetID.getText(), AuthenticationPage.this.password.getText(), AuthenticationPage.this.authCallback);
                    AuthenticationPage.this.getContainer().run(true, false, (IRunnableWithProgress)AuthenticationPage.this.authAct);
                    AuthenticationPage.this.authenticated = AuthenticationPage.this.authAct.isAuthenticated();
                    if (!AuthenticationPage.this.authenticated) {
                        AuthenticationPage.this.setErrorMessage(AuthenticationPage.this.authAct.getErrorMessage());
                        AuthenticationPage.this.setMessage(null, 0);
                        return;
                    }
                    AuthenticationPage.this.setMessage("Authenticated! You can sign in as a different user or proceed.", 1);
                    AuthenticationPage.this.setErrorMessage(null);
                    AuthenticationPage.this.authenticate.setText("Reauthenticate");
                    AuthenticationPage.this.authenticate.setSize(AuthenticationPage.this.authenticate.computeSize(-1, -1, true));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                AuthenticationPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        System.out.println("Is page complete? " + this.authenticated);
        return this.authenticated;
    }

    public void handleEvent(Event event) {
        this.getWizard().getContainer().updateButtons();
    }

    public SshClient getClient() {
        return this.authAct.getSsh();
    }

    public List<Assignment> getAssignments() {
        if (!this.authenticated) {
            return null;
        }
        return this.authCallback.getAssignmentInfo();
    }

    public void addClass(String course, String slName) {
        this.authCallback.addClass(course, slName);
    }

    public String getSectionLeader(String course) {
        return this.authCallback.getSlInfo().get(course);
    }

    public String getSUNetID() {
        return this.sunetID.getText();
    }
}

