/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.ISubmissionProducer;
import edu.stanford.cs106.submitter.ProjectSelectPage;
import edu.stanford.cs106.submitter.SubmitterWizard;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class EclipseProjectSelectPage
extends ProjectSelectPage
implements ISubmissionProducer {
    private Composite composite;
    private Text directory;
    private IProject selectedProject;
    private Table fileTable;
    private SubmitterWizard submitterWizard;
    public static final String[] selectedExtensions = new String[]{"cpp", "cc", "h", "java", "project", "classpath"};
    private static final int GRID_COLS = 6;

    public EclipseProjectSelectPage() {
        super("Select project");
        this.setMessage("Choose the project to submit.");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(6, true));
        new Label(this.composite, 0).setText("Project:");
        this.directory = new Text(this.composite, 2048);
        this.directory.setEditable(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.directory.setLayoutData((Object)data);
        Button button = new Button(this.composite, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void fillOutTable(IProject topProject, IContainer container) throws CoreException {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource.getAdapter(IContainer.class) != null) {
                        this.fillOutTable(topProject, (IContainer)resource.getAdapter(IContainer.class));
                    } else {
                        TableItem fileItem = new TableItem(EclipseProjectSelectPage.this.fileTable, 0);
                        fileItem.setText(resource.getProjectRelativePath().toString());
                        String[] stringArray = selectedExtensions;
                        int n3 = selectedExtensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String extension = stringArray[n4];
                            if (extension.equals(resource.getProjectRelativePath().getFileExtension())) {
                                fileItem.setChecked(true);
                                break;
                            }
                            ++n4;
                        }
                    }
                    EclipseProjectSelectPage.this.getWizard().getContainer().updateButtons();
                    ++n2;
                }
            }

            public void widgetSelected(SelectionEvent event) {
                boolean validSelection;
                do {
                    IResource projectResource;
                    ContainerSelectionDialog dlg = new ContainerSelectionDialog(EclipseProjectSelectPage.this.composite.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Select project");
                    dlg.setMessage("Select the project directory");
                    if (dlg.open() != 0) {
                        return;
                    }
                    Object[] results = dlg.getResult();
                    validSelection = true;
                    String reason = null;
                    if (results == null) {
                        reason = "No project selected";
                    }
                    if (results.length == 0) {
                        reason = "No project selected";
                    }
                    if (results.length > 1) {
                        reason = "More than one project selected";
                    }
                    if (!(results[0] instanceof IPath)) {
                        reason = "Could not resolve selection";
                    }
                    if ((projectResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)results[0])).getAdapter(IProject.class) == null) {
                        reason = "Selection couldn't be converted to a project";
                    }
                    if (reason != null) {
                        validSelection = false;
                        new ErrorDialog(EclipseProjectSelectPage.this.getShell(), "Please choose again.", reason, (IStatus)new Status(4, "edu.stanford.cs106", 0, "Please choose exactly one project to submit.", null), 4).open();
                    } else {
                        validSelection = true;
                        EclipseProjectSelectPage.this.selectedProject = (IProject)projectResource.getAdapter(IProject.class);
                    }
                    if (!validSelection) continue;
                    try {
                        try {
                            EclipseProjectSelectPage.this.getContainer().run(false, false, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        EclipseProjectSelectPage.this.selectedProject.refreshLocal(2, monitor);
                                    }
                                    catch (CoreException ce) {
                                        ce.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        EclipseProjectSelectPage.this.directory.setText(EclipseProjectSelectPage.this.selectedProject.getName());
                        EclipseProjectSelectPage.this.fileTable.removeAll();
                        this.fillOutTable(EclipseProjectSelectPage.this.selectedProject, (IContainer)EclipseProjectSelectPage.this.selectedProject);
                    }
                    catch (CoreException coreException) {
                        EclipseProjectSelectPage.this.fileTable.removeAll();
                        validSelection = false;
                    }
                } while (!validSelection);
            }
        });
        this.fileTable = new Table(this.composite, 2592);
        this.fileTable.setVisible(false);
        GridData fileTableData = new GridData(4, 4, true, true);
        fileTableData.horizontalSpan = 6;
        this.fileTable.setLayoutData((Object)fileTableData);
        this.fileTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EclipseProjectSelectPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)this.composite);
    }

    public File[] getSelectedFiles() {
        ArrayList<File> ret = new ArrayList<File>();
        TableItem[] tableItemArray = this.fileTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            ret.add(this.selectedProject.getLocation().append((IPath)new Path(item.getText())).toFile());
            ++n2;
        }
        return ret.toArray(new File[0]);
    }

    public String getRoot() {
        return this.selectedProject.getLocation().toString();
    }

    public boolean isPageComplete() {
        return this.selectedProject != null;
    }
}

