/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.ui;

import edu.stanford.cs106.ui.SimpleMainMethodSearchEngine;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RunAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbenchWindow wb = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wb != null && (page = wb.getActivePage()) != null) {
            ISelection selection = page.getSelection();
            this.selectionChanged(null, selection);
        }
        this.run(null);
    }

    public synchronized void searchAndLaunch(String mode) throws InvocationTargetException, InterruptedException {
        SimpleMainMethodSearchEngine engine = new SimpleMainMethodSearchEngine();
        IType[] allTypes = engine.searchMainMethods((IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        ArrayList<IType> validRunnables = new ArrayList<IType>();
        IType[] iTypeArray = allTypes;
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType i = iTypeArray[n2];
            System.out.println(i.getFullyQualifiedName());
            validRunnables.add(i);
            ++n2;
        }
        IType[] types = new IType[validRunnables.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = (IType)validRunnables.get(i);
            ++i;
        }
        System.out.println("Valid types: " + types.length);
        IType type = null;
        if (types.length == 0) {
            String message = "Workspace does not contain a main type (do you have a public void run() method?)";
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"", (String)message);
        } else {
            type = types.length > 1 ? this.chooseType(types, mode) : types[0];
        }
        if (type != null) {
            this.launch(type, mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(type.getFullyQualifiedName()) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            wc = configType.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
        try {
            config = wc.doSave();
        }
        catch (CoreException exception) {
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected void reportCreatingConfiguration(final CoreException exception) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"", (String)"", (IStatus)exception.getStatus());
            }
        });
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Java ApplicationAction Launch Configuration");
        if (mode.equals("debug")) {
            dialog.setTitle("Choose a launch configuration to debug");
        } else {
            dialog.setTitle("Choose a launch configuration to run");
        }
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract IType chooseType(IType[] var1, String var2);

    protected abstract void launch(IType var1, String var2);

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

