/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.JGitInternalException;
import org.eclipse.jgit.api.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.ObjectWriter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private WorkingTreeIterator workingTreeIterator;

    public AddCommand(Repository repo) {
        super(repo);
    }

    public AddCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public AddCommand setWorkingTreeIterator(WorkingTreeIterator f) {
        this.workingTreeIterator = f;
        return this;
    }

    @Override
    public DirCache call() throws NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        boolean addAll = false;
        if (this.filepatterns.contains(".")) {
            addAll = true;
        }
        try {
            try {
                dc = this.repo.lockDirCache();
                ObjectWriter ow = new ObjectWriter(this.repo);
                DirCacheBuilder builder = dc.builder();
                TreeWalk tw = new TreeWalk(this.repo);
                tw.reset();
                tw.addTree(new DirCacheBuildIterator(builder));
                if (this.workingTreeIterator == null) {
                    this.workingTreeIterator = new FileTreeIterator(this.repo);
                }
                tw.addTree(this.workingTreeIterator);
                tw.setRecursive(true);
                if (!addAll) {
                    tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
                }
                String lastAddedFile = null;
                while (tw.next()) {
                    String path = tw.getPathString();
                    File file = new File(this.repo.getWorkTree(), path);
                    WorkingTreeIterator f = tw.getTree(1, WorkingTreeIterator.class);
                    if (tw.getTree(0, DirCacheIterator.class) == null && f != null && f.isEntryIgnored() || path.equals(lastAddedFile)) continue;
                    if (f != null) {
                        DirCacheEntry entry = new DirCacheEntry(path);
                        entry.setLength((int)f.getEntryLength());
                        entry.setLastModified(f.getEntryLastModified());
                        entry.setFileMode(f.getEntryFileMode());
                        entry.setObjectId(ow.writeBlob(file));
                        builder.add(entry);
                        lastAddedFile = path;
                        continue;
                    }
                    DirCacheIterator c = tw.getTree(0, DirCacheIterator.class);
                    builder.add(c.getDirCacheEntry());
                }
                builder.commit();
                this.setCallable(false);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfAddCommand, e);
            }
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }
}

