/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.api.CheckoutConflictException;
import org.eclipse.jgit.api.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.InvalidMergeHeadsException;
import org.eclipse.jgit.api.JGitInternalException;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.NoHeadException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeCommand
extends GitCommand<MergeResult> {
    private MergeStrategy mergeStrategy = MergeStrategy.SIMPLE_TWO_WAY_IN_CORE;
    private List<Ref> commits = new LinkedList<Ref>();

    protected MergeCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MergeResult call() throws NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException {
        this.checkCallable();
        if (this.commits.size() != 1) {
            String string;
            if (this.commits.isEmpty()) {
                string = JGitText.get().noMergeHeadSpecified;
                throw new InvalidMergeHeadsException(string);
            }
            string = MessageFormat.format(JGitText.get().mergeStrategyDoesNotSupportHeads, this.mergeStrategy.getName(), this.commits.size());
            throw new InvalidMergeHeadsException(string);
        }
        try {
            Ref head = this.repo.getRef("HEAD");
            if (head == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            StringBuilder refLogMessage = new StringBuilder("merge ");
            RevWalk revWalk = new RevWalk(this.repo);
            try {
                RevCommit srcCommit;
                RevCommit headCommit = revWalk.lookupCommit(head.getObjectId());
                Ref ref = this.commits.get(0);
                refLogMessage.append(ref.getName());
                ObjectId objectId = ref.getPeeledObjectId();
                if (objectId == null) {
                    objectId = ref.getObjectId();
                }
                if (revWalk.isMergedInto(srcCommit = revWalk.lookupCommit(objectId), headCommit)) {
                    this.setCallable(false);
                    MergeResult mergeResult = new MergeResult(headCommit, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, this.mergeStrategy);
                    return mergeResult;
                }
                if (revWalk.isMergedInto(headCommit, srcCommit)) {
                    refLogMessage.append(": " + (Object)((Object)MergeResult.MergeStatus.FAST_FORWARD));
                    this.checkoutNewHead(revWalk, headCommit, srcCommit);
                    this.updateHead(refLogMessage, srcCommit, head.getObjectId());
                    this.setCallable(false);
                    MergeResult mergeResult = new MergeResult(srcCommit, MergeResult.MergeStatus.FAST_FORWARD, this.mergeStrategy);
                    return mergeResult;
                }
                MergeResult mergeResult = new MergeResult(headCommit, MergeResult.MergeStatus.NOT_SUPPORTED, this.mergeStrategy, JGitText.get().onlyAlreadyUpToDateAndFastForwardMergesAreAvailable);
                return mergeResult;
            }
            finally {
                revWalk.release();
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfMergeCommand, e));
        }
    }

    private void checkoutNewHead(RevWalk revWalk, RevCommit headCommit, RevCommit newHeadCommit) throws IOException, CheckoutConflictException {
        GitIndex index = this.repo.getIndex();
        File workDir = this.repo.getWorkTree();
        if (workDir != null) {
            WorkDirCheckout workDirCheckout = new WorkDirCheckout(this.repo, workDir, headCommit.asCommit(revWalk).getTree(), index, newHeadCommit.asCommit(revWalk).getTree());
            workDirCheckout.setFailOnConflict(true);
            try {
                workDirCheckout.checkout();
            }
            catch (org.eclipse.jgit.errors.CheckoutConflictException e) {
                throw new CheckoutConflictException(JGitText.get().couldNotCheckOutBecauseOfConflicts, workDirCheckout.getConflicts(), e);
            }
            index.write();
        }
    }

    private void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID) throws IOException, ConcurrentRefUpdateException {
        RefUpdate refUpdate = this.repo.updateRef("HEAD");
        refUpdate.setNewObjectId(newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId(oldHeadID);
        RefUpdate.Result rc = refUpdate.update();
        switch (rc) {
            case NEW: 
            case FAST_FORWARD: {
                return;
            }
            case LOCK_FAILURE: 
            case REJECTED: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, refUpdate.getRef(), rc);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{"HEAD", newHeadId.toString(), rc}));
    }

    public MergeCommand setStrategy(MergeStrategy mergeStrategy) {
        this.checkCallable();
        this.mergeStrategy = mergeStrategy;
        return this;
    }

    public MergeCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public MergeCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public MergeCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }
}

