/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.diff.DiffConfig;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.SimilarityIndex;
import org.eclipse.jgit.diff.SimilarityRenameDetector;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameDetector {
    private static final int EXACT_RENAME_SCORE = 100;
    private static final Comparator<DiffEntry> DIFF_COMPARATOR = new Comparator<DiffEntry>(){

        @Override
        public int compare(DiffEntry a, DiffEntry b) {
            int cmp = this.nameOf(a).compareTo(this.nameOf(b));
            if (cmp == 0) {
                cmp = this.sortOf(a.getChangeType()) - this.sortOf(b.getChangeType());
            }
            return cmp;
        }

        private String nameOf(DiffEntry ent) {
            if (ent.changeType == DiffEntry.ChangeType.DELETE) {
                return ent.oldName;
            }
            return ent.newName;
        }

        private int sortOf(DiffEntry.ChangeType changeType) {
            switch (changeType) {
                case DELETE: {
                    return 1;
                }
                case ADD: {
                    return 2;
                }
            }
            return 10;
        }
    };
    private List<DiffEntry> entries = new ArrayList<DiffEntry>();
    private List<DiffEntry> deleted = new ArrayList<DiffEntry>();
    private List<DiffEntry> added = new ArrayList<DiffEntry>();
    private boolean done;
    private final Repository repo;
    private int renameScore = 60;
    private int breakScore = -1;
    private int renameLimit;
    private boolean overRenameLimit;

    public RenameDetector(Repository repo) {
        this.repo = repo;
        DiffConfig cfg = repo.getConfig().get(DiffConfig.KEY);
        this.renameLimit = cfg.getRenameLimit();
    }

    public int getRenameScore() {
        return this.renameScore;
    }

    public void setRenameScore(int score) {
        if (score < 0 || score > 100) {
            throw new IllegalArgumentException(JGitText.get().similarityScoreMustBeWithinBounds);
        }
        this.renameScore = score;
    }

    public int getBreakScore() {
        return this.breakScore;
    }

    public void setBreakScore(int breakScore) {
        this.breakScore = breakScore;
    }

    public int getRenameLimit() {
        return this.renameLimit;
    }

    public void setRenameLimit(int limit) {
        this.renameLimit = limit;
    }

    public boolean isOverRenameLimit() {
        if (this.done) {
            return this.overRenameLimit;
        }
        int cnt = Math.max(this.added.size(), this.deleted.size());
        return this.getRenameLimit() != 0 && this.getRenameLimit() < cnt;
    }

    public void addAll(Collection<DiffEntry> entriesToAdd) {
        if (this.done) {
            throw new IllegalStateException(JGitText.get().renamesAlreadyFound);
        }
        for (DiffEntry entry : entriesToAdd) {
            switch (entry.getChangeType()) {
                case ADD: {
                    this.added.add(entry);
                    break;
                }
                case DELETE: {
                    this.deleted.add(entry);
                    break;
                }
                case MODIFY: {
                    if (RenameDetector.sameType(entry.getOldMode(), entry.getNewMode())) {
                        this.entries.add(entry);
                        break;
                    }
                    List<DiffEntry> tmp = DiffEntry.breakModify(entry);
                    this.deleted.add(tmp.get(0));
                    this.added.add(tmp.get(1));
                    break;
                }
                default: {
                    entriesToAdd.add(entry);
                }
            }
        }
    }

    public void add(DiffEntry entry) {
        this.addAll(Collections.singletonList(entry));
    }

    public List<DiffEntry> compute() throws IOException {
        return this.compute(NullProgressMonitor.INSTANCE);
    }

    public List<DiffEntry> compute(ProgressMonitor pm) throws IOException {
        if (!this.done) {
            this.done = true;
            if (pm == null) {
                pm = NullProgressMonitor.INSTANCE;
            }
            ObjectReader reader = this.repo.newObjectReader();
            try {
                this.breakModifies(reader, pm);
                this.findExactRenames(pm);
                this.findContentRenames(reader, pm);
                this.rejoinModifies(pm);
            }
            finally {
                reader.release();
            }
            this.entries.addAll(this.added);
            this.added = null;
            this.entries.addAll(this.deleted);
            this.deleted = null;
            Collections.sort(this.entries, DIFF_COMPARATOR);
        }
        return Collections.unmodifiableList(this.entries);
    }

    private void breakModifies(ObjectReader reader, ProgressMonitor pm) throws IOException {
        if (this.breakScore <= 0) {
            return;
        }
        ArrayList<DiffEntry> newEntries = new ArrayList<DiffEntry>(this.entries.size());
        pm.beginTask(JGitText.get().renamesBreakingModifies, this.entries.size());
        int i = 0;
        while (i < this.entries.size()) {
            DiffEntry e = this.entries.get(i);
            if (e.getChangeType() == DiffEntry.ChangeType.MODIFY) {
                int score = this.calculateModifyScore(reader, e);
                if (score < this.breakScore) {
                    List<DiffEntry> tmp = DiffEntry.breakModify(e);
                    DiffEntry del = tmp.get(0);
                    del.score = score;
                    this.deleted.add(del);
                    this.added.add(tmp.get(1));
                } else {
                    newEntries.add(e);
                }
            } else {
                newEntries.add(e);
            }
            pm.update(1);
            ++i;
        }
        this.entries = newEntries;
    }

    private void rejoinModifies(ProgressMonitor pm) {
        HashMap<String, DiffEntry> nameMap = new HashMap<String, DiffEntry>();
        ArrayList<DiffEntry> newAdded = new ArrayList<DiffEntry>(this.added.size());
        pm.beginTask(JGitText.get().renamesRejoiningModifies, this.added.size() + this.deleted.size());
        for (DiffEntry src : this.deleted) {
            nameMap.put(src.oldName, src);
            pm.update(1);
        }
        for (DiffEntry dst : this.added) {
            DiffEntry src = (DiffEntry)nameMap.remove(dst.newName);
            if (src != null) {
                if (RenameDetector.sameType(src.oldMode, dst.newMode)) {
                    this.entries.add(DiffEntry.pair(DiffEntry.ChangeType.MODIFY, src, dst, src.score));
                } else {
                    nameMap.put(src.oldName, src);
                    newAdded.add(dst);
                }
            } else {
                newAdded.add(dst);
            }
            pm.update(1);
        }
        this.added = newAdded;
        this.deleted = new ArrayList(nameMap.values());
    }

    private int calculateModifyScore(ObjectReader reader, DiffEntry d) throws IOException {
        SimilarityIndex src = new SimilarityIndex();
        src.hash(reader.open(d.oldId.toObjectId(), 3));
        src.sort();
        SimilarityIndex dst = new SimilarityIndex();
        dst.hash(reader.open(d.newId.toObjectId(), 3));
        dst.sort();
        return src.score(dst, 100);
    }

    private void findContentRenames(ObjectReader reader, ProgressMonitor pm) throws IOException {
        int cnt = Math.max(this.added.size(), this.deleted.size());
        if (cnt == 0) {
            return;
        }
        if (this.getRenameLimit() == 0 || cnt <= this.getRenameLimit()) {
            SimilarityRenameDetector d = new SimilarityRenameDetector(reader, this.deleted, this.added);
            d.setRenameScore(this.getRenameScore());
            d.compute(pm);
            this.deleted = d.getLeftOverSources();
            this.added = d.getLeftOverDestinations();
            this.entries.addAll(d.getMatches());
        } else {
            this.overRenameLimit = true;
        }
    }

    private void findExactRenames(ProgressMonitor pm) {
        DiffEntry best;
        if (this.added.isEmpty() || this.deleted.isEmpty()) {
            return;
        }
        pm.beginTask(JGitText.get().renamesFindingExact, this.added.size() + this.added.size() + this.deleted.size() + this.added.size() * this.deleted.size());
        HashMap<AbbreviatedObjectId, Object> deletedMap = this.populateMap(this.deleted, pm);
        HashMap<AbbreviatedObjectId, Object> addedMap = this.populateMap(this.added, pm);
        ArrayList<DiffEntry> uniqueAdds = new ArrayList<DiffEntry>(this.added.size());
        ArrayList<List> nonUniqueAdds = new ArrayList<List>();
        for (Object o : addedMap.values()) {
            if (o instanceof DiffEntry) {
                uniqueAdds.add((DiffEntry)o);
                continue;
            }
            nonUniqueAdds.add((List)o);
        }
        ArrayList<DiffEntry> left = new ArrayList<DiffEntry>(this.added.size());
        for (DiffEntry a : uniqueAdds) {
            Object del = deletedMap.get(a.newId);
            if (del instanceof DiffEntry) {
                DiffEntry e = (DiffEntry)del;
                if (RenameDetector.sameType(e.oldMode, a.newMode)) {
                    e.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(e, a));
                } else {
                    left.add(a);
                }
            } else if (del != null) {
                List list = (List)del;
                best = RenameDetector.bestPathMatch(a, list);
                if (best != null) {
                    best.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(best, a));
                } else {
                    left.add(a);
                }
            } else {
                left.add(a);
            }
            pm.update(1);
        }
        for (List adds : nonUniqueAdds) {
            Object o = deletedMap.get(((DiffEntry)adds.get((int)0)).newId);
            if (o instanceof DiffEntry) {
                DiffEntry d = (DiffEntry)o;
                best = RenameDetector.bestPathMatch(d, adds);
                if (best != null) {
                    d.changeType = DiffEntry.ChangeType.RENAME;
                    this.entries.add(RenameDetector.exactRename(d, best));
                    for (DiffEntry a : adds) {
                        if (a == best) continue;
                        if (RenameDetector.sameType(d.oldMode, a.newMode)) {
                            this.entries.add(RenameDetector.exactCopy(d, a));
                            continue;
                        }
                        left.add(a);
                    }
                    continue;
                }
                left.addAll(adds);
                continue;
            }
            if (o != null) {
                int delIdx;
                List dels = (List)o;
                long[] matrix = new long[dels.size() * adds.size()];
                int mNext = 0;
                int addIdx = 0;
                while (addIdx < adds.size()) {
                    String addedName = ((DiffEntry)adds.get((int)addIdx)).newName;
                    delIdx = 0;
                    while (delIdx < dels.size()) {
                        String deletedName = ((DiffEntry)dels.get((int)delIdx)).oldName;
                        int score = SimilarityRenameDetector.nameScore(addedName, deletedName);
                        matrix[mNext] = SimilarityRenameDetector.encode(score, addIdx, delIdx);
                        ++mNext;
                        ++delIdx;
                    }
                    ++addIdx;
                }
                Arrays.sort(matrix);
                --mNext;
                while (mNext >= 0) {
                    long ent = matrix[mNext];
                    delIdx = SimilarityRenameDetector.srcFile(ent);
                    int addIdx2 = SimilarityRenameDetector.dstFile(ent);
                    DiffEntry d = (DiffEntry)dels.get(delIdx);
                    DiffEntry a = (DiffEntry)adds.get(addIdx2);
                    if (a == null) {
                        pm.update(1);
                    } else {
                        DiffEntry.ChangeType type;
                        if (d.changeType == DiffEntry.ChangeType.DELETE) {
                            d.changeType = DiffEntry.ChangeType.RENAME;
                            type = DiffEntry.ChangeType.RENAME;
                        } else {
                            type = DiffEntry.ChangeType.COPY;
                        }
                        this.entries.add(DiffEntry.pair(type, d, a, 100));
                        adds.set(addIdx2, null);
                        pm.update(1);
                    }
                    --mNext;
                }
                continue;
            }
            left.addAll(adds);
        }
        this.added = left;
        this.deleted = new ArrayList<DiffEntry>(deletedMap.size());
        for (Object o : deletedMap.values()) {
            if (o instanceof DiffEntry) {
                DiffEntry e = (DiffEntry)o;
                if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
                this.deleted.add(e);
                continue;
            }
            List list = (List)o;
            for (DiffEntry e : list) {
                if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
                this.deleted.add(e);
            }
        }
        pm.endTask();
    }

    private static DiffEntry bestPathMatch(DiffEntry src, List<DiffEntry> list) {
        DiffEntry best = null;
        int score = -1;
        for (DiffEntry d : list) {
            int tmp;
            if (!RenameDetector.sameType(RenameDetector.mode(d), RenameDetector.mode(src)) || (tmp = SimilarityRenameDetector.nameScore(RenameDetector.path(d), RenameDetector.path(src))) <= score) continue;
            best = d;
            score = tmp;
        }
        return best;
    }

    private HashMap<AbbreviatedObjectId, Object> populateMap(List<DiffEntry> diffEntries, ProgressMonitor pm) {
        HashMap<AbbreviatedObjectId, Object> map = new HashMap<AbbreviatedObjectId, Object>();
        for (DiffEntry de : diffEntries) {
            Object old = map.put(RenameDetector.id(de), de);
            if (old instanceof DiffEntry) {
                ArrayList<DiffEntry> list = new ArrayList<DiffEntry>(2);
                list.add((DiffEntry)old);
                list.add(de);
                map.put(RenameDetector.id(de), list);
            } else if (old != null) {
                ((List)old).add(de);
                map.put(RenameDetector.id(de), old);
            }
            pm.update(1);
        }
        return map;
    }

    private static String path(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldName : de.newName;
    }

    private static FileMode mode(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldMode : de.newMode;
    }

    private static AbbreviatedObjectId id(DiffEntry de) {
        return de.changeType == DiffEntry.ChangeType.DELETE ? de.oldId : de.newId;
    }

    static boolean sameType(FileMode a, FileMode b) {
        int bType;
        int aType = a.getBits() & 0xF000;
        return aType == (bType = b.getBits() & 0xF000);
    }

    private static DiffEntry exactRename(DiffEntry src, DiffEntry dst) {
        return DiffEntry.pair(DiffEntry.ChangeType.RENAME, src, dst, 100);
    }

    private static DiffEntry exactCopy(DiffEntry src, DiffEntry dst) {
        return DiffEntry.pair(DiffEntry.ChangeType.COPY, src, dst, 100);
    }
}

