/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.Treeish;

public class Commit
implements Treeish {
    private static final ObjectId[] EMPTY_OBJECTID_LIST = new ObjectId[0];
    private final Repository objdb;
    private ObjectId commitId;
    private ObjectId treeId;
    private ObjectId[] parentIds;
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private Tree treeObj;
    private byte[] raw;
    private Charset encoding;

    public Commit(Repository db) {
        this.objdb = db;
        this.parentIds = EMPTY_OBJECTID_LIST;
    }

    public Commit(Repository db, ObjectId[] parentIds) {
        this.objdb = db;
        this.parentIds = parentIds;
    }

    public Commit(Repository db, ObjectId id, byte[] raw) {
        int i;
        ObjectId[] old;
        this.objdb = db;
        this.commitId = id;
        this.treeId = ObjectId.fromString(raw, 5);
        this.parentIds = new ObjectId[1];
        int np = 0;
        int rawPtr = 46;
        while (raw[rawPtr] == 112) {
            if (np == 0) {
                this.parentIds[np++] = ObjectId.fromString(raw, rawPtr + 7);
            } else if (np == 1) {
                this.parentIds = new ObjectId[]{this.parentIds[0], ObjectId.fromString(raw, rawPtr + 7)};
                ++np;
            } else {
                if (this.parentIds.length <= np) {
                    old = this.parentIds;
                    this.parentIds = new ObjectId[this.parentIds.length + 32];
                    i = 0;
                    while (i < np) {
                        this.parentIds[i] = old[i];
                        ++i;
                    }
                }
                this.parentIds[np++] = ObjectId.fromString(raw, rawPtr + 7);
            }
            rawPtr += 48;
        }
        if (np != this.parentIds.length) {
            old = this.parentIds;
            this.parentIds = new ObjectId[np];
            i = 0;
            while (i < np) {
                this.parentIds[i] = old[i];
                ++i;
            }
        } else if (np == 0) {
            this.parentIds = EMPTY_OBJECTID_LIST;
        }
        this.raw = raw;
    }

    public Repository getRepository() {
        return this.objdb;
    }

    public ObjectId getCommitId() {
        return this.commitId;
    }

    public void setCommitId(ObjectId id) {
        this.commitId = id;
    }

    public ObjectId getTreeId() {
        return this.treeId;
    }

    public void setTreeId(ObjectId id) {
        if (this.treeId == null || !this.treeId.equals(id)) {
            this.treeObj = null;
        }
        this.treeId = id;
    }

    public Tree getTree() throws IOException {
        if (this.treeObj == null) {
            this.treeObj = this.objdb.mapTree(this.getTreeId());
            if (this.treeObj == null) {
                throw new MissingObjectException(this.getTreeId(), "tree");
            }
        }
        return this.treeObj;
    }

    public void setTree(Tree t) {
        this.treeId = t.getTreeId();
        this.treeObj = t;
    }

    public PersonIdent getAuthor() {
        this.decode();
        return this.author;
    }

    public void setAuthor(PersonIdent a) {
        this.author = a;
    }

    public PersonIdent getCommitter() {
        this.decode();
        return this.committer;
    }

    public void setCommitter(PersonIdent c) {
        this.committer = c;
    }

    public ObjectId[] getParentIds() {
        return this.parentIds;
    }

    public String getMessage() {
        this.decode();
        return this.message;
    }

    public void setParentIds(ObjectId[] parentIds) {
        this.parentIds = new ObjectId[parentIds.length];
        int i = 0;
        while (i < parentIds.length) {
            this.parentIds[i] = parentIds[i];
            ++i;
        }
    }

    private void decode() {
        if (this.raw != null) {
            try {
                try {
                    int msgstart;
                    DataInputStream br = new DataInputStream(new ByteArrayInputStream(this.raw));
                    String n = br.readLine();
                    if (n == null || !n.startsWith("tree ")) {
                        throw new CorruptObjectException(this.commitId, JGitText.get().corruptObjectNotree);
                    }
                    while ((n = br.readLine()) != null && n.startsWith("parent ")) {
                    }
                    if (n == null || !n.startsWith("author ")) {
                        throw new CorruptObjectException(this.commitId, JGitText.get().corruptObjectNoAuthor);
                    }
                    String rawAuthor = n.substring("author ".length());
                    n = br.readLine();
                    if (n == null || !n.startsWith("committer ")) {
                        throw new CorruptObjectException(this.commitId, JGitText.get().corruptObjectNoCommitter);
                    }
                    String rawCommitter = n.substring("committer ".length());
                    n = br.readLine();
                    if (n != null && n.startsWith("encoding")) {
                        this.encoding = Charset.forName(n.substring("encoding ".length()));
                    } else if (n == null || !n.equals("")) {
                        throw new CorruptObjectException(this.commitId, MessageFormat.format(JGitText.get().corruptObjectMalformedHeader, n));
                    }
                    byte[] readBuf = new byte[br.available()];
                    br.read(readBuf);
                    int n2 = readBuf.length != 0 ? (readBuf[0] == 10 ? 1 : 0) : (msgstart = 0);
                    if (this.encoding == null) {
                        this.encoding = Constants.CHARSET;
                    }
                    this.author = new PersonIdent(new String(rawAuthor.getBytes(), this.encoding.name()));
                    this.committer = new PersonIdent(new String(rawCommitter.getBytes(), this.encoding.name()));
                    this.message = new String(readBuf, msgstart, readBuf.length - msgstart, this.encoding.name());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.raw = null;
                }
            }
            finally {
                this.raw = null;
            }
        }
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public void commit() throws IOException {
        if (this.getCommitId() != null) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().commitAlreadyExists, this.getCommitId()));
        }
        ObjectInserter odi = this.objdb.newObjectInserter();
        try {
            ObjectId id = odi.insert(1, odi.format(this));
            odi.flush();
            this.setCommitId(id);
        }
        finally {
            odi.release();
        }
    }

    public String toString() {
        return "Commit[" + ObjectId.toString(this.getCommitId()) + " " + this.getAuthor() + "]";
    }

    public void setEncoding(String e) {
        this.encoding = Charset.forName(e);
    }

    public void setEncoding(Charset e) {
        this.encoding = e;
    }

    public String getEncoding() {
        if (this.encoding != null) {
            return this.encoding.name();
        }
        return null;
    }
}

