/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.OutputStream;

public abstract class FileMode {
    public static final int TYPE_MASK = 61440;
    public static final int TYPE_TREE = 16384;
    public static final int TYPE_SYMLINK = 40960;
    public static final int TYPE_FILE = 32768;
    public static final int TYPE_GITLINK = 57344;
    public static final int TYPE_MISSING = 0;
    public static final FileMode TREE = new FileMode(16384, 2){

        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 16384;
        }
    };
    public static final FileMode SYMLINK = new FileMode(40960, 3){

        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 40960;
        }
    };
    public static final FileMode REGULAR_FILE = new FileMode(33188, 3){

        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 32768 && (modeBits & 0x49) == 0;
        }
    };
    public static final FileMode EXECUTABLE_FILE = new FileMode(33261, 3){

        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 32768 && (modeBits & 0x49) != 0;
        }
    };
    public static final FileMode GITLINK = new FileMode(57344, 1){

        public boolean equals(int modeBits) {
            return (modeBits & 0xF000) == 57344;
        }
    };
    public static final FileMode MISSING = new FileMode(0, -1){

        public boolean equals(int modeBits) {
            return modeBits == 0;
        }
    };
    private final byte[] octalBytes;
    private final int modeBits;
    private final int objectType;

    public static final FileMode fromBits(final int bits) {
        switch (bits & 0xF000) {
            case 0: {
                if (bits != 0) break;
                return MISSING;
            }
            case 16384: {
                return TREE;
            }
            case 32768: {
                if ((bits & 0x49) != 0) {
                    return EXECUTABLE_FILE;
                }
                return REGULAR_FILE;
            }
            case 40960: {
                return SYMLINK;
            }
            case 57344: {
                return GITLINK;
            }
        }
        return new FileMode(bits, -1){

            public boolean equals(int a) {
                return bits == a;
            }
        };
    }

    private FileMode(int mode, int expType) {
        this.modeBits = mode;
        this.objectType = expType;
        if (mode != 0) {
            byte[] tmp = new byte[10];
            int p = tmp.length;
            while (mode != 0) {
                tmp[--p] = (byte)(48 + (mode & 7));
                mode >>= 3;
            }
            this.octalBytes = new byte[tmp.length - p];
            int k = 0;
            while (k < this.octalBytes.length) {
                this.octalBytes[k] = tmp[p + k];
                ++k;
            }
        } else {
            this.octalBytes = new byte[]{48};
        }
    }

    public abstract boolean equals(int var1);

    public void copyTo(OutputStream os) throws IOException {
        os.write(this.octalBytes);
    }

    public int copyToLength() {
        return this.octalBytes.length;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String toString() {
        return Integer.toOctalString(this.modeBits);
    }

    public int getBits() {
        return this.modeBits;
    }

    /* synthetic */ FileMode(int n, int n2, FileMode fileMode) {
        this(n, n2);
    }
}

