/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;

public class ObjectWriter {
    private final ObjectInserter inserter;

    public ObjectWriter(Repository d) {
        this.inserter = d.newObjectInserter();
    }

    public ObjectId writeBlob(byte[] b) throws IOException {
        try {
            ObjectId id = this.inserter.insert(3, b);
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId writeBlob(File f) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            ObjectId objectId = this.writeBlob(f.length(), is);
            return objectId;
        }
        finally {
            is.close();
        }
    }

    public ObjectId writeBlob(long len, InputStream is) throws IOException {
        try {
            ObjectId id = this.inserter.insert(3, len, is);
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId writeTree(Tree tree) throws IOException {
        try {
            ObjectId id = this.inserter.insert(2, this.inserter.format(tree));
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId writeCanonicalTree(byte[] treeData) throws IOException {
        try {
            ObjectId id = this.inserter.insert(2, treeData);
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId writeCommit(Commit commit) throws IOException {
        try {
            ObjectId id = this.inserter.insert(1, this.inserter.format(commit));
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId writeTag(Tag tag) throws IOException {
        try {
            ObjectId id = this.inserter.insert(4, this.inserter.format(tag));
            this.inserter.flush();
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }

    public ObjectId computeBlobSha1(long len, InputStream is) throws IOException {
        return this.computeObjectSha1(3, len, is);
    }

    public ObjectId computeObjectSha1(int type, long len, InputStream is) throws IOException {
        try {
            ObjectId objectId = this.inserter.idFor(type, len, is);
            return objectId;
        }
        finally {
            this.inserter.release();
        }
    }
}

