/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.UserConfig;
import org.eclipse.jgit.util.SystemReader;

public class PersonIdent {
    private final String name;
    private final String emailAddress;
    private final long when;
    private final int tzOffset;

    public PersonIdent(Repository repo) {
        UserConfig config = repo.getConfig().get(UserConfig.KEY);
        this.name = config.getCommitterName();
        this.emailAddress = config.getCommitterEmail();
        this.when = SystemReader.getInstance().getCurrentTime();
        this.tzOffset = SystemReader.getInstance().getTimezone(this.when);
    }

    public PersonIdent(PersonIdent pi) {
        this(pi.getName(), pi.getEmailAddress());
    }

    public PersonIdent(String aName, String aEmailAddress) {
        this.name = aName;
        this.emailAddress = aEmailAddress;
        this.when = SystemReader.getInstance().getCurrentTime();
        this.tzOffset = SystemReader.getInstance().getTimezone(this.when);
    }

    public PersonIdent(PersonIdent pi, Date when, TimeZone tz) {
        this(pi.getName(), pi.getEmailAddress(), when, tz);
    }

    public PersonIdent(PersonIdent pi, Date aWhen) {
        this.name = pi.getName();
        this.emailAddress = pi.getEmailAddress();
        this.when = aWhen.getTime();
        this.tzOffset = pi.tzOffset;
    }

    public PersonIdent(String aName, String aEmailAddress, Date aWhen, TimeZone aTZ) {
        this.name = aName;
        this.emailAddress = aEmailAddress;
        this.when = aWhen.getTime();
        this.tzOffset = aTZ.getOffset(this.when) / 60000;
    }

    public PersonIdent(String aName, String aEmailAddress, long aWhen, int aTZ) {
        this.name = aName;
        this.emailAddress = aEmailAddress;
        this.when = aWhen;
        this.tzOffset = aTZ;
    }

    public PersonIdent(PersonIdent pi, long aWhen, int aTZ) {
        this.name = pi.getName();
        this.emailAddress = pi.getEmailAddress();
        this.when = aWhen;
        this.tzOffset = aTZ;
    }

    public PersonIdent(String in) {
        int lt = in.indexOf(60);
        if (lt == -1) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().malformedpersonIdentString, in));
        }
        int gt = in.indexOf(62, lt);
        if (gt == -1) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().malformedpersonIdentString, in));
        }
        int sp = in.indexOf(32, gt + 2);
        if (sp == -1) {
            this.when = 0L;
            this.tzOffset = -1;
        } else {
            String tzHoursStr = in.substring(sp + 1, sp + 4).trim();
            int tzHours = tzHoursStr.charAt(0) == '+' ? Integer.parseInt(tzHoursStr.substring(1)) : Integer.parseInt(tzHoursStr);
            int tzMins = Integer.parseInt(in.substring(sp + 4).trim());
            this.when = Long.parseLong(in.substring(gt + 1, sp).trim()) * 1000L;
            this.tzOffset = tzHours * 60 + tzMins;
        }
        this.name = in.substring(0, lt).trim();
        this.emailAddress = in.substring(lt + 1, gt).trim();
    }

    public String getName() {
        return this.name;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public TimeZone getTimeZone() {
        StringBuilder tzId = new StringBuilder(8);
        tzId.append("GMT");
        this.appendTimezone(tzId);
        return TimeZone.getTimeZone(tzId.toString());
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public int hashCode() {
        return this.getEmailAddress().hashCode() ^ (int)this.when;
    }

    public boolean equals(Object o) {
        if (o instanceof PersonIdent) {
            PersonIdent p = (PersonIdent)o;
            return this.getName().equals(p.getName()) && this.getEmailAddress().equals(p.getEmailAddress()) && this.when == p.when;
        }
        return false;
    }

    public String toExternalString() {
        StringBuilder r = new StringBuilder();
        r.append(this.getName());
        r.append(" <");
        r.append(this.getEmailAddress());
        r.append("> ");
        r.append(this.when / 1000L);
        r.append(' ');
        this.appendTimezone(r);
        return r.toString();
    }

    private void appendTimezone(StringBuilder r) {
        char sign;
        int offset = this.tzOffset;
        if (offset < 0) {
            sign = '-';
            offset = -offset;
        } else {
            sign = '+';
        }
        int offsetHours = offset / 60;
        int offsetMins = offset % 60;
        r.append(sign);
        if (offsetHours < 10) {
            r.append('0');
        }
        r.append(offsetHours);
        if (offsetMins < 10) {
            r.append('0');
        }
        r.append(offsetMins);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        SimpleDateFormat dtfmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        dtfmt.setTimeZone(this.getTimeZone());
        r.append("PersonIdent[");
        r.append(this.getName());
        r.append(", ");
        r.append(this.getEmailAddress());
        r.append(", ");
        r.append(dtfmt.format(this.when));
        r.append("]");
        return r.toString();
    }
}

