/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.events.ListenerList;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.Commit;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.Tag;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.ReflogReader;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Repository {
    private static final ListenerList globalListeners = new ListenerList();
    private final AtomicInteger useCnt = new AtomicInteger(1);
    private final File gitDir;
    private final FS fs;
    private GitIndex index;
    private final ListenerList myListeners = new ListenerList();
    private final File workTree;
    private final File indexFile;

    public static ListenerList getGlobalListenerList() {
        return globalListeners;
    }

    protected Repository(BaseRepositoryBuilder options) {
        this.gitDir = options.getGitDir();
        this.fs = options.getFS();
        this.workTree = options.getWorkTree();
        this.indexFile = options.getIndexFile();
    }

    public ListenerList getListenerList() {
        return this.myListeners;
    }

    public void fireEvent(RepositoryEvent<?> event) {
        event.setRepository(this);
        this.myListeners.dispatch(event);
        globalListeners.dispatch(event);
    }

    public void create() throws IOException {
        this.create(false);
    }

    public abstract void create(boolean var1) throws IOException;

    public File getDirectory() {
        return this.gitDir;
    }

    public abstract File getObjectsDirectory();

    public abstract ObjectDatabase getObjectDatabase();

    public ObjectInserter newObjectInserter() {
        return this.getObjectDatabase().newInserter();
    }

    public ObjectReader newObjectReader() {
        return this.getObjectDatabase().newReader();
    }

    public abstract RefDatabase getRefDatabase();

    public abstract StoredConfig getConfig();

    public FS getFS() {
        return this.fs;
    }

    public boolean hasObject(AnyObjectId objectId) {
        try {
            return this.getObjectDatabase().has(objectId);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public ObjectLoader open(AnyObjectId objectId) throws MissingObjectException, IOException {
        return this.getObjectDatabase().open(objectId);
    }

    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.getObjectDatabase().open(objectId, typeHint);
    }

    @Deprecated
    public Commit mapCommit(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapCommit(id) : null;
    }

    @Deprecated
    public Object mapObject(ObjectId id, String refName) throws IOException {
        ObjectLoader or;
        try {
            or = this.open(id);
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
        byte[] raw = or.getCachedBytes();
        switch (or.getType()) {
            case 2: {
                return new Tree(this, id, raw);
            }
            case 1: {
                return new Commit(this, id, raw);
            }
            case 4: {
                return new Tag(this, id, refName, raw);
            }
            case 3: {
                return raw;
            }
        }
        throw new IncorrectObjectTypeException(id, JGitText.get().incorrectObjectType_COMMITnorTREEnorBLOBnorTAG);
    }

    @Deprecated
    public Commit mapCommit(ObjectId id) throws IOException {
        ObjectLoader or;
        try {
            or = this.open(id, 1);
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
        return new Commit(this, id, or.getCachedBytes());
    }

    @Deprecated
    public Tree mapTree(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTree(id) : null;
    }

    @Deprecated
    public Tree mapTree(ObjectId id) throws IOException {
        ObjectLoader or;
        try {
            or = this.open(id);
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
        byte[] raw = or.getCachedBytes();
        switch (or.getType()) {
            case 2: {
                return new Tree(this, id, raw);
            }
            case 1: {
                return this.mapTree(ObjectId.fromString(raw, 5));
            }
        }
        throw new IncorrectObjectTypeException(id, "tree");
    }

    @Deprecated
    public Tag mapTag(String revstr) throws IOException {
        ObjectId id = this.resolve(revstr);
        return id != null ? this.mapTag(revstr, id) : null;
    }

    @Deprecated
    public Tag mapTag(String refName, ObjectId id) throws IOException {
        ObjectLoader or;
        try {
            or = this.open(id);
        }
        catch (MissingObjectException missingObjectException) {
            return null;
        }
        if (or.getType() == 4) {
            return new Tag(this, id, refName, or.getCachedBytes());
        }
        return new Tag(this, id, refName, null);
    }

    public RefUpdate updateRef(String ref) throws IOException {
        return this.updateRef(ref, false);
    }

    public RefUpdate updateRef(String ref, boolean detach) throws IOException {
        return this.getRefDatabase().newUpdate(ref, detach);
    }

    public RefRename renameRef(String fromRef, String toRef) throws IOException {
        return this.getRefDatabase().newRename(fromRef, toRef);
    }

    public ObjectId resolve(String revstr) throws IOException {
        RevWalk rw = new RevWalk(this);
        try {
            ObjectId objectId = this.resolve(rw, revstr);
            return objectId;
        }
        finally {
            rw.release();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ObjectId resolve(RevWalk rw, String revstr) throws IOException {
        rev = revstr.toCharArray();
        ref /* !! */  = null;
        i = 0;
        while (i < rev.length) {
            block2 : switch (rev[i]) {
                case '^': {
                    if (ref /* !! */  == null && (ref /* !! */  = this.parseSimple(rw, new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (i + 1 < rev.length) {
                        switch (rev[i + 1]) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                ref /* !! */  = rw.parseCommit(ref /* !! */ );
                                j = i + 1;
                                while (j < rev.length) {
                                    if (!Character.isDigit(rev[j])) break;
                                    ++j;
                                }
                                parentnum = new String(rev, i + 1, j - i - 1);
                                try {
                                    pnum = Integer.parseInt(parentnum);
                                }
                                catch (NumberFormatException v0) {
                                    throw new RevisionSyntaxException(JGitText.get().invalidCommitParentNumber, revstr);
                                }
                                if (pnum != 0) {
                                    commit = (RevCommit)ref /* !! */ ;
                                    ref /* !! */  = pnum > commit.getParentCount() ? null : commit.getParent(pnum - 1);
                                }
                                i = j - 1;
                                break block2;
                            }
                            case '{': {
                                item = null;
                                k = i + 2;
                                while (k < rev.length) {
                                    if (rev[k] == '}') {
                                        item = new String(rev, i + 2, k - i - 2);
                                        break;
                                    }
                                    ++k;
                                }
                                i = k;
                                if (item != null) {
                                    if (item.equals("tree")) {
                                        ref /* !! */  = rw.parseTree(ref /* !! */ );
                                        break block2;
                                    }
                                    if (item.equals("commit")) {
                                        ref /* !! */  = rw.parseCommit(ref /* !! */ );
                                        break block2;
                                    }
                                    if (item.equals("blob")) {
                                        if ((ref /* !! */  = rw.peel((RevObject)ref /* !! */ )) instanceof RevBlob) break block2;
                                        throw new IncorrectObjectTypeException((ObjectId)ref /* !! */ , "blob");
                                    }
                                    if (item.equals("")) {
                                        ref /* !! */  = rw.peel((RevObject)ref /* !! */ );
                                        break block2;
                                    }
                                    throw new RevisionSyntaxException(revstr);
                                }
                                throw new RevisionSyntaxException(revstr);
                            }
                            default: {
                                ref /* !! */  = rw.parseAny(ref /* !! */ );
                                if (ref /* !! */  instanceof RevCommit) {
                                    commit = (RevCommit)ref /* !! */ ;
                                    if (commit.getParentCount() == 0) {
                                        ref /* !! */  = null;
                                        break block2;
                                    }
                                    ref /* !! */  = commit.getParent(0);
                                    break block2;
                                }
                                throw new IncorrectObjectTypeException((ObjectId)ref /* !! */ , "commit");
                            }
                        }
                    }
                    if ((ref /* !! */  = rw.peel((RevObject)ref /* !! */ )) instanceof RevCommit) {
                        commit = (RevCommit)ref /* !! */ ;
                        if (commit.getParentCount() == 0) {
                            ref /* !! */  = null;
                            break;
                        }
                        ref /* !! */  = commit.getParent(0);
                        break;
                    }
                    throw new IncorrectObjectTypeException((ObjectId)ref /* !! */ , "commit");
                }
                case '~': {
                    if (ref /* !! */  == null && (ref /* !! */  = this.parseSimple(rw, new String(rev, 0, i))) == null) {
                        return null;
                    }
                    if (!((ref /* !! */  = rw.peel((RevObject)ref /* !! */ )) instanceof RevCommit)) {
                        throw new IncorrectObjectTypeException((ObjectId)ref /* !! */ , "commit");
                    }
                    l = i + 1;
                    while (l < rev.length) {
                        if (!Character.isDigit(rev[l])) break;
                        ++l;
                    }
                    distnum = new String(rev, i + 1, l - i - 1);
                    try {
                        dist = Integer.parseInt(distnum);
                        if (true) ** GOTO lbl96
                    }
                    catch (NumberFormatException v1) {
                        throw new RevisionSyntaxException(JGitText.get().invalidAncestryLength, revstr);
                    }
                    do {
                        if ((commit = (RevCommit)ref /* !! */ ).getParentCount() == 0) {
                            ref /* !! */  = null;
                            break;
                        }
                        commit = commit.getParent(0);
                        rw.parseHeaders(commit);
                        ref /* !! */  = commit;
                        --dist;
lbl96:
                        // 2 sources

                    } while (dist > 0);
                    i = l - 1;
                    break;
                }
                case '@': {
                    time = null;
                    m = i + 2;
                    while (m < rev.length) {
                        if (rev[m] == '}') {
                            time = new String(rev, i + 2, m - i - 2);
                            break;
                        }
                        ++m;
                    }
                    if (time != null) {
                        throw new RevisionSyntaxException(JGitText.get().reflogsNotYetSupportedByRevisionParser, revstr);
                    }
                    i = m - 1;
                    break;
                }
                default: {
                    if (ref /* !! */  == null) break;
                    throw new RevisionSyntaxException(revstr);
                }
            }
            ++i;
        }
        return ref /* !! */  != null ? ref /* !! */ .copy() : this.resolveSimple(revstr);
    }

    private RevObject parseSimple(RevWalk rw, String revstr) throws IOException {
        ObjectId id = this.resolveSimple(revstr);
        return id != null ? rw.parseAny(id) : null;
    }

    private ObjectId resolveSimple(String revstr) throws IOException {
        if (ObjectId.isId(revstr)) {
            return ObjectId.fromString(revstr);
        }
        Ref r = this.getRefDatabase().getRef(revstr);
        return r != null ? r.getObjectId() : null;
    }

    public void incrementOpen() {
        this.useCnt.incrementAndGet();
    }

    public void close() {
        if (this.useCnt.decrementAndGet() == 0) {
            this.doClose();
        }
    }

    protected void doClose() {
        this.getObjectDatabase().close();
        this.getRefDatabase().close();
    }

    public abstract void openPack(File var1, File var2) throws IOException;

    public String toString() {
        String desc = this.getDirectory() != null ? this.getDirectory().getPath() : String.valueOf(this.getClass().getSimpleName()) + "-" + System.identityHashCode(this);
        return "Repository[" + desc + "]";
    }

    public String getFullBranch() throws IOException {
        Ref head = this.getRef("HEAD");
        if (head == null) {
            return null;
        }
        if (head.isSymbolic()) {
            return head.getTarget().getName();
        }
        if (head.getObjectId() != null) {
            return head.getObjectId().name();
        }
        return null;
    }

    public String getBranch() throws IOException {
        String name = this.getFullBranch();
        if (name != null) {
            return this.shortenRefName(name);
        }
        return name;
    }

    public Set<ObjectId> getAdditionalHaves() {
        return Collections.emptySet();
    }

    public Ref getRef(String name) throws IOException {
        return this.getRefDatabase().getRef(name);
    }

    public Map<String, Ref> getAllRefs() {
        try {
            return this.getRefDatabase().getRefs("");
        }
        catch (IOException iOException) {
            return new HashMap<String, Ref>();
        }
    }

    public Map<String, Ref> getTags() {
        try {
            return this.getRefDatabase().getRefs("refs/tags/");
        }
        catch (IOException iOException) {
            return new HashMap<String, Ref>();
        }
    }

    public Ref peel(Ref ref) {
        try {
            return this.getRefDatabase().peel(ref);
        }
        catch (IOException iOException) {
            return ref;
        }
    }

    public Map<AnyObjectId, Set<Ref>> getAllRefsByPeeledObjectId() {
        Map<String, Ref> allRefs = this.getAllRefs();
        HashMap<AnyObjectId, Set<Ref>> ret = new HashMap<AnyObjectId, Set<Ref>>(allRefs.size());
        for (Ref ref : allRefs.values()) {
            Set<Ref> oset;
            ObjectId target = (ref = this.peel(ref)).getPeeledObjectId();
            if (target == null) {
                target = ref.getObjectId();
            }
            if ((oset = ret.put(target, Collections.singleton(ref))) == null) continue;
            if (oset.size() == 1) {
                oset = new HashSet<Ref>(oset);
            }
            ret.put(target, oset);
            oset.add(ref);
        }
        return ret;
    }

    public GitIndex getIndex() throws IOException, NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        if (this.index == null) {
            this.index = new GitIndex(this);
            this.index.read();
        } else {
            this.index.rereadIfNecessary();
        }
        return this.index;
    }

    public File getIndexFile() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.indexFile;
    }

    public DirCache readDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.read(this.getIndexFile(), this.getFS());
    }

    public DirCache lockDirCache() throws NoWorkTreeException, CorruptObjectException, IOException {
        return DirCache.lock(this.getIndexFile(), this.getFS());
    }

    static byte[] gitInternalSlash(byte[] bytes) {
        if (File.separatorChar == '/') {
            return bytes;
        }
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] == File.separatorChar) {
                bytes[i] = 47;
            }
            ++i;
        }
        return bytes;
    }

    public RepositoryState getRepositoryState() {
        if (this.isBare() || this.getDirectory() == null) {
            return RepositoryState.BARE;
        }
        if (new File(this.getWorkTree(), ".dotest").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), ".dotest-merge").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-apply/rebasing").exists()) {
            return RepositoryState.REBASING_REBASING;
        }
        if (new File(this.getDirectory(), "rebase-apply/applying").exists()) {
            return RepositoryState.APPLY;
        }
        if (new File(this.getDirectory(), "rebase-apply").exists()) {
            return RepositoryState.REBASING;
        }
        if (new File(this.getDirectory(), "rebase-merge/interactive").exists()) {
            return RepositoryState.REBASING_INTERACTIVE;
        }
        if (new File(this.getDirectory(), "rebase-merge").exists()) {
            return RepositoryState.REBASING_MERGE;
        }
        if (new File(this.getDirectory(), "MERGE_HEAD").exists()) {
            try {
                if (!this.readDirCache().hasUnmergedPaths()) {
                    return RepositoryState.MERGING_RESOLVED;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return RepositoryState.MERGING;
        }
        if (new File(this.getDirectory(), "BISECT_LOG").exists()) {
            return RepositoryState.BISECTING;
        }
        return RepositoryState.SAFE;
    }

    public static boolean isValidRefName(String refName) {
        int len = refName.length();
        if (len == 0) {
            return false;
        }
        if (refName.endsWith(".lock")) {
            return false;
        }
        int components = 1;
        int p = 0;
        int i = 0;
        while (i < len) {
            char c = refName.charAt(i);
            if (c <= ' ') {
                return false;
            }
            switch (c) {
                case '.': {
                    switch (p) {
                        case 0: 
                        case 46: 
                        case 47: {
                            return false;
                        }
                    }
                    if (i != len - 1) break;
                    return false;
                }
                case '/': {
                    if (i == 0 || i == len - 1) {
                        return false;
                    }
                    ++components;
                    break;
                }
                case '{': {
                    if (p != 64) break;
                    return false;
                }
                case '*': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '~': {
                    return false;
                }
            }
            p = c;
            ++i;
        }
        return components > 1;
    }

    public static String stripWorkDir(File workDir, File file) {
        String filePath = file.getPath();
        String workDirPath = workDir.getPath();
        if (filePath.length() <= workDirPath.length() || filePath.charAt(workDirPath.length()) != File.separatorChar || !filePath.startsWith(workDirPath)) {
            File absFile;
            File absWd = workDir.isAbsolute() ? workDir : workDir.getAbsoluteFile();
            File file2 = absFile = file.isAbsolute() ? file : file.getAbsoluteFile();
            if (absWd == workDir && absFile == file) {
                return "";
            }
            return Repository.stripWorkDir(absWd, absFile);
        }
        String relName = filePath.substring(workDirPath.length() + 1);
        if (File.separatorChar != '/') {
            relName = relName.replace(File.separatorChar, '/');
        }
        return relName;
    }

    public boolean isBare() {
        return this.workTree == null;
    }

    public File getWorkTree() throws NoWorkTreeException {
        if (this.isBare()) {
            throw new NoWorkTreeException();
        }
        return this.workTree;
    }

    public abstract void scanForRepoChanges() throws IOException;

    public String shortenRefName(String refName) {
        if (refName.startsWith("refs/heads/")) {
            return refName.substring("refs/heads/".length());
        }
        if (refName.startsWith("refs/tags/")) {
            return refName.substring("refs/tags/".length());
        }
        if (refName.startsWith("refs/remotes/")) {
            return refName.substring("refs/remotes/".length());
        }
        return refName;
    }

    public abstract ReflogReader getReflogReader(String var1) throws IOException;

    public String readMergeCommitMsg() throws IOException, NoWorkTreeException {
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File mergeMsgFile = new File(this.getDirectory(), "MERGE_MSG");
        try {
            return RawParseUtils.decode(IO.readFully(mergeMsgFile));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public void writeMergeCommitMsg(String msg) throws IOException {
        File mergeMsgFile = new File(this.gitDir, "MERGE_MSG");
        if (msg != null) {
            FileOutputStream fos = new FileOutputStream(mergeMsgFile);
            try {
                fos.write(msg.getBytes("UTF-8"));
            }
            finally {
                fos.close();
            }
        } else {
            mergeMsgFile.delete();
        }
    }

    public List<ObjectId> readMergeHeads() throws IOException, NoWorkTreeException {
        byte[] raw;
        if (this.isBare() || this.getDirectory() == null) {
            throw new NoWorkTreeException();
        }
        File mergeHeadFile = new File(this.getDirectory(), "MERGE_HEAD");
        try {
            raw = IO.readFully(mergeHeadFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        if (raw.length == 0) {
            return null;
        }
        LinkedList<ObjectId> heads = new LinkedList<ObjectId>();
        int p = 0;
        while (p < raw.length) {
            heads.add(ObjectId.fromString(raw, p));
            p = RawParseUtils.nextLF(raw, p + 40);
        }
        return heads;
    }

    public void writeMergeHeads(List<ObjectId> heads) throws IOException {
        File mergeHeadFile = new File(this.gitDir, "MERGE_HEAD");
        if (heads != null) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(mergeHeadFile));
            try {
                for (ObjectId id : heads) {
                    id.copyTo(bos);
                    bos.write(10);
                }
            }
            finally {
                bos.close();
            }
        } else {
            mergeHeadFile.delete();
        }
    }
}

