/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.ObjectWritingException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

public class Tag {
    private final Repository objdb;
    private ObjectId tagId;
    private PersonIdent tagger;
    private String message;
    private byte[] raw;
    private String type;
    private String tag;
    private ObjectId objId;

    public Tag(Repository db) {
        this.objdb = db;
    }

    public Tag(Repository db, ObjectId id, String refName, byte[] raw) {
        this.objdb = db;
        if (raw != null) {
            this.tagId = id;
            this.objId = ObjectId.fromString(raw, 7);
        } else {
            this.objId = id;
        }
        if (refName != null && refName.startsWith("refs/tags/")) {
            refName = refName.substring(10);
        }
        this.tag = refName;
        this.raw = raw;
    }

    public PersonIdent getAuthor() {
        this.decode();
        return this.tagger;
    }

    public void setAuthor(PersonIdent a) {
        this.tagger = a;
    }

    public String getMessage() {
        this.decode();
        return this.message;
    }

    private void decode() {
        if (this.raw != null) {
            try {
                try {
                    int readLen;
                    BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.raw)));
                    String n = br.readLine();
                    if (n == null || !n.startsWith("object ")) {
                        throw new CorruptObjectException(this.tagId, JGitText.get().corruptObjectNoObject);
                    }
                    this.objId = ObjectId.fromString(n.substring(7));
                    n = br.readLine();
                    if (n == null || !n.startsWith("type ")) {
                        throw new CorruptObjectException(this.tagId, JGitText.get().corruptObjectNoType);
                    }
                    this.type = n.substring("type ".length());
                    n = br.readLine();
                    if (n == null || !n.startsWith("tag ")) {
                        throw new CorruptObjectException(this.tagId, JGitText.get().corruptObjectNoTagName);
                    }
                    this.tag = n.substring("tag ".length());
                    n = br.readLine();
                    if (n == null) {
                        throw new CorruptObjectException(this.tagId, JGitText.get().corruptObjectNoTaggerHeader);
                    }
                    if (n.length() > 0) {
                        if (n.startsWith("tagger ")) {
                            this.tagger = new PersonIdent(n.substring("tagger ".length()));
                        } else {
                            throw new CorruptObjectException(this.tagId, JGitText.get().corruptObjectNoTaggerBadHeader);
                        }
                    }
                    StringBuilder tempMessage = new StringBuilder();
                    char[] readBuf = new char[2048];
                    while ((readLen = br.read(readBuf)) > 0) {
                        tempMessage.append(readBuf, 0, readLen);
                    }
                    this.message = tempMessage.toString();
                    if (this.message.startsWith("\n")) {
                        this.message = this.message.substring(1);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.raw = null;
                }
            }
            finally {
                this.raw = null;
            }
        }
    }

    public void setMessage(String m) {
        this.message = m;
    }

    public void tag() throws IOException {
        ObjectId id;
        if (this.getTagId() != null) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().illegalStateExists, this.getTagId()));
        }
        if (this.tagger != null || this.message != null || this.type != null) {
            ObjectInserter odi = this.objdb.newObjectInserter();
            try {
                id = odi.insert(4, odi.format(this));
                odi.flush();
                this.setTagId(id);
            }
            finally {
                odi.release();
            }
        } else {
            id = this.objId;
        }
        RefUpdate ru = this.objdb.updateRef("refs/tags/" + this.getTag());
        ru.setNewObjectId(id);
        ru.setRefLogMessage("tagged " + this.getTag(), false);
        if (ru.forceUpdate() == RefUpdate.Result.LOCK_FAILURE) {
            throw new ObjectWritingException(MessageFormat.format(JGitText.get().unableToLockTag, this.getTag()));
        }
    }

    public String toString() {
        return "tag[" + this.getTag() + this.getType() + this.getObjId() + " " + this.getAuthor() + "]";
    }

    public ObjectId getTagId() {
        return this.tagId;
    }

    public void setTagId(ObjectId tagId) {
        this.tagId = tagId;
    }

    public PersonIdent getTagger() {
        this.decode();
        return this.tagger;
    }

    public void setTagger(PersonIdent tagger) {
        this.tagger = tagger;
    }

    public String getType() {
        this.decode();
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public ObjectId getObjId() {
        return this.objId;
    }

    public void setObjId(ObjectId objId) {
        this.objId = objId;
    }
}

