/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revwalk.RevCommit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommit<L extends PlotLane>
extends RevCommit {
    static final PlotCommit[] NO_CHILDREN = new PlotCommit[0];
    static final PlotLane[] NO_LANES = new PlotLane[0];
    PlotLane[] passingLanes = NO_LANES;
    PlotLane lane;
    PlotCommit[] children = NO_CHILDREN;
    Ref[] refs;

    protected PlotCommit(AnyObjectId id) {
        super(id);
    }

    void addPassingLane(PlotLane c) {
        int cnt = this.passingLanes.length;
        if (cnt == 0) {
            this.passingLanes = new PlotLane[]{c};
        } else if (cnt == 1) {
            this.passingLanes = new PlotLane[]{this.passingLanes[0], c};
        } else {
            PlotLane[] n = new PlotLane[cnt + 1];
            System.arraycopy(this.passingLanes, 0, n, 0, cnt);
            n[cnt] = c;
            this.passingLanes = n;
        }
    }

    void addChild(PlotCommit c) {
        int cnt = this.children.length;
        if (cnt == 0) {
            this.children = new PlotCommit[]{c};
        } else if (cnt == 1) {
            this.children = new PlotCommit[]{this.children[0], c};
        } else {
            PlotCommit[] n = new PlotCommit[cnt + 1];
            System.arraycopy(this.children, 0, n, 0, cnt);
            n[cnt] = c;
            this.children = n;
        }
    }

    public final int getChildCount() {
        return this.children.length;
    }

    public final PlotCommit getChild(int nth) {
        return this.children[nth];
    }

    public final boolean isChild(PlotCommit c) {
        PlotCommit[] plotCommitArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            PlotCommit a = plotCommitArray[n2];
            if (a == c) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public final L getLane() {
        return (L)this.lane;
    }

    @Override
    public void reset() {
        this.passingLanes = NO_LANES;
        this.children = NO_CHILDREN;
        this.lane = null;
        super.reset();
    }
}

