/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotCommitList<L extends PlotLane>
extends RevCommitList<PlotCommit<L>> {
    static final int MAX_LENGTH = 25;
    private int lanesAllocated;
    private final TreeSet<Integer> freeLanes = new TreeSet();
    private final HashSet<PlotLane> activeLanes = new HashSet(32);

    @Override
    public void clear() {
        super.clear();
        this.lanesAllocated = 0;
        this.freeLanes.clear();
        this.activeLanes.clear();
    }

    @Override
    public void source(RevWalk w) {
        if (!(w instanceof PlotWalk)) {
            throw new ClassCastException(MessageFormat.format(JGitText.get().classCastNotA, PlotWalk.class.getName()));
        }
        super.source(w);
    }

    public void findPassingThrough(PlotCommit<L> currCommit, Collection<L> result) {
        PlotLane[] plotLaneArray = currCommit.passingLanes;
        int n = currCommit.passingLanes.length;
        int n2 = 0;
        while (n2 < n) {
            PlotLane p = plotLaneArray[n2];
            result.add(p);
            ++n2;
        }
    }

    @Override
    protected void enter(int index, PlotCommit<L> currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            return;
        }
        if (nChildren == 1 && currCommit.children[0].getParentCount() < 2) {
            PlotCommit c = currCommit.children[0];
            if (c.lane == null) {
                c.lane = this.nextFreeLane();
                this.activeLanes.add(c.lane);
            }
            int r = index - 1;
            while (r >= 0) {
                PlotCommit rObj = (PlotCommit)this.get(r);
                if (rObj == c) break;
                rObj.addPassingLane(c.lane);
                --r;
            }
            currCommit.lane = c.lane;
        } else {
            int i = 0;
            while (i < nChildren) {
                PlotCommit c = currCommit.children[i];
                if (this.activeLanes.remove(c.lane)) {
                    this.recycleLane(c.lane);
                    this.freeLanes.add(c.lane.getPosition());
                }
                ++i;
            }
            currCommit.lane = this.nextFreeLane();
            this.activeLanes.add(currCommit.lane);
            int remaining = nChildren;
            int r = index - 1;
            while (r >= 0) {
                PlotCommit rObj = (PlotCommit)this.get(r);
                if (currCommit.isChild(rObj) && --remaining == 0) break;
                rObj.addPassingLane(currCommit.lane);
                --r;
            }
        }
    }

    private void setupChildren(PlotCommit<L> currCommit) {
        int nParents = currCommit.getParentCount();
        int i = 0;
        while (i < nParents) {
            ((PlotCommit)currCommit.getParent(i)).addChild(currCommit);
            ++i;
        }
    }

    private PlotLane nextFreeLane() {
        L p = this.createLane();
        if (this.freeLanes.isEmpty()) {
            ((PlotLane)p).position = this.lanesAllocated++;
        } else {
            Integer min = this.freeLanes.first();
            ((PlotLane)p).position = min;
            this.freeLanes.remove(min);
        }
        return p;
    }

    protected L createLane() {
        return (L)new PlotLane();
    }

    protected void recycleLane(L lane) {
    }
}

