/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.StopWalkException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.DateRevQueue;
import org.eclipse.jgit.revwalk.Generator;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

class PendingGenerator
extends Generator {
    private static final int PARSED = 1;
    private static final int SEEN = 2;
    private static final int UNINTERESTING = 4;
    static final int OVER_SCAN = 6;
    private static final RevCommit INIT_LAST = new RevCommit(ObjectId.zeroId());
    private final RevWalk walker;
    private final DateRevQueue pending;
    private final RevFilter filter;
    private final int output;
    private RevCommit last = INIT_LAST;
    private int overScan = 6;
    boolean canDispose;

    static {
        PendingGenerator.INIT_LAST.commitTime = Integer.MAX_VALUE;
    }

    PendingGenerator(RevWalk w, DateRevQueue p, RevFilter f, int out) {
        this.walker = w;
        this.pending = p;
        this.filter = f;
        this.output = out;
        this.canDispose = true;
    }

    int outputType() {
        return this.output | 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        try {
            while (true) {
                boolean produce;
                RevCommit c;
                block10: {
                    block12: {
                        block11: {
                            if ((c = this.pending.next()) == null) {
                                this.walker.reader.release();
                                return null;
                            }
                            produce = (c.flags & 4) != 0 ? false : this.filter.include(this.walker, c);
                            RevCommit[] revCommitArray = c.parents;
                            int n = c.parents.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) {
                                    this.walker.carryFlagsImpl(c);
                                    if ((c.flags & 4) == 0) break block10;
                                    if (!this.pending.everbodyHasFlag(4)) break block11;
                                    RevCommit n3 = this.pending.peek();
                                    if (n3 == null || n3.commitTime < this.last.commitTime) break;
                                    this.overScan = 6;
                                    break block12;
                                }
                                RevCommit p = revCommitArray[n2];
                                if ((p.flags & 2) == 0) {
                                    if ((p.flags & 1) == 0) {
                                        p.parseHeaders(this.walker);
                                    }
                                    p.flags |= 2;
                                    this.pending.add(p);
                                }
                                ++n2;
                            }
                            if (--this.overScan == 0) {
                                throw StopWalkException.INSTANCE;
                            }
                            break block12;
                        }
                        this.overScan = 6;
                    }
                    if (!this.canDispose) continue;
                    c.disposeBody();
                    continue;
                }
                if (produce) {
                    this.last = c;
                    return this.last;
                }
                if (!this.canDispose) continue;
                c.disposeBody();
            }
        }
        catch (StopWalkException stopWalkException) {
            this.walker.reader.release();
            this.pending.clear();
            return null;
        }
    }
}

